/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndFieldDescriptor;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Enumeration;
import java.util.TreeSet;

class ExportComponent
extends Safeptr {
    ExportFile exportfile = null;

    ExportComponent(byte[] data) {
        super(data, "Export");
    }

    private void addInterfaceAndSuperinterfaces(TreeSet allIntf, int iref) {
        EfClass ec = Classref.toExportClass(iref);
        allIntf.add(ec.thisName());
        if (Classref.isExternal(iref)) {
            int i = 0;
            while (i < ec.interfaces.length) {
                allIntf.add(ec.interfaceName(i));
                ++i;
            }
        } else {
            ClassInfo cinfo = Cap.Class.infoOfs(iref);
            int i = 0;
            while (i < cinfo.interfaceCount()) {
                int siref = cinfo.superinterface(i);
                this.addInterfaceAndSuperinterfaces(allIntf, siref);
                ++i;
            }
        }
    }

    private TreeSet allActualInterfaces(int cref) {
        TreeSet<String> allIntf = new TreeSet<String>();
        ClassInfo cinfo = Cap.Class.infoOfs(cref);
        if ((cinfo.flags() & 8) != 0) {
            int i = 0;
            while (i < cinfo.interfaceCount()) {
                int iref = cinfo.superinterface(i);
                this.addInterfaceAndSuperinterfaces(allIntf, iref);
                ++i;
            }
        } else {
            ClassDescriptor cdesc = Classref.checkInternal(cref);
            int i = 0;
            while (i < cdesc.interfaceCount()) {
                int iref = cdesc.interfaceRef(i);
                EfClass ec = Classref.toExportClass(iref);
                if (ec != null) {
                    allIntf.add(ec.thisName());
                }
                ++i;
            }
        }
        return allIntf;
    }

    private TreeSet allActualSuperclasses(int cref) {
        EfClass ec;
        TreeSet<String> allSuper = new TreeSet<String>();
        if ((Cap.Class.infoOfs(cref).flags() & 8) != 0) {
            allSuper.add("java/lang/Object");
            return allSuper;
        }
        do {
            if ((cref = Cap.Class.infoOfs(cref).superclass()) == 65535) {
                return allSuper;
            }
            ec = Classref.toExportClass(cref);
            if (ec == null) continue;
            allSuper.add(ec.thisName());
        } while (!Classref.isExternal(cref));
        ec = Classref.toExportClass(cref);
        allSuper.add(ec.thisName());
        int i = 0;
        while (i < ec.supers.length) {
            allSuper.add(ec.superName(i));
            ++i;
        }
        return allSuper;
    }

    private TreeSet allClaimedInterfaces(EfClass ec) {
        TreeSet<String> allIntf = new TreeSet<String>();
        int i = 0;
        while (i < ec.interfaces.length) {
            allIntf.add(ec.interfaceName(i));
            ++i;
        }
        return allIntf;
    }

    private TreeSet allClaimedSuperclasses(EfClass ec) {
        TreeSet<String> allSuper = new TreeSet<String>();
        int i = 0;
        while (i < ec.supers.length) {
            allSuper.add(ec.superName(i));
            ++i;
        }
        return allSuper;
    }

    private void checkExportClass(EfClass ec) {
        try {
            int cref = Classref.forExportToken(ec.token);
            ClassDescriptor cdesc = Classref.checkInternal(cref);
            int flags = 0;
            if ((ec.accessFlag & 1) != 0) {
                flags |= 1;
            }
            if ((ec.accessFlag & 0x10) != 0) {
                flags |= 0x10;
            }
            if ((ec.accessFlag & 0x200) != 0) {
                flags |= 0x40;
            }
            if ((ec.accessFlag & 0x400) != 0) {
                flags |= 0x80;
            }
            if (flags != cdesc.flags()) {
                throw new VerifierError("ExportComponent.18");
            }
            if (!this.allClaimedInterfaces(ec).equals(this.allActualInterfaces(cref))) {
                throw new VerifierError("ExportComponent.19");
            }
            if (!this.allClaimedSuperclasses(ec).equals(this.allActualSuperclasses(cref))) {
                throw new VerifierError("ExportComponent.20");
            }
            int numExportedFields = 0;
            int i = 0;
            while (i < ec.fields.length) {
                EfField efld = ec.fields[i];
                if (efld.token != 255) {
                    this.checkExportField(ec, efld, cdesc.thisClass());
                    ++numExportedFields;
                }
                ++i;
            }
            if (numExportedFields != this.numPublicFields(cdesc)) {
                throw new VerifierError("ExportComponent.42");
            }
            int i2 = 0;
            while (i2 < ec.methods.length) {
                EfMethod em = ec.methods[i2];
                this.checkExportMethod(ec, em, cdesc.thisClass());
                ++i2;
            }
            if (ec.methods.length != this.numPublicMethods(cdesc)) {
                throw new VerifierError("ExportComponent.43");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportComponent.21", (Object)ec, (Object)e.getMessage());
        }
    }

    private void checkExportField(EfClass ec, EfField ef, int classref) {
        try {
            boolean isStatic = (ef.accessFlag & 8) != 0;
            FieldTypeAndFlags ftyf = Fieldref.findByToken(classref, ef.token, isStatic);
            int flags = 0;
            if ((ef.accessFlag & 1) != 0) {
                flags |= 1;
            }
            if ((ef.accessFlag & 4) != 0) {
                flags |= 4;
            }
            if ((ef.accessFlag & 8) != 0) {
                flags |= 8;
            }
            if ((ef.accessFlag & 0x10) != 0) {
                flags |= 0x10;
            }
            if (flags != ftyf.flags) {
                throw new VerifierError("ExportComponent.28");
            }
            Type ty = Type.parseExport(ef.sig());
            if (!ty.equals(ftyf.fty)) {
                throw new VerifierError("ExportComponent.29");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportComponent.30", (Object)ef, (Object)e.getMessage());
        }
    }

    private void checkExportMethod(EfClass ec, EfMethod em, int classref) {
        try {
            boolean isStatic = (em.accessFlag & 8) != 0 || em.name().equals("<init>");
            MethodTypeAndFlags mtyf = Methodref.findByToken(classref, em.token, isStatic);
            if (mtyf == null) {
                throw new VerifierError("ExportComponent.38");
            }
            int flags = 0;
            if ((em.accessFlag & 1) != 0) {
                flags |= 1;
            }
            if ((em.accessFlag & 4) != 0) {
                flags |= 4;
            }
            if ((em.accessFlag & 8) != 0) {
                flags |= 8;
            }
            if ((em.accessFlag & 0x10) != 0) {
                flags |= 0x10;
            }
            if ((em.accessFlag & 0x400) != 0) {
                flags |= 0x40;
            }
            if (em.name().equals("<init>")) {
                flags |= 0x80;
            }
            if (flags != mtyf.flags) {
                throw new VerifierError("ExportComponent.33");
            }
            TypeMethod ty = TypeMethod.parseExport(em.sig());
            if (!ty.equals(mtyf.mty)) {
                throw new VerifierError("ExportComponent.34");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportComponent.35", (Object)em, (Object)e.getMessage());
        }
    }

    private boolean checkImplementedInterface(int cref, String intfname) {
        if (!Classref.isExternal(cref)) {
            ClassDescriptor cdesc = Classref.checkInternal(cref);
            int i = 0;
            while (i < cdesc.interfaceCount()) {
                int iref = cdesc.interfaceRef(i);
                EfClass ec = Classref.toExportClass(iref);
                if (ec != null && intfname.equals(ec.thisName())) {
                    return true;
                }
                if (this.checkImplementedInterface(iref, intfname)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        EfClass ec = Classref.toExportClass(cref);
        int i = 0;
        while (i < ec.interfaces.length) {
            if (intfname.equals(ec.interfaceName(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int classCount() {
        return this.u1(0);
    }

    EfClass exportclassForToken(int token) {
        int i = 0;
        while (i < this.exportfile.classes.length) {
            EfClass ec = this.exportfile.classes[i];
            if (ec.token == token) {
                return ec;
            }
            ++i;
        }
        throw new VerifierError("ExportComponent.36", token);
    }

    void findExportFile() {
        PackageInfo pkg = Cap.Header.thisPackage();
        this.exportfile = ImportComponent.findExportByAidAndVersion(pkg);
        if (this.exportfile == null) {
            throw new VerifierError("ExportComponent.1", (Object)AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion());
        }
    }

    ExportedClass firstExportedClass() {
        return new ExportedClass(this.offset(1));
    }

    private int numPublicFields(ClassDescriptor c) {
        int n = 0;
        int i = 0;
        while (i < c.fieldCount()) {
            FieldDescriptor fd = c.fieldDescr(i);
            if ((fd.flags() & 5) != 0) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    private int numPublicMethods(ClassDescriptor c) {
        int nstatic = 0;
        TreeSet<Integer> tokens = new TreeSet<Integer>();
        int i = 0;
        while (i < c.methodCount()) {
            MethodDescriptor md = c.methodDescr(i);
            if ((md.flags() & 5) != 0) {
                if ((md.flags() & 0x88) != 0) {
                    ++nstatic;
                } else {
                    tokens.add(new Integer(md.token()));
                }
            }
            ++i;
        }
        if ((c.flags() & 0x40) == 0) {
            int i2;
            int cref = c.thisClass();
            while (!Classref.isExternal(cref = Cap.Class.infoOfs(cref).superclass())) {
                ClassDescriptor cd = Classref.checkInternal(cref);
                i2 = 0;
                while (i2 < cd.methodCount()) {
                    MethodDescriptor md = cd.methodDescr(i2);
                    if ((md.flags() & 5) != 0 && (md.flags() & 0x88) == 0) {
                        tokens.add(new Integer(md.token()));
                    }
                    ++i2;
                }
            }
            if (cref != 65535) {
                EfClass ec = Classref.checkExternal(cref);
                i2 = 0;
                while (i2 < ec.methods.length) {
                    EfMethod em = ec.methods[i2];
                    if (!em.isStaticOrInit()) {
                        tokens.add(new Integer(em.token));
                    }
                    ++i2;
                }
            }
        }
        return nstatic + tokens.size();
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.101");
        }
        if (this.classCount() >= 256) {
            throw new VerifierError("ExportComponent.2", this.classCount());
        }
        if (this.classCount() == 0) {
            throw new VerifierError("ExportComponent.44");
        }
        ExportedClass ecls = this.firstExportedClass();
        int i = 0;
        while (i < this.classCount()) {
            this.verifyClass(i, ecls);
            ecls.next();
            ++i;
        }
        if (!ecls.atComponentEnd()) {
            throw new VerifierError("ExportComponent.3");
        }
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.102", this.exportfile.file);
        }
        this.verifyExport();
        PackageInfo pkg = Cap.Header.thisPackage();
        Enumeration e = ImportComponent.findAllExportByAid(pkg).elements();
        while (e.hasMoreElements()) {
            ExportFile ef = (ExportFile)e.nextElement();
            if (ef == this.exportfile) continue;
            EfConstant_Package epkg = ef.thisPackage();
            if (Verifier.verbose >= 1) {
                Messages.println("ExportComponent.100", (Object)ef.file, (int)epkg.majorVersion, (int)epkg.minorVersion);
            }
            try {
                this.exportfile = ef;
                this.verifyExport();
            }
            catch (VerifierError err) {
                throw new VerifierError("ExportComponent.37", err.getMessage(), pkg.majorVersion(), pkg.minorVersion(), epkg.majorVersion, epkg.minorVersion);
            }
        }
    }

    private void verifyClass(int token, ExportedClass ecls) {
        ClassDescriptor cdesc = Classref.checkInternal(ecls.classOffset());
        if ((cdesc.flags() & 1) == 0) {
            throw new VerifierError("ExportComponent.6", token);
        }
        if (cdesc.token() != token) {
            throw new VerifierError("ExportComponent.7", cdesc.token(), token);
        }
        if (ecls.staticFieldCount() > 256) {
            throw new VerifierError("ExportComponent.8", token, ecls.staticFieldCount());
        }
        int i = 0;
        while (i < ecls.staticFieldCount()) {
            int ofs = ecls.staticFieldOffset(i);
            ClassAndFieldDescriptor cfdesc = Fieldref.findDescr(ofs);
            FieldDescriptor fdesc = cfdesc.fieldDescr;
            if ((fdesc.flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.9", ofs);
            }
            if (fdesc.token() != i) {
                throw new VerifierError("ExportComponent.10", fdesc.token(), i);
            }
            if (cfdesc.classDescr.thisClass() != ecls.classOffset()) {
                throw new VerifierError("ExportComponent.47", i, cfdesc.classDescr.thisClass(), ecls.classOffset());
            }
            ++i;
        }
        if (ecls.staticFieldCount() != cdesc.num_exported_static_fields()) {
            throw new VerifierError("ExportComponent.45", ecls.classOffset());
        }
        if (ecls.staticMethodCount() > 256) {
            throw new VerifierError("ExportComponent.11", token);
        }
        int i2 = 0;
        while (i2 < ecls.staticMethodCount()) {
            int ofs = ecls.staticMethodOffset(i2);
            ClassAndMethodDescriptor cmdesc = Methodref.findDescr(ofs);
            MethodDescriptor mdesc = cmdesc.methodDescr;
            if ((mdesc.flags() & 0x88) == 0) {
                throw new VerifierError("ExportComponent.12", ofs);
            }
            if ((mdesc.flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.13", ofs);
            }
            if (mdesc.token() != i2) {
                throw new VerifierError("ExportComponent.14", mdesc.token(), i2);
            }
            if (cmdesc.classDescr.thisClass() != ecls.classOffset()) {
                throw new VerifierError("ExportComponent.48", i2, cmdesc.classDescr.thisClass(), ecls.classOffset());
            }
            ++i2;
        }
        if (ecls.staticMethodCount() != cdesc.num_exported_static_methods()) {
            throw new VerifierError("ExportComponent.46", ecls.classOffset());
        }
    }

    private void verifyExport() {
        boolean accApplet;
        if (!Cap.packageDirectory.equals(this.exportfile.thisName())) {
            throw new VerifierError("ExportComponent.39", (Object)this.exportfile.thisName(), (Object)Cap.packageDirectory);
        }
        boolean accLibrary = (this.exportfile.thisPackage().flags & 1) != 0;
        boolean bl = accApplet = (Cap.Header.flags() & 4) != 0;
        if (accLibrary != (accApplet ^ true)) {
            throw new VerifierError("ExportComponent.40");
        }
        int i = 0;
        while (i < this.exportfile.classes.length) {
            EfClass ec = this.exportfile.classes[i];
            this.checkExportClass(ec);
            ++i;
        }
        if (this.exportfile.classes.length != Cap.Export.classCount()) {
            throw new VerifierError("ExportComponent.41");
        }
    }
}

