/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import java.util.Enumeration;
import java.util.Vector;

public class TypeDescriptorEntry {
    protected byte[] data;
    protected int offset;

    public TypeDescriptorEntry(JCPackage pkg, Info info, int offset) {
        this.offset = offset;
        switch (info.getType()) {
            case 2: 
            case 5: {
                String desc = info.getDescriptor();
                this.data = this.pack(this.simpleDesc(pkg, desc, 0, desc.length()));
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                String desc = info.getDescriptor();
                this.data = this.pack(this.compoundDesc(pkg, desc, 0));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public TypeDescriptorEntry(Field f, int offset) {
        this.offset = offset;
        FieldDescriptor desc = f.getDescriptor();
        String name = desc.getDescriptorString();
        if (name != null) {
            this.data = this.pack(this.simpleDesc(f.getParentClass().getParentPackage(), name, 0, name.length()));
        } else {
            ClassIdentifier cid = desc.getClassIdentifier();
            PackageIdentifier pid = cid.getPackageIdentifier();
            int ptok = f.getParentClass().getParentPackage().getPackageToken(pid);
            this.data = this.pack(this.simpleDesc(ptok, cid.getClassToken(), desc.isArray()));
        }
    }

    public TypeDescriptorEntry(String mNameAndDesc, JCClass parentClass) {
        this.offset = 0;
        int startIndex = mNameAndDesc.indexOf(40);
        this.data = this.pack(this.compoundDesc(parentClass.getParentPackage(), mNameAndDesc, startIndex));
    }

    public TypeDescriptorEntry(JCMethod m, int offset) {
        this.offset = offset;
        String name = m.getName();
        int startIndex = name.indexOf(40);
        this.data = this.pack(this.compoundDesc(m.getParentClass().getParentPackage(), name, startIndex));
    }

    int getOffset() {
        return this.offset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeDescriptorEntry)) {
            return false;
        }
        byte[] otherData = ((TypeDescriptorEntry)obj).data;
        if (this.data.length != otherData.length) {
            return false;
        }
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != otherData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    int size() {
        return this.data.length;
    }

    byte[] toByteArray() {
        return this.data;
    }

    private int[] compoundDesc(JCPackage pkg, String desc, int offset) {
        Assert.PreCondition(desc.charAt(offset) == '(', "desc[offset] != '('");
        ++offset;
        Vector<int[]> iVec = new Vector<int[]>();
        int m_size = 0;
        while (offset < desc.length()) {
            int[] ia = null;
            block0 : switch (desc.charAt(offset)) {
                case 'B': 
                case 'I': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    ia = this.simpleDesc(pkg, desc, offset, 1);
                    iVec.addElement(ia);
                    m_size += ia.length;
                    ++offset;
                    break;
                }
                case '[': {
                    int end;
                    switch (desc.charAt(offset + 1)) {
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            ia = this.simpleDesc(pkg, desc, offset, 2);
                            iVec.addElement(ia);
                            m_size += ia.length;
                            offset += 2;
                            break block0;
                        }
                        case 'L': {
                            end = desc.indexOf(59, offset);
                            Assert.Assert(end != -1, "end == -1");
                            ia = this.simpleDesc(pkg, desc, offset, end - offset + 1);
                            iVec.addElement(ia);
                            m_size += ia.length;
                            offset = end + 1;
                            break block0;
                        }
                    }
                    throw new InternalError();
                }
                case 'L': {
                    int end = desc.indexOf(59, offset);
                    Assert.Assert(end != -1, "end == -1");
                    ia = this.simpleDesc(pkg, desc, offset, end - offset + 1);
                    iVec.addElement(ia);
                    m_size += ia.length;
                    offset = end + 1;
                    break;
                }
                case ')': {
                    ++offset;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        int[] m_iArray = new int[m_size];
        int m_offset = 0;
        Enumeration e = iVec.elements();
        while (e.hasMoreElements()) {
            int[] subElement = (int[])e.nextElement();
            System.arraycopy(subElement, 0, m_iArray, m_offset, subElement.length);
            m_offset += subElement.length;
        }
        return m_iArray;
    }

    private int[] simpleDesc(JCPackage pkg, String desc, int offset, int length) {
        int[] iArray;
        switch (desc.charAt(offset)) {
            case 'V': {
                iArray = new int[]{1};
                break;
            }
            case 'Z': {
                iArray = new int[]{2};
                break;
            }
            case 'B': {
                iArray = new int[]{3};
                break;
            }
            case 'S': {
                iArray = new int[]{4};
                break;
            }
            case 'I': {
                iArray = new int[]{5};
                break;
            }
            case 'L': {
                int ctok;
                int ptok;
                iArray = new int[5];
                iArray[0] = 6;
                String name = desc.substring(++offset, offset + (length -= 2));
                int dotIndex = name.indexOf(46);
                if (dotIndex != -1) {
                    String pkgStr = name.substring(0, dotIndex);
                    String claStr = name.substring(dotIndex + 1);
                    ptok = Integer.decode(pkgStr) | 0x80;
                    ctok = Integer.decode(claStr);
                } else {
                    ptok = pkg.getDescriptorPackageToken(name);
                    ctok = pkg.getDescriptorClassToken(name);
                }
                iArray[1] = (byte)(ptok >> 4);
                iArray[2] = (byte)ptok;
                iArray[3] = (byte)(ctok >> 4);
                iArray[4] = (byte)ctok;
                break;
            }
            case '[': {
                iArray = this.simpleDesc(pkg, desc, offset + 1, length - 1);
                iArray[0] = iArray[0] | 8;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return iArray;
    }

    private int[] simpleDesc(int packageToken, int classToken, boolean isArray) {
        int[] iArray = new int[]{isArray ? -114 : 6, (byte)(packageToken >> 4 | 8), (byte)packageToken, (byte)(classToken >> 4), (byte)classToken};
        return iArray;
    }

    private byte[] pack(int[] iArray) {
        byte[] bArray = new byte[(iArray.length + 1) / 2 + 1];
        bArray[0] = (byte)iArray.length;
        int j = 1;
        int i = 0;
        while (i < iArray.length) {
            int high = iArray[i] & 0xFF;
            int low = 0;
            if (i + 1 < iArray.length) {
                low = iArray[i + 1] & 0xFF;
            }
            bArray[j++] = (byte)(high << 4 | low);
            i += 2;
        }
        return bArray;
    }

    public String toString() {
        return Msg.toHexString(this.toByteArray());
    }

    public byte[] getData() {
        return this.data;
    }
}

