/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.StringUtils;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.JavaCardXML;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.ValidValues;
import com.sun.javacard.validator.XMLNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WebXML
extends PackageItem {
    public static final String XSD_NAME = "jcweb-app_3_0.xsd";
    private String version;
    private File file;
    private XMLNode xmlNode;
    private Vector<String> servletClasses = new Vector();
    private Vector<String> listenerClasses = new Vector();
    private Vector<String> filterClasses = new Vector();
    private Vector<String> securityRoles = new Vector();

    public WebXML(File file) {
        this.file = file;
    }

    @Override
    public String getItemDisplayName() {
        String str = "";
        if (this.getParent() != null) {
            str = this.getParent().getItemDisplayName() + "/";
        }
        str = str + "web.xml";
        return str;
    }

    public void saveCanonicalizedTo(File dest) throws Exception {
        if (!this.isOk()) {
            return;
        }
        String str = this.xmlNode.toString();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            fos.write(str.getBytes());
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void initialize() {
        ArrayList<XMLNode> securityRoleNodes;
        ArrayList<XMLNode> filterNodes;
        ArrayList<XMLNode> listenerNodes;
        ArrayList<XMLNode> servletNodes;
        this.xmlNode = null;
        try {
            this.xmlNode = new XMLNode(this, this.file, XSD_NAME, "http://java.sun.com/xml/ns/j2ee");
        }
        catch (Exception e) {
            this.addError(ErrorKey.XMLParsingError, this.file.getName(), e.getMessage());
            return;
        }
        this.version = this.xmlNode.getAttribute("version");
        if (!"2.4".equals(this.version)) {
            this.addError(ErrorKey.InvalidVersion, this.version);
        }
        if ((servletNodes = this.xmlNode.getChildNodes("servlet")) != null) {
            for (XMLNode servletNode : servletNodes) {
                this.gatherServletClasses(servletNode);
            }
        }
        if ((listenerNodes = this.xmlNode.getChildNodes("listener")) != null) {
            for (XMLNode listenerNode : listenerNodes) {
                this.gatherListenerClasses(listenerNode);
            }
        }
        if ((filterNodes = this.xmlNode.getChildNodes("filter")) != null) {
            for (XMLNode filterNode : filterNodes) {
                this.gatherFilterClasses(filterNode);
            }
        }
        if ((securityRoleNodes = this.xmlNode.getChildNodes("security-role")) != null) {
            for (XMLNode securityRoleNode : securityRoleNodes) {
                this.gatherSecurityRoles(securityRoleNode);
            }
        }
    }

    private void gatherServletClasses(XMLNode servletNode) {
        ArrayList<XMLNode> servletClassNodesList = servletNode.getChildNodes("servlet-class");
        for (XMLNode servletClassNode : servletClassNodesList) {
            this.servletClasses.addElement(servletClassNode.getTextValue());
        }
    }

    private void gatherListenerClasses(XMLNode listenerNode) {
        ArrayList<XMLNode> listenerClassNodesList = listenerNode.getChildNodes("listener-class");
        for (XMLNode listenerClassNode : listenerClassNodesList) {
            this.listenerClasses.addElement(listenerClassNode.getTextValue());
        }
    }

    private void gatherFilterClasses(XMLNode filterNode) {
        ArrayList<XMLNode> filterClassNodesList = filterNode.getChildNodes("filter-class");
        for (XMLNode filterClassNode : filterClassNodesList) {
            this.filterClasses.addElement(filterClassNode.getTextValue());
        }
    }

    void gatherSecurityRoles(XMLNode securityRolesNode) {
        ArrayList<XMLNode> rolesNodesList = securityRolesNode.getChildNodes("role-name");
        for (XMLNode roleNameNode : rolesNodesList) {
            String roleName = roleNameNode.getTextValue();
            if (!ValidValues.isValidNNMToken(roleName)) {
                this.addError(ErrorKey.RoleNameNotNMTOKEN, roleName);
            }
            this.securityRoles.addElement(roleName);
        }
    }

    @Override
    public void processInternal() {
        Module module = (Module)this.getParent();
        for (String name : this.servletClasses) {
            if (!StringUtils.isValidClassName(name)) {
                this.addError(ErrorKey.IllegalClassName, name, "servlet-class");
                continue;
            }
            if (!module.hasClass(name)) {
                this.addWarning(ErrorKey.DeclaredClassDoesNotExists, name, "servlet-class");
            }
            if (module.isConcreteClass(name)) continue;
            this.addWarning(ErrorKey.ServletClassNotConcrete, name);
        }
        for (String name : this.listenerClasses) {
            if (!StringUtils.isValidClassName(name)) {
                this.addError(ErrorKey.IllegalClassName, name, "listener-class");
                continue;
            }
            if (!module.hasClass(name)) {
                this.addWarning(ErrorKey.DeclaredClassDoesNotExists, name, "listener-class");
            }
            if (module.isConcreteClass(name)) continue;
            this.addWarning(ErrorKey.ListenerClassNotConcrete, name);
        }
        for (String name : this.filterClasses) {
            if (!StringUtils.isValidClassName(name)) {
                this.addError(ErrorKey.IllegalClassName, name, "filter-class");
                continue;
            }
            if (!module.hasClass(name)) {
                this.addWarning(ErrorKey.DeclaredClassDoesNotExists, name, "filter-class");
            }
            if (module.isConcreteClass(name)) continue;
            this.addWarning(ErrorKey.FilterClassNotConcrete, name);
        }
        this.verifySecurityRoles();
        this.verifySecurityConstraint();
        this.verifyLoginConfig();
    }

    void verifySecurityRoles() {
        Module module = (Module)this.getParent();
        ModuleJCRD jcrd = module.getJCRD();
        Vector<String> userRolesInJCRD = jcrd.getUserRoleList();
        Vector<String> onCardClientRolesInJCRD = jcrd.getOncardClientRoleList();
        Vector<String> onCardClientRolesInJCAD = new Vector<String>();
        Vector<String> userRolesInJCAD = new Vector<String>();
        JavaCardXML jcad = module.getJavaCardXML();
        if (jcad != null) {
            for (String roleName : jcad.getOncardClientRoles()) {
                onCardClientRolesInJCAD.addElement(roleName);
            }
            for (String roleName : jcad.getUserRoles()) {
                userRolesInJCAD.addElement(roleName);
            }
        }
        for (String roleName : this.securityRoles) {
            if (userRolesInJCRD.contains(roleName)) continue;
            this.addError(ErrorKey.MissingSecurityRoleInJCRD, roleName);
        }
        for (String roleName : userRolesInJCRD) {
            if (userRolesInJCAD.contains(roleName) || this.securityRoles.contains(roleName)) continue;
            this.addError(ErrorKey.MissingUserRoleInJCADOrWebXml, roleName);
        }
        for (String roleName : onCardClientRolesInJCRD) {
            if (onCardClientRolesInJCAD.contains(roleName)) continue;
            this.addError(ErrorKey.MissingOnCardClientRoleInJCAD, roleName);
        }
    }

    void verifySecurityConstraint() {
        ArrayList<XMLNode> secConstraints = this.xmlNode.getChildNodes("security-constraint");
        for (XMLNode secNode : secConstraints) {
            ArrayList<XMLNode> authConstraint = secNode.getChildNodes("auth-constraint");
            for (XMLNode authNode : authConstraint) {
                ArrayList<XMLNode> roleNames = authNode.getChildNodes("role-name");
                for (XMLNode roleNode : roleNames) {
                    String roleName = roleNode.getTextValue();
                    if (roleName == null) {
                        this.addError(ErrorKey.InvalidAuthConstraintMissingRoleName, new Object[0]);
                        continue;
                    }
                    if (roleName.equals("*") || this.securityRoles.contains(roleName)) continue;
                    this.addError(ErrorKey.InvalidAuthConstraintInvalidRoleName, roleName);
                }
            }
        }
    }

    void verifyLoginConfig() {
        Module module = (Module)this.getParent();
        ModuleJCRD jcrd = module.getJCRD();
        Hashtable<String, Vector<String>> JCRDUserRoleMappings = jcrd.getUserRoleAuthURIMappings();
        ArrayList<XMLNode> loginConfigs = this.xmlNode.getChildNodes("login-config");
        for (XMLNode loginConfig : loginConfigs) {
            ArrayList<XMLNode> authMethods = loginConfig.getChildNodes("auth-method");
            for (XMLNode authMethodNode : authMethods) {
                String methodName = authMethodNode.getTextValue();
                if (ValidValues.isValidAuthMethod(methodName)) continue;
                this.addError(ErrorKey.InvalidAuthenticationMethod, methodName);
            }
        }
    }
}

