/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import com.sun.javacard.security.AuthConstants;
import javacard.framework.Shareable;
import javacardx.biometry.BioBuilder;
import javacardx.biometry.BioException;
import javacardx.biometry.BioTemplate;
import javacardx.biometry.OwnerBioTemplate;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.SharedBioTemplateAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class BioSessionAuthenticatorFactory
implements ServiceFactory {
    private final OwnerBioTemplate ownerBioTemplate;
    private BioTemplate currentMatchSession = null;

    public BioSessionAuthenticatorFactory(byte bioType, byte[] bioTemplate, int tryLimit) {
        this(bioType, tryLimit);
        this.ownerBioTemplate.init(bioTemplate, (short)0, (byte)bioTemplate.length);
        this.ownerBioTemplate.doFinal();
    }

    public BioSessionAuthenticatorFactory(byte[] bioTemplate, int tryLimit) {
        this(31, tryLimit);
        this.ownerBioTemplate.init(bioTemplate, (short)0, (byte)bioTemplate.length);
        this.ownerBioTemplate.doFinal();
    }

    public BioSessionAuthenticatorFactory(byte bioType, int tryLimit) {
        this.ownerBioTemplate = BioBuilder.buildBioTemplate(bioType, (byte)tryLimit);
    }

    @Override
    public Shareable create(String serviceURI, Object parameter) throws SecurityException {
        if ((serviceURI.startsWith("sio:///standard/auth/holder/session") || serviceURI.startsWith("sio:///standard/auth/user/session")) && (serviceURI.endsWith("/" + AuthConstants.BIO_ALGO_NAMES[this.ownerBioTemplate.getBioType()]) || this.ownerBioTemplate.getBioType() == 31 && serviceURI.endsWith("/bio-password"))) {
            return new SessionBioTemplateAuth();
        }
        return null;
    }

    public OwnerBioTemplate getOwnerBioTemplate() {
        return this.ownerBioTemplate;
    }

    @TransactionType(value=TransactionTypeValue.SUPPORTS)
    private class SessionBioTemplateAuth
    implements SharedBioTemplateAuth {
        private final TransientReference<Boolean> validated = new TransientReference<Boolean>(false);

        private SessionBioTemplateAuth() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public short initMatch(byte[] candidate, short offset, short length) {
            this.validated.set(false);
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                short s;
                BioSessionAuthenticatorFactory.this.currentMatchSession = this;
                try {
                    short result = BioSessionAuthenticatorFactory.this.ownerBioTemplate.initMatch(candidate, (short)0, (byte)candidate.length);
                    this.validated.set(BioSessionAuthenticatorFactory.this.ownerBioTemplate.isValidated());
                    s = result;
                }
                catch (Throwable throwable) {
                    BioSessionAuthenticatorFactory.this.ownerBioTemplate.reset();
                    throw throwable;
                }
                BioSessionAuthenticatorFactory.this.ownerBioTemplate.reset();
                return s;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public short match(byte[] candidate, short offset, short length) {
            this.validated.set(false);
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                short s;
                if (BioSessionAuthenticatorFactory.this.currentMatchSession != this) throw new BioException(5);
                try {
                    short result = BioSessionAuthenticatorFactory.this.ownerBioTemplate.initMatch(candidate, (short)0, (byte)candidate.length);
                    this.validated.set(BioSessionAuthenticatorFactory.this.ownerBioTemplate.isValidated());
                    s = result;
                }
                catch (Throwable throwable) {
                    BioSessionAuthenticatorFactory.this.ownerBioTemplate.reset();
                    throw throwable;
                }
                BioSessionAuthenticatorFactory.this.ownerBioTemplate.reset();
                return s;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getTriesRemaining() {
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                return BioSessionAuthenticatorFactory.this.ownerBioTemplate.getTriesRemaining();
            }
        }

        @Override
        public boolean isValidated() {
            return this.validated.get() != null && this.validated.get() != false;
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public void reset() {
            if (this.validated.get() != null && this.validated.get().booleanValue()) {
                this.validated.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInitialized() {
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                return BioSessionAuthenticatorFactory.this.ownerBioTemplate.isInitialized();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getBioType() {
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                return BioSessionAuthenticatorFactory.this.ownerBioTemplate.getBioType();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getVersion(byte[] dest, short offset) {
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                return BioSessionAuthenticatorFactory.this.ownerBioTemplate.getVersion(dest, offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getPublicTemplateData(short publicOffset, byte[] dest, short destOffset, short length) throws BioException {
            OwnerBioTemplate ownerBioTemplate = BioSessionAuthenticatorFactory.this.ownerBioTemplate;
            synchronized (ownerBioTemplate) {
                return BioSessionAuthenticatorFactory.this.ownerBioTemplate.getPublicTemplateData(publicOffset, dest, destOffset, length);
            }
        }
    }
}

