/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.Attributes;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.UrlEncoded;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Dispatcher
implements RequestDispatcher {
    public static final String INCLUDE_JETTY = "org.mortbay.jetty.included";
    public static final String INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String FORWARD_JETTY = "org.mortbay.jetty.forwarded";
    public static final String FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String JSP_FILE = "org.apache.catalina.jsp_file";
    private ContextHandler _contextHandler;
    private String _uri;
    private String _path;
    private String _dQuery;
    String _named;

    public static int type(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        throw new IllegalArgumentException(type);
    }

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name;
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, 2);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Attributes old_attr = base_request.getAttributes();
        MultiMap<String> old_params = base_request.getParameters();
        try {
            base_request.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, (HttpServletRequest)request, (HttpServletResponse)response, 4);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    MultiMap<String> parameters = new MultiMap<String>();
                    UrlEncoded.decodeTo(query, parameters, request.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        Enumeration iter = old_params.keys();
                        while (iter.hasMoreElements()) {
                            String name = (String)iter.nextElement();
                            LazyList<String> values = old_params.get(name);
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add(name, LazyList.get(values, i));
                            }
                        }
                    }
                    base_request.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                attr.requestURI = this._uri;
                attr.contextPath = this._contextHandler.getContextPath();
                attr.servletPath = null;
                attr.pathInfo = this._path;
                attr.query = query;
                base_request.setAttributes(attr);
                this._contextHandler.handle(this._named == null ? this._path : this._named, (HttpServletRequest)request, (HttpServletResponse)response, 4);
            }
        }
        finally {
            base_request.setAttributes(old_attr);
            base_request.getConnection().included();
            base_request.setParameters(old_params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, int dispatch) throws ServletException, IOException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        response.resetBuffer();
        request.removeAttribute(JSP_FILE);
        String old_uri = base_request.getRequestURI();
        String old_context_path = base_request.getContextPath();
        String old_query = base_request.getQueryString();
        Attributes old_attr = base_request.getAttributes();
        MultiMap<String> old_params = base_request.getParameters();
        try {
            if (this._named != null) {
                this._contextHandler.handle(this._named, (HttpServletRequest)request, (HttpServletResponse)response, dispatch);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    MultiMap<String> parameters = new MultiMap<String>();
                    UrlEncoded.decodeTo(query, parameters, request.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        Enumeration iter = old_params.keys();
                        while (iter.hasMoreElements()) {
                            String name = (String)iter.nextElement();
                            LazyList<String> values = old_params.get(name);
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add(name, LazyList.get(values, i));
                            }
                        }
                    }
                    if (old_query != null && old_query.length() > 0) {
                        query = query + "&" + old_query;
                    }
                    base_request.setParameters(parameters);
                    base_request.setQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                attr.requestURI = base_request.getRequestURI();
                attr.contextPath = base_request.getContextPath();
                attr.servletPath = base_request.getServletPath();
                attr.pathInfo = base_request.getPathInfo();
                attr.query = base_request.getQueryString();
                base_request.setRequestURI(this._uri);
                base_request.setContextPath(this._contextHandler.getContextPath());
                base_request.setAttributes(attr);
                base_request.setQueryString(query);
                this._contextHandler.handle(this._path, (HttpServletRequest)request, (HttpServletResponse)response, dispatch);
                if (base_request.getConnection().getResponse().isWriting()) {
                    try {
                        response.getWriter().close();
                    }
                    catch (IllegalStateException e) {
                        response.getOutputStream().close();
                    }
                } else {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException e) {
                        response.getWriter().close();
                    }
                }
            }
        }
        finally {
            base_request.setRequestURI(old_uri);
            base_request.setContextPath(old_context_path);
            base_request.setAttributes(old_attr);
            base_request.setParameters(old_params);
            base_request.setQueryString(old_query);
        }
    }

    private class IncludeAttributes
    implements Attributes {
        Attributes attr;
        String requestURI;
        String contextPath;
        String servletPath;
        String pathInfo;
        String query;

        IncludeAttributes(Attributes attributes) {
            this.attr = attributes;
        }

        @Override
        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.INCLUDE_PATH_INFO)) {
                    return this.pathInfo;
                }
                if (key.equals(Dispatcher.INCLUDE_SERVLET_PATH)) {
                    return this.servletPath;
                }
                if (key.equals(Dispatcher.INCLUDE_CONTEXT_PATH)) {
                    return this.contextPath;
                }
                if (key.equals(Dispatcher.INCLUDE_QUERY_STRING)) {
                    return this.query;
                }
                if (key.equals(Dispatcher.INCLUDE_REQUEST_URI)) {
                    return this.requestURI;
                }
            } else if (key.startsWith(Dispatcher.INCLUDE_PREFIX)) {
                return null;
            }
            if (key.startsWith(Dispatcher.FORWARD_PREFIX)) {
                return null;
            }
            if (key.equals(Dispatcher.INCLUDE_JETTY)) {
                return Boolean.TRUE;
            }
            return this.attr.getAttribute(key);
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            Vector<String> set = new Vector<String>();
            Enumeration<String> e = this.attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (name.startsWith(Dispatcher.INCLUDE_PREFIX) || name.startsWith(Dispatcher.FORWARD_PREFIX)) continue;
                set.addElement(name);
            }
            if (Dispatcher.this._named == null) {
                if (this.pathInfo != null) {
                    set.addElement(Dispatcher.INCLUDE_PATH_INFO);
                } else {
                    set.removeElement(Dispatcher.INCLUDE_PATH_INFO);
                }
                set.addElement(Dispatcher.INCLUDE_REQUEST_URI);
                set.addElement(Dispatcher.INCLUDE_SERVLET_PATH);
                set.addElement(Dispatcher.INCLUDE_CONTEXT_PATH);
                if (this.query != null) {
                    set.addElement(Dispatcher.INCLUDE_QUERY_STRING);
                } else {
                    set.removeElement(Dispatcher.INCLUDE_QUERY_STRING);
                }
            }
            return set.elements();
        }

        @Override
        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.INCLUDE_PATH_INFO)) {
                    this.pathInfo = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_REQUEST_URI)) {
                    this.requestURI = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_SERVLET_PATH)) {
                    this.servletPath = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_CONTEXT_PATH)) {
                    this.contextPath = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_QUERY_STRING)) {
                    this.query = (String)value;
                }
            } else if (value == null) {
                this.attr.removeAttribute(key);
            } else {
                this.attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this.attr.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        Attributes attr;
        String requestURI;
        String contextPath;
        String servletPath;
        String pathInfo;
        String query;

        ForwardAttributes(Attributes attributes) {
            this.attr = attributes;
        }

        @Override
        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.FORWARD_PATH_INFO)) {
                    return this.pathInfo;
                }
                if (key.equals(Dispatcher.FORWARD_REQUEST_URI)) {
                    return this.requestURI;
                }
                if (key.equals(Dispatcher.FORWARD_SERVLET_PATH)) {
                    return this.servletPath;
                }
                if (key.equals(Dispatcher.FORWARD_CONTEXT_PATH)) {
                    return this.contextPath;
                }
                if (key.equals(Dispatcher.FORWARD_QUERY_STRING)) {
                    return this.query;
                }
            }
            if (key.startsWith(Dispatcher.INCLUDE_PREFIX)) {
                return null;
            }
            if (key.equals(Dispatcher.FORWARD_JETTY)) {
                return Boolean.TRUE;
            }
            return this.attr.getAttribute(key);
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            Vector<String> set = new Vector<String>();
            Enumeration<String> e = this.attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (name.startsWith(Dispatcher.INCLUDE_PREFIX) || name.startsWith(Dispatcher.FORWARD_PREFIX)) continue;
                set.addElement(name);
            }
            if (Dispatcher.this._named == null) {
                if (this.pathInfo != null) {
                    set.addElement(Dispatcher.FORWARD_PATH_INFO);
                } else {
                    set.removeElement(Dispatcher.FORWARD_PATH_INFO);
                }
                set.addElement(Dispatcher.FORWARD_REQUEST_URI);
                set.addElement(Dispatcher.FORWARD_SERVLET_PATH);
                set.addElement(Dispatcher.FORWARD_CONTEXT_PATH);
                if (this.query != null) {
                    set.addElement(Dispatcher.FORWARD_QUERY_STRING);
                } else {
                    set.removeElement(Dispatcher.FORWARD_QUERY_STRING);
                }
            }
            return set.elements();
        }

        @Override
        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.FORWARD_PATH_INFO)) {
                    this.pathInfo = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_REQUEST_URI)) {
                    this.requestURI = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_SERVLET_PATH)) {
                    this.servletPath = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_CONTEXT_PATH)) {
                    this.contextPath = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_QUERY_STRING)) {
                    this.query = (String)value;
                }
            } else if (value == null) {
                this.attr.removeAttribute(key);
            } else {
                this.attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this.attr.toString();
        }

        @Override
        public void clearAttributes() {
            throw new IllegalStateException();
        }

        @Override
        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

