/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.tools.util.JCToolsLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Diagnostics {
    public boolean noWarn = false;
    public boolean ok = false;
    Hashtable<String, Vector<String>> errors = new Hashtable();
    Hashtable<String, Vector<String>> warnings = new Hashtable();
    private static JCToolsLogger toolsLogger = JCToolsLogger.getLogger("Logger");

    public boolean isOk() {
        return this.ok;
    }

    public void addErrors(String itemName, Vector<String> itemErrors) {
        Vector<String> errorsVector = this.errors.get(itemName);
        if (errorsVector == null) {
            this.errors.put(itemName, itemErrors);
        } else {
            errorsVector.addAll(itemErrors);
            this.errors.put(itemName, errorsVector);
        }
    }

    public void addWarnings(String itemName, Vector<String> itemWarnings) {
        Vector<String> warnsVector = this.warnings.get(itemName);
        if (warnsVector == null) {
            this.warnings.put(itemName, itemWarnings);
        } else {
            warnsVector.addAll(itemWarnings);
            this.warnings.put(itemName, warnsVector);
        }
    }

    public Vector<String> getErrors(String itemName) {
        return this.errors.get(itemName);
    }

    public Vector<String> getWarnings(String itemName) {
        return this.warnings.get(itemName);
    }

    public int printErrors(String errorMessage) {
        int errorCount = 0;
        Enumeration<String> keys = this.errors.keys();
        while (keys.hasMoreElements()) {
            String elementName = keys.nextElement();
            System.out.println(elementName.trim() + ":");
            Vector<String> itemErrors = this.errors.get(elementName);
            for (String error : itemErrors) {
                toolsLogger.severe("    [" + errorMessage + "] " + error.trim(), new Object[0]);
                ++errorCount;
            }
        }
        return errorCount;
    }

    public int printWarnings(String warnMessage) {
        int warningCount = 0;
        Enumeration<String> keys = this.warnings.keys();
        while (keys.hasMoreElements()) {
            String elementName = keys.nextElement();
            System.out.println(elementName.trim() + ":");
            Vector<String> itemWarnings = this.warnings.get(elementName);
            for (String warning : itemWarnings) {
                toolsLogger.warning(warning.trim(), new Object[0]);
                ++warningCount;
            }
        }
        return warningCount;
    }

    public void printDiagnostics(String status, String operationName, String errorMessage, String warnMessage, String errorStr, String warnStr) {
        int errorCount = 0;
        int warningCount = 0;
        if (!this.noWarn) {
            warningCount = this.printWarnings(warnStr);
        }
        if ((errorCount = this.printErrors(errorStr)) > 0) {
            toolsLogger.severe(operationName + " " + status + " [" + errorCount + " " + errorMessage + " and " + warningCount + " " + warnMessage + "]", new Object[0]);
        } else {
            toolsLogger.info(operationName + " " + status + " [" + errorCount + " " + errorMessage + " and " + warningCount + " " + warnMessage + "]", new Object[0]);
        }
    }
}

