/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

File: octvc1_hw_api_swap.h	

Copyright (c) 2018 Octasic Inc. All rights reserved.	

Description:	

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
	

Release: OCTSDR Software Development Kit OCTSDR_GSM-02.11.00-B1927 (2018/04/27)	

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/	
#ifndef __OCTVC1_HW_API_SWAP_H__
#define __OCTVC1_HW_API_SWAP_H__

#ifdef __cplusplus
extern "C" {
#endif

/*****************************  INCLUDE FILES  *******************************/
#include "../octvc1_swap_hdrs.h"
#include "octvc1_hw_api.h"

/*********************************  MACROS  **********************************/


#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_PCB_INFO_SOURCE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_PCB_INFO_SOURCE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_PCB_INFO_SIGNED_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_PCB_INFO_SIGNED_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_PCB_INFO_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_PCB_INFO_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CPU_CORE_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_CPU_CORE_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CPU_CORE_STATUS_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_CPU_CORE_STATUS_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CPU_CORE_FAILURE_MASK_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_CPU_CORE_FAILURE_MASK_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CPU_CORE_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_CPU_CORE_STATS * pOCTVC1_HW_CPU_CORE_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_CPU_CORE_STATS)\
	{ mOCTVC1_HW_CPU_CORE_STATUS_ENUM_SWAP( &((tOCTVC1_HW_CPU_CORE_STATS *)pOCTVC1_HW_CPU_CORE_STATS)->ulCoreStatus ); }  \
	((tOCTVC1_HW_CPU_CORE_STATS *)pOCTVC1_HW_CPU_CORE_STATS)->ulProgramCounter = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_CPU_CORE_STATS *)pOCTVC1_HW_CPU_CORE_STATS)->ulProgramCounter); \
	{ mOCTVC1_HW_CPU_CORE_FAILURE_MASK_SWAP( &((tOCTVC1_HW_CPU_CORE_STATS *)pOCTVC1_HW_CPU_CORE_STATS)->ulFailureMask ); }  \
	((tOCTVC1_HW_CPU_CORE_STATS *)pOCTVC1_HW_CPU_CORE_STATS)->ulAccessViolationAddress = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_CPU_CORE_STATS *)pOCTVC1_HW_CPU_CORE_STATS)->ulAccessViolationAddress); \
}
#else
#define mOCTVC1_HW_CPU_CORE_STATS_SWAP( pOCTVC1_HW_CPU_CORE_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CPU_CORE_INFO_SWAP( _f_pParms ){ 	tOCTVC1_HW_CPU_CORE_INFO * pOCTVC1_HW_CPU_CORE_INFO = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_CPU_CORE_INFO)\
	((tOCTVC1_HW_CPU_CORE_INFO *)pOCTVC1_HW_CPU_CORE_INFO)->hProcess = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_CPU_CORE_INFO *)pOCTVC1_HW_CPU_CORE_INFO)->hProcess); \
	((tOCTVC1_HW_CPU_CORE_INFO *)pOCTVC1_HW_CPU_CORE_INFO)->ulPhysicalCoreId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_CPU_CORE_INFO *)pOCTVC1_HW_CPU_CORE_INFO)->ulPhysicalCoreId); \
	{ mOCTVC1_USER_ID_PROCESS_ENUM_SWAP( &((tOCTVC1_HW_CPU_CORE_INFO *)pOCTVC1_HW_CPU_CORE_INFO)->ulProcessUserId ); }  \
}
#else
#define mOCTVC1_HW_CPU_CORE_INFO_SWAP( pOCTVC1_HW_CPU_CORE_INFO )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_MODE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_ETH_MODE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_LINK_SPEED_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_ETH_LINK_SPEED_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_DUPLEX_MODE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_ETH_DUPLEX_MODE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_PORT_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_HW_ETH_PORT_CONFIG * pOCTVC1_HW_ETH_PORT_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_ETH_PORT_CONFIG)\
	((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulPromiscuousModeFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulPromiscuousModeFlag); \
	((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulAcceptMulticastFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulAcceptMulticastFlag); \
	((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulAcceptJumboFrameFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulAcceptJumboFrameFlag); \
	((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulSgmiiAutoNegotationFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulSgmiiAutoNegotationFlag); \
	{ mOCTVC1_HW_ETH_LINK_SPEED_ENUM_SWAP( &((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulLinkSpeed ); }  \
	{ mOCTVC1_HW_ETH_DUPLEX_MODE_ENUM_SWAP( &((tOCTVC1_HW_ETH_PORT_CONFIG *)pOCTVC1_HW_ETH_PORT_CONFIG)->ulDuplexMode ); }  \
}
#else
#define mOCTVC1_HW_ETH_PORT_CONFIG_SWAP( pOCTVC1_HW_ETH_PORT_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_PORT_TX_ERROR_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS * pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)\
	((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxUnderflowCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxUnderflowCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxLateCollisionCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxLateCollisionCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxExcessCollisionCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxExcessCollisionCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxExcessDeferralCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS)->ulTxExcessDeferralCnt); \
}
#else
#define mOCTVC1_HW_ETH_PORT_TX_ERROR_STATS_SWAP( pOCTVC1_HW_ETH_PORT_TX_ERROR_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_PORT_TX_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_ETH_PORT_TX_STATS * pOCTVC1_HW_ETH_PORT_TX_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_ETH_PORT_TX_STATS)\
	((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxFrameCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxByteCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxByteCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxPauseFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxPauseFrameCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxVlanFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxVlanFrameCnt); \
	((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxJumboFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->ulTxJumboFrameCnt); \
	{ mOCTVC1_HW_ETH_PORT_TX_ERROR_STATS_SWAP( &((tOCTVC1_HW_ETH_PORT_TX_STATS *)pOCTVC1_HW_ETH_PORT_TX_STATS)->TxErrorStat ); }  \
}
#else
#define mOCTVC1_HW_ETH_PORT_TX_STATS_SWAP( pOCTVC1_HW_ETH_PORT_TX_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_PORT_RX_ERROR_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS * pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)\
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxCrcErrorCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxCrcErrorCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxAlignmentErrorCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxAlignmentErrorCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxJabberErrorCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxJabberErrorCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxUndersizeCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxUndersizeCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxOversizeCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxOversizeCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxLengthCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxLengthCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxOutOfRangeCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxOutOfRangeCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxFifoOverflowCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxFifoOverflowCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxWatchdogCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_ERROR_STATS *)pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS)->ulRxWatchdogCnt); \
}
#else
#define mOCTVC1_HW_ETH_PORT_RX_ERROR_STATS_SWAP( pOCTVC1_HW_ETH_PORT_RX_ERROR_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_ETH_PORT_RX_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_ETH_PORT_RX_STATS * pOCTVC1_HW_ETH_PORT_RX_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_ETH_PORT_RX_STATS)\
	((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxFrameCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxByteCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxByteCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxJumboFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxJumboFrameCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxPauseFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxPauseFrameCnt); \
	((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxVlanFrameCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->ulRxVlanFrameCnt); \
	{ mOCTVC1_HW_ETH_PORT_RX_ERROR_STATS_SWAP( &((tOCTVC1_HW_ETH_PORT_RX_STATS *)pOCTVC1_HW_ETH_PORT_RX_STATS)->RxErrorStat ); }  \
}
#else
#define mOCTVC1_HW_ETH_PORT_RX_STATS_SWAP( pOCTVC1_HW_ETH_PORT_RX_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_RF_PORT_ANTENNA_CALIB_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_RF_PORT_ANTENNA_CALIB_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG * pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG)\
	((tOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG)->ulEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG)->ulEnableFlag); \
	((tOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG)->lRxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG)->lRxGaindB); \
	{ mOCTVC1_RADIO_RX_GAIN_CTRL_MODE_ENUM_SWAP( &((tOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG)->ulRxGainMode ); }  \
}
#else
#define mOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG_SWAP( pOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG_SWAP( _f_pParms ){ 	tOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG * pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG)\
	((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG)->ulEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG)->ulEnableFlag); \
	((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG)->lTxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG)->lTxGaindB); \
}
#else
#define mOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG_SWAP( pOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_RF_PORT_RX_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_RF_PORT_RX_STATS * pOCTVC1_HW_RF_PORT_RX_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_RF_PORT_RX_STATS)\
	((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxByteCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxByteCnt); \
	((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxOverflowCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxOverflowCnt); \
	((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxAverageBytePerSecond = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxAverageBytePerSecond); \
	((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxAveragePeriodUs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->ulRxAveragePeriodUs); \
	{ mOCTVC1_RADIO_FREQUENCY_VALUE_SWAP( &((tOCTVC1_HW_RF_PORT_RX_STATS *)pOCTVC1_HW_RF_PORT_RX_STATS)->Frequency ); }  \
}
#else
#define mOCTVC1_HW_RF_PORT_RX_STATS_SWAP( pOCTVC1_HW_RF_PORT_RX_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_RF_PORT_TX_STATS_SWAP( _f_pParms ){ 	tOCTVC1_HW_RF_PORT_TX_STATS * pOCTVC1_HW_RF_PORT_TX_STATS = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_RF_PORT_TX_STATS)\
	((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxByteCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxByteCnt); \
	((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxUnderflowCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxUnderflowCnt); \
	((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxAverageBytePerSecond = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxAverageBytePerSecond); \
	((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxAveragePeriodUs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->ulTxAveragePeriodUs); \
	{ mOCTVC1_RADIO_FREQUENCY_VALUE_SWAP( &((tOCTVC1_HW_RF_PORT_TX_STATS *)pOCTVC1_HW_RF_PORT_TX_STATS)->Frequency ); }  \
}
#else
#define mOCTVC1_HW_RF_PORT_TX_STATS_SWAP( pOCTVC1_HW_RF_PORT_TX_STATS )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB_SWAP( _f_pParms ){ 	tOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB * pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB)\
	((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB)->ulFrequencyMhz = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB)->ulFrequencyMhz); \
	((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB)->ulAttenuationdB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB *)pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB)->ulAttenuationdB); \
}
#else
#define mOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB_SWAP( pOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CLOCK_SYNC_MGR_SOURCE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_CLOCK_SYNC_MGR_SOURCE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CLOCK_SYNC_MGR_DAC_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_CLOCK_SYNC_MGR_DAC_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_CLOCK_SYNC_MGR_STATE_ENUM_SWAP( pType ){ \
		*((tOCT_UINT32 *)pType) = mOCT_SWAP32_IF_LE( *((tOCT_UINT32 *)pType) ); }
#else

#define mOCTVC1_HW_CLOCK_SYNC_MGR_STATE_ENUM_SWAP( pType )

#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_PCB_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_PCB_INFO_CMD * pOCTVC1_HW_MSG_PCB_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_PCB_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_PCB_INFO_CMD *)pOCTVC1_HW_MSG_PCB_INFO_CMD)->Header ); }  \
}
#else
#define mOCTVC1_HW_MSG_PCB_INFO_CMD_SWAP( pOCTVC1_HW_MSG_PCB_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_PCB_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_PCB_INFO_RSP * pOCTVC1_HW_MSG_PCB_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_PCB_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_PCB_INFO_RSP *)pOCTVC1_HW_MSG_PCB_INFO_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_PCB_INFO_RSP *)pOCTVC1_HW_MSG_PCB_INFO_RSP)->ulDeviceId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_PCB_INFO_RSP *)pOCTVC1_HW_MSG_PCB_INFO_RSP)->ulDeviceId); \
	{ mOCTVC1_HW_PCB_INFO_SOURCE_ENUM_SWAP( &((tOCTVC1_HW_MSG_PCB_INFO_RSP *)pOCTVC1_HW_MSG_PCB_INFO_RSP)->ulInfoSource ); }  \
	{ mOCTVC1_HW_PCB_INFO_STATE_ENUM_SWAP( &((tOCTVC1_HW_MSG_PCB_INFO_RSP *)pOCTVC1_HW_MSG_PCB_INFO_RSP)->ulInfoState ); }  \
}
#else
#define mOCTVC1_HW_MSG_PCB_INFO_RSP_SWAP( pOCTVC1_HW_MSG_PCB_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CPU_CORE_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CPU_CORE_STATS_CMD * pOCTVC1_HW_MSG_CPU_CORE_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CPU_CORE_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_STATS_CMD *)pOCTVC1_HW_MSG_CPU_CORE_STATS_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_CPU_CORE_STATS_CMD *)pOCTVC1_HW_MSG_CPU_CORE_STATS_CMD)->ulCoreIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_CPU_CORE_STATS_CMD *)pOCTVC1_HW_MSG_CPU_CORE_STATS_CMD)->ulCoreIndex); \
}
#else
#define mOCTVC1_HW_MSG_CPU_CORE_STATS_CMD_SWAP( pOCTVC1_HW_MSG_CPU_CORE_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CPU_CORE_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CPU_CORE_STATS_RSP * pOCTVC1_HW_MSG_CPU_CORE_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CPU_CORE_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_STATS_RSP *)pOCTVC1_HW_MSG_CPU_CORE_STATS_RSP)->Header ); }  \
	{ mOCTVC1_HW_CPU_CORE_STATS_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_STATS_RSP *)pOCTVC1_HW_MSG_CPU_CORE_STATS_RSP)->CoreStats ); }  \
}
#else
#define mOCTVC1_HW_MSG_CPU_CORE_STATS_RSP_SWAP( pOCTVC1_HW_MSG_CPU_CORE_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CPU_CORE_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CPU_CORE_INFO_CMD * pOCTVC1_HW_MSG_CPU_CORE_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CPU_CORE_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_INFO_CMD *)pOCTVC1_HW_MSG_CPU_CORE_INFO_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_CPU_CORE_INFO_CMD *)pOCTVC1_HW_MSG_CPU_CORE_INFO_CMD)->ulCoreIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_CPU_CORE_INFO_CMD *)pOCTVC1_HW_MSG_CPU_CORE_INFO_CMD)->ulCoreIndex); \
}
#else
#define mOCTVC1_HW_MSG_CPU_CORE_INFO_CMD_SWAP( pOCTVC1_HW_MSG_CPU_CORE_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CPU_CORE_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CPU_CORE_INFO_RSP * pOCTVC1_HW_MSG_CPU_CORE_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CPU_CORE_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_INFO_RSP *)pOCTVC1_HW_MSG_CPU_CORE_INFO_RSP)->Header ); }  \
	{ mOCTVC1_HW_CPU_CORE_INFO_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_INFO_RSP *)pOCTVC1_HW_MSG_CPU_CORE_INFO_RSP)->CoreInfo ); }  \
}
#else
#define mOCTVC1_HW_MSG_CPU_CORE_INFO_RSP_SWAP( pOCTVC1_HW_MSG_CPU_CORE_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CPU_CORE_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CPU_CORE_LIST_CMD * pOCTVC1_HW_MSG_CPU_CORE_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CPU_CORE_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_LIST_CMD *)pOCTVC1_HW_MSG_CPU_CORE_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_LIST_CMD *)pOCTVC1_HW_MSG_CPU_CORE_LIST_CMD)->IndexGet ); }  \
}
#else
#define mOCTVC1_HW_MSG_CPU_CORE_LIST_CMD_SWAP( pOCTVC1_HW_MSG_CPU_CORE_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CPU_CORE_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CPU_CORE_LIST_RSP * pOCTVC1_HW_MSG_CPU_CORE_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CPU_CORE_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_LIST_RSP *)pOCTVC1_HW_MSG_CPU_CORE_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_LIST_RSP *)pOCTVC1_HW_MSG_CPU_CORE_LIST_RSP)->IndexGet ); }  \
	{ mOCTVC1_LIST_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_CPU_CORE_LIST_RSP *)pOCTVC1_HW_MSG_CPU_CORE_LIST_RSP)->IndexList ); }  \
}
#else
#define mOCTVC1_HW_MSG_CPU_CORE_LIST_RSP_SWAP( pOCTVC1_HW_MSG_CPU_CORE_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_INFO_CMD * pOCTVC1_HW_MSG_ETH_PORT_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_INFO_CMD *)pOCTVC1_HW_MSG_ETH_PORT_INFO_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_CMD *)pOCTVC1_HW_MSG_ETH_PORT_INFO_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_CMD *)pOCTVC1_HW_MSG_ETH_PORT_INFO_CMD)->ulPortIndex); \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_INFO_CMD_SWAP( pOCTVC1_HW_MSG_ETH_PORT_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP * pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulInterfaceId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulInterfaceId); \
	{ mOCTVC1_HW_ETH_MODE_ENUM_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulMode ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulTxPktQueuesByteSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulTxPktQueuesByteSize); \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulRxPktQueuesByteSize = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulRxPktQueuesByteSize); \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulRestrictedApiFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulRestrictedApiFlag); \
	((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulEnableFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->ulEnableFlag); \
	{ mOCTVC1_HW_ETH_PORT_CONFIG_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_INFO_RSP *)pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP)->Config ); }  \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_INFO_RSP_SWAP( pOCTVC1_HW_MSG_ETH_PORT_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_LIST_CMD * pOCTVC1_HW_MSG_ETH_PORT_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_LIST_CMD *)pOCTVC1_HW_MSG_ETH_PORT_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_LIST_CMD *)pOCTVC1_HW_MSG_ETH_PORT_LIST_CMD)->IndexGet ); }  \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_LIST_CMD_SWAP( pOCTVC1_HW_MSG_ETH_PORT_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_LIST_RSP * pOCTVC1_HW_MSG_ETH_PORT_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_LIST_RSP *)pOCTVC1_HW_MSG_ETH_PORT_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_LIST_RSP *)pOCTVC1_HW_MSG_ETH_PORT_LIST_RSP)->IndexGet ); }  \
	{ mOCTVC1_LIST_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_LIST_RSP *)pOCTVC1_HW_MSG_ETH_PORT_LIST_RSP)->IndexList ); }  \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_LIST_RSP_SWAP( pOCTVC1_HW_MSG_ETH_PORT_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_STATS_CMD * pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_STATS_CMD *)pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_STATS_CMD *)pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_STATS_CMD *)pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_ETH_PORT_STATS_CMD *)pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD)->ulResetStatsFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_STATS_CMD *)pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD)->ulResetStatsFlag); \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_STATS_CMD_SWAP( pOCTVC1_HW_MSG_ETH_PORT_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_STATS_RSP * pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_STATS_RSP *)pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_STATS_RSP *)pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_STATS_RSP *)pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP)->ulPortIndex); \
	{ mOCTVC1_HW_ETH_PORT_RX_STATS_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_STATS_RSP *)pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP)->RxStats ); }  \
	{ mOCTVC1_HW_ETH_PORT_TX_STATS_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_STATS_RSP *)pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP)->TxStats ); }  \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_STATS_RSP_SWAP( pOCTVC1_HW_MSG_ETH_PORT_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD * pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD)->ulPortIndex); \
	{ mOCTVC1_HW_ETH_PORT_CONFIG_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD)->Config ); }  \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD_SWAP( pOCTVC1_HW_MSG_ETH_PORT_MODIFY_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP * pOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP *)pOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP)->ulPortIndex); \
}
#else
#define mOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP_SWAP( pOCTVC1_HW_MSG_ETH_PORT_MODIFY_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_CMD * pOCTVC1_HW_MSG_RF_PORT_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_CMD)->ulPortIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_RSP * pOCTVC1_HW_MSG_RF_PORT_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulInService = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulInService); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->hOwner = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->hOwner); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulPortInterfaceId = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulPortInterfaceId); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulFrequencyMinKhz = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulFrequencyMinKhz); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulFrequencyMaxKhz = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_RSP)->ulFrequencyMaxKhz); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_STATS_CMD * pOCTVC1_HW_MSG_RF_PORT_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_STATS_CMD *)pOCTVC1_HW_MSG_RF_PORT_STATS_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_STATS_CMD *)pOCTVC1_HW_MSG_RF_PORT_STATS_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_STATS_CMD *)pOCTVC1_HW_MSG_RF_PORT_STATS_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_STATS_CMD *)pOCTVC1_HW_MSG_RF_PORT_STATS_CMD)->ulResetStatsFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_STATS_CMD *)pOCTVC1_HW_MSG_RF_PORT_STATS_CMD)->ulResetStatsFlag); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_STATS_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_STATS_RSP * pOCTVC1_HW_MSG_RF_PORT_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_STATS_RSP *)pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_STATS_RSP *)pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_STATS_RSP *)pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)->ulPortIndex); \
	{ mOCTVC1_RADIO_STANDARD_ENUM_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_STATS_RSP *)pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)->ulRadioStandard ); }  \
	{ mOCTVC1_HW_RF_PORT_RX_STATS_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_STATS_RSP *)pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)->RxStats ); }  \
	{ mOCTVC1_HW_RF_PORT_TX_STATS_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_STATS_RSP *)pOCTVC1_HW_MSG_RF_PORT_STATS_RSP)->TxStats ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_STATS_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_LIST_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_LIST_CMD * pOCTVC1_HW_MSG_RF_PORT_LIST_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_LIST_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_CMD *)pOCTVC1_HW_MSG_RF_PORT_LIST_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_CMD *)pOCTVC1_HW_MSG_RF_PORT_LIST_CMD)->IndexGet ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_LIST_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_LIST_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_LIST_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_LIST_RSP * pOCTVC1_HW_MSG_RF_PORT_LIST_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_LIST_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_RSP *)pOCTVC1_HW_MSG_RF_PORT_LIST_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_RSP *)pOCTVC1_HW_MSG_RF_PORT_LIST_RSP)->IndexGet ); }  \
	{ mOCTVC1_LIST_INDEX_GET_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_RSP *)pOCTVC1_HW_MSG_RF_PORT_LIST_RSP)->IndexList ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_LIST_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_LIST_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD * pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD *)pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SUB_INDEX_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD *)pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD)->SubIndexGet ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP * pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP *)pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP)->Header ); }  \
	{ mOCTVC1_CURSOR_INDEX_GET_SUB_INDEX_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP *)pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP)->SubIndexGet ); }  \
	{ mOCTVC1_LIST_INDEX_GET_SUB_INDEX_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP *)pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP)->SubIndexList ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_LIST_ANTENNA_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD)->ulAntennaIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)->ulAntennaIndex); \
	{ mOCTVC1_HW_RF_PORT_ANTENNA_RX_CONFIG_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP)->RxConfig ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_RX_CONFIG_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD)->ulAntennaIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)->ulAntennaIndex); \
	{ mOCTVC1_HW_RF_PORT_ANTENNA_TX_CONFIG_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP)->TxConfig ); }  \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CONFIG_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD)->ulAntennaIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulAntennaIndex); \
	{ mOCTVC1_HW_RF_PORT_ANTENNA_CALIB_STATE_ENUM_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulCalibState ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulCalibCnt = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->ulCalibCnt); \
	{ tOCT_UINT32 jOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP; \
	for( jOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP=0; \
		jOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP<(cOCTVC1_HW_RF_PORT_ANTENNA_MAX_TX_CALIB);jOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP++ ) \
	{ mOCTVC1_HW_RF_PORT_ANTENNA_TX_CALIB_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP)->aCalib[jOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP] ); }} \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_TX_CALIB_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->ulActivateFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD)->ulActivateFlag); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP)->ulAntennaIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CALIB_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD * pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD)->Header ); }  \
}
#else
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD_SWAP( pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP * pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP)->Header ); }  \
	{ mOCTVC1_HW_CLOCK_SYNC_MGR_SOURCE_ENUM_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP)->ulClkSourceRef ); }  \
	((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP)->ulMaxDriftDurationUs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP)->ulMaxDriftDurationUs); \
}
#else
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP_SWAP( pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_INFO_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD * pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD)->ulResetStatsFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD)->ulResetStatsFlag); \
}
#else
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD_SWAP( pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP * pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->Header ); }  \
	{ mOCTVC1_HW_CLOCK_SYNC_MGR_STATE_ENUM_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulState ); }  \
	{ mOCTVC1_HW_CLOCK_SYNC_MGR_DAC_STATE_ENUM_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulDacState ); }  \
	((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulDacValue = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulDacValue); \
	{ mOCTVC1_USER_ID_PROCESS_ENUM_SWAP( &((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulOwnerProcessUid ); }  \
	((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulDriftElapseTimeUs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP *)pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP)->ulDriftElapseTimeUs); \
}
#else
#define mOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP_SWAP( pOCTVC1_HW_MSG_CLOCK_SYNC_MGR_STATS_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->ulRelativeGainFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->ulRelativeGainFlag); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->lRxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD)->lRxGaindB); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->lRxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP)->lRxGaindB); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_RX_CONFIG_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->ulRelativeGainFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->ulRelativeGainFlag); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->lTxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD)->lTxGaindB); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->lTxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP)->lTxGaindB); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_TX_CONFIG_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD)->ulAntennaIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP * pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulInitializedFlag = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulInitializedFlag); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->lTxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->lTxGaindB); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->lRxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->lRxGaindB); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulTxPathDelayNs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulTxPathDelayNs); \
	((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulRxPathDelayNs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP)->ulRxPathDelayNs); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_INFO_ANTENNA_FRONT_END_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulAntennaIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->lTxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->lTxGaindB); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->lRxGaindB = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->lRxGaindB); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulTxPathDelayNs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulTxPathDelayNs); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulRxPathDelayNs = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD)->ulRxPathDelayNs); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_CMD )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#if defined( _OCT_ENDIAN_TYPE_LE_ )
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP_SWAP( _f_pParms ){ 	tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP * pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP = (_f_pParms); SWAP_UNUSED(pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP)\
	{ mOCTVC1_MSG_HEADER_SWAP( &((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP)->Header ); }  \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP)->ulPortIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP)->ulPortIndex); \
	((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP)->ulAntennaIndex = \
		mOCT_SWAP32_IF_LE(((tOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP *)pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP)->ulAntennaIndex); \
}
#else
#define mOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP_SWAP( pOCTVC1_HW_MSG_RF_PORT_MODIFY_ANTENNA_FRONT_END_RSP )
#endif /* _OCT_ENDIAN_TYPE_LE_ */

#ifdef __cplusplus
}

#endif

#endif /* __OCTVC1_HW_API_SWAP_H__ */
