/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File: octvc1_rc2string.h

Copyright (c) 2018 Octasic Inc. All rights reserved.

Description:

This file contains the rc2string implementation for package OCTVC1

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Release: OCTSDR Software Development Kit OCTSDR_GSM-02.11.00-B1927 (2018/04/27)

$Revision:  $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/


#ifndef __OCTVC1_RC2STRING__
#define __OCTVC1_RC2STRING__

#include "../octdev_types.h"
/* -------------------------------------------------------------------------------------
	OCTVC1_RC2STRING
   -------------------------------------------------------------------------------------*/
#define mOCTVC1_RC2STRING( _f_ulRc ) \
	octvc1_rc2string( _f_ulRc )

#ifndef OCTVC1_RC2STRING_DECLARE
extern const char * octvc1_rc2string( tOCT_UINT32 f_ulRc );
#endif 


#ifdef OCTVC1_RC2STRING_DECLARE
#include <stdio.h>
#include "octvc1_generic_rc.h"
#include "pkt_api/octvc1_pkt_api_rc.h"
#include "main/octvc1_main_rc.h"
#include "job/octvc1_job_rc.h"
#include "hw/octvc1_hw_rc.h"
#include "irsc/octvc1_irsc_rc.h"
#include "gsm/octvc1_gsm_rc.h"


/* -------------------------------------------------------------------------------------
	octvc1_rc2string
   -------------------------------------------------------------------------------------*/
const char * octvc1_rc2string( tOCT_UINT32 f_ulRc )
{
	static char g_szUnknownoctvc1_rc2string[32];
	switch( f_ulRc )
	{
		case cOCTVC1_RC_OK:
			return "cOCTVC1_RC_OK";
		case cOCTVC1_GENERIC_RC_BAD_PARAM:
			return "cOCTVC1_GENERIC_RC_BAD_PARAM";
		case cOCTVC1_GENERIC_RC_NOT_FOUND:
			return "cOCTVC1_GENERIC_RC_NOT_FOUND";
		case cOCTVC1_GENERIC_RC_ALREADY_USED:
			return "cOCTVC1_GENERIC_RC_ALREADY_USED";
		case cOCTVC1_GENERIC_RC_READ_OBJECT:
			return "cOCTVC1_GENERIC_RC_READ_OBJECT";
		case cOCTVC1_GENERIC_RC_WRITE_OBJECT:
			return "cOCTVC1_GENERIC_RC_WRITE_OBJECT";
		case cOCTVC1_GENERIC_RC_INVALID_TRANSACTION_ID:
			return "cOCTVC1_GENERIC_RC_INVALID_TRANSACTION_ID";
		case cOCTVC1_GENERIC_RC_ID_INVALID:
			return "cOCTVC1_GENERIC_RC_ID_INVALID";
		case cOCTVC1_GENERIC_RC_SUB_ID_INVALID:
			return "cOCTVC1_GENERIC_RC_SUB_ID_INVALID";
		case cOCTVC1_GENERIC_RC_GET_MODE_INVALID:
			return "cOCTVC1_GENERIC_RC_GET_MODE_INVALID";
		case cOCTVC1_GENERIC_RC_NO_MORE_OBJECT:
			return "cOCTVC1_GENERIC_RC_NO_MORE_OBJECT";
		case cOCTVC1_GENERIC_RC_NO_MORE_SUB_OBJECT:
			return "cOCTVC1_GENERIC_RC_NO_MORE_SUB_OBJECT";
		case cOCTVC1_GENERIC_RC_FULL:
			return "cOCTVC1_GENERIC_RC_FULL";
		case cOCTVC1_GENERIC_RC_TIMEOUT:
			return "cOCTVC1_GENERIC_RC_TIMEOUT";
		case cOCTVC1_GENERIC_RC_BAD_STATE:
			return "cOCTVC1_GENERIC_RC_BAD_STATE";
		case cOCTVC1_GENERIC_RC_ALREADY_START:
			return "cOCTVC1_GENERIC_RC_ALREADY_START";
		case cOCTVC1_GENERIC_RC_ALREADY_STOP:
			return "cOCTVC1_GENERIC_RC_ALREADY_STOP";
		case cOCTVC1_GENERIC_RC_API_CMD_NOT_IMPLEMENTED:
			return "cOCTVC1_GENERIC_RC_API_CMD_NOT_IMPLEMENTED";
		case cOCTVC1_GENERIC_RC_API_CMD_REJECT:
			return "cOCTVC1_GENERIC_RC_API_CMD_REJECT";
		case cOCTVC1_GENERIC_RC_API_CMD_RETRANSMIT:
			return "cOCTVC1_GENERIC_RC_API_CMD_RETRANSMIT";
		case cOCTVC1_GENERIC_RC_API_SESSION_INACTIVE:
			return "cOCTVC1_GENERIC_RC_API_SESSION_INACTIVE";
		case cOCTVC1_GENERIC_RC_API_INVALID_CMD_LENGTH:
			return "cOCTVC1_GENERIC_RC_API_INVALID_CMD_LENGTH";
		case cOCTVC1_GENERIC_RC_API_INVALID_CMD_ID:
			return "cOCTVC1_GENERIC_RC_API_INVALID_CMD_ID";
		case cOCTVC1_GENERIC_RC_API_ROUTING_ERROR:
			return "cOCTVC1_GENERIC_RC_API_ROUTING_ERROR";
		case cOCTVC1_GENERIC_RC_API_RSP_ERROR:
			return "cOCTVC1_GENERIC_RC_API_RSP_ERROR";
		case cOCTVC1_GENERIC_RC_MEMORY_LOCAL_ALLOC:
			return "cOCTVC1_GENERIC_RC_MEMORY_LOCAL_ALLOC";
		case cOCTVC1_GENERIC_RC_MEMORY_LOCAL_FREE:
			return "cOCTVC1_GENERIC_RC_MEMORY_LOCAL_FREE";
		case cOCTVC1_GENERIC_RC_MEMORY_RESIDENT_ALLOC:
			return "cOCTVC1_GENERIC_RC_MEMORY_RESIDENT_ALLOC";
		case cOCTVC1_GENERIC_RC_MEMORY_RESIDENT_FREE:
			return "cOCTVC1_GENERIC_RC_MEMORY_RESIDENT_FREE";
		case cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_ALLOC:
			return "cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_ALLOC";
		case cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_FREE:
			return "cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_FREE";
		case cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_READ:
			return "cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_READ";
		case cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_WRITE:
			return "cOCTVC1_GENERIC_RC_MEMORY_EXTERNAL_WRITE";
		case cOCTVC1_GENERIC_RC_MEMORY_IO_READ:
			return "cOCTVC1_GENERIC_RC_MEMORY_IO_READ";
		case cOCTVC1_GENERIC_RC_MEMORY_IO_WRITE:
			return "cOCTVC1_GENERIC_RC_MEMORY_IO_WRITE";
		case cOCTVC1_GENERIC_RC_MEMORY_CHECKSUM:
			return "cOCTVC1_GENERIC_RC_MEMORY_CHECKSUM";
		case cOCTVC1_GENERIC_RC_MEMORY_SIZE:
			return "cOCTVC1_GENERIC_RC_MEMORY_SIZE";
		case cOCTVC1_GENERIC_RC_MEMORY_SCRATCH_BAD_RESERVE:
			return "cOCTVC1_GENERIC_RC_MEMORY_SCRATCH_BAD_RESERVE";
		case cOCTVC1_GENERIC_RC_INTERNAL_ERROR:
			return "cOCTVC1_GENERIC_RC_INTERNAL_ERROR";
		case cOCTVC1_GENERIC_RC_INTERNAL_SERVICE_NOT_INIT:
			return "cOCTVC1_GENERIC_RC_INTERNAL_SERVICE_NOT_INIT";
		case cOCTVC1_GENERIC_RC_INTERNAL_TIMEOUT:
			return "cOCTVC1_GENERIC_RC_INTERNAL_TIMEOUT";
		case cOCTVC1_GENERIC_RC_INTERNAL_MSG_UNKNOWN:
			return "cOCTVC1_GENERIC_RC_INTERNAL_MSG_UNKNOWN";
		case cOCTVC1_PKT_API_RC_OS_ERROR:
			return "cOCTVC1_PKT_API_RC_OS_ERROR";
		case cOCTVC1_PKT_API_RC_TRANSPORT_ERROR:
			return "cOCTVC1_PKT_API_RC_TRANSPORT_ERROR";
		case cOCTVC1_PKT_API_RC_TIMEOUT:
			return "cOCTVC1_PKT_API_RC_TIMEOUT";
		case cOCTVC1_PKT_API_RC_LOCAL_MAC_INDEX_NOT_FOUND:
			return "cOCTVC1_PKT_API_RC_LOCAL_MAC_INDEX_NOT_FOUND";
		case cOCTVC1_PKT_API_RC_BAD_PARAM:
			return "cOCTVC1_PKT_API_RC_BAD_PARAM";
		case cOCTVC1_PKT_API_RC_INST_CNCT_NOMORE:
			return "cOCTVC1_PKT_API_RC_INST_CNCT_NOMORE";
		case cOCTVC1_PKT_API_RC_INST_PKT_NOMORE:
			return "cOCTVC1_PKT_API_RC_INST_PKT_NOMORE";
		case cOCTVC1_PKT_API_RC_INST_SYNC_TOOMANY:
			return "cOCTVC1_PKT_API_RC_INST_SYNC_TOOMANY";
		case cOCTVC1_PKT_API_RC_INST_CNCT_DEP:
			return "cOCTVC1_PKT_API_RC_INST_CNCT_DEP";
		case cOCTVC1_PKT_API_RC_INST_DISCOVER_INPROGRESS:
			return "cOCTVC1_PKT_API_RC_INST_DISCOVER_INPROGRESS";
		case cOCTVC1_PKT_API_RC_INST_RSP_TRUNCATE:
			return "cOCTVC1_PKT_API_RC_INST_RSP_TRUNCATE";
		case cOCTVC1_PKT_API_RC_INST_TERMINATED:
			return "cOCTVC1_PKT_API_RC_INST_TERMINATED";
		case cOCTVC1_PKT_API_RC_CNCT_SESS_NOMORE:
			return "cOCTVC1_PKT_API_RC_CNCT_SESS_NOMORE";
		case cOCTVC1_PKT_API_RC_CNCT_SESS_DEP:
			return "cOCTVC1_PKT_API_RC_CNCT_SESS_DEP";
		case cOCTVC1_PKT_API_RC_CNCT_BRIDGE_DEP:
			return "cOCTVC1_PKT_API_RC_CNCT_BRIDGE_DEP";
		case cOCTVC1_PKT_API_RC_CNCT_ALREADY_OPEN:
			return "cOCTVC1_PKT_API_RC_CNCT_ALREADY_OPEN";
		case cOCTVC1_PKT_API_RC_INTERFACE_NAME_NOT_FOUND:
			return "cOCTVC1_PKT_API_RC_INTERFACE_NAME_NOT_FOUND";
		case cOCTVC1_PKT_API_RC_DEPENDENCIES:
			return "cOCTVC1_PKT_API_RC_DEPENDENCIES";
		case cOCTVC1_PKT_API_RC_SESS_CLOSE:
			return "cOCTVC1_PKT_API_RC_SESS_CLOSE";
		case cOCTVC1_PKT_API_RC_CNCT_CLOSE:
			return "cOCTVC1_PKT_API_RC_CNCT_CLOSE";
		case cOCTVC1_PKT_API_RC_SESS_ALREADY_OPEN:
			return "cOCTVC1_PKT_API_RC_SESS_ALREADY_OPEN";
		case cOCTVC1_PKT_API_RC_NOT_IMPLEMENT_YET:
			return "cOCTVC1_PKT_API_RC_NOT_IMPLEMENT_YET";
		case cOCTVC1_PKT_API_RC_DISPATCHER_NOT_READY:
			return "cOCTVC1_PKT_API_RC_DISPATCHER_NOT_READY";
		case cOCTVC1_PKT_API_RC_REQUIRES_MULTI_THREAD:
			return "cOCTVC1_PKT_API_RC_REQUIRES_MULTI_THREAD";
		case cOCTVC1_MAIN_RC_PROCESS_IMAGE_LOAD_FILE_NOT_FOUND:
			return "cOCTVC1_MAIN_RC_PROCESS_IMAGE_LOAD_FILE_NOT_FOUND";
		case cOCTVC1_MAIN_RC_EVENT_MASK_INVALID:
			return "cOCTVC1_MAIN_RC_EVENT_MASK_INVALID";
		case cOCTVC1_MAIN_RC_PROCESS_NOT_FOUND:
			return "cOCTVC1_MAIN_RC_PROCESS_NOT_FOUND";
		case cOCTVC1_MAIN_RC_API_SYSTEM_SESSION_NOT_ACTIVE:
			return "cOCTVC1_MAIN_RC_API_SYSTEM_SESSION_NOT_ACTIVE";
		case cOCTVC1_MAIN_RC_RESET_STATS_ERROR:
			return "cOCTVC1_MAIN_RC_RESET_STATS_ERROR";
		case cOCTVC1_MAIN_RC_FILE_OPEN:
			return "cOCTVC1_MAIN_RC_FILE_OPEN";
		case cOCTVC1_MAIN_RC_FILE_HANDLE:
			return "cOCTVC1_MAIN_RC_FILE_HANDLE";
		case cOCTVC1_MAIN_RC_FILE_INVALID_ACCESS_RIGHTS:
			return "cOCTVC1_MAIN_RC_FILE_INVALID_ACCESS_RIGHTS";
		case cOCTVC1_MAIN_RC_FILE_WRITE:
			return "cOCTVC1_MAIN_RC_FILE_WRITE";
		case cOCTVC1_MAIN_RC_FILE_SEEK_UNKOWN_ORIGIN:
			return "cOCTVC1_MAIN_RC_FILE_SEEK_UNKOWN_ORIGIN";
		case cOCTVC1_MAIN_RC_FILE_SEEK_INVALID_OFFSET:
			return "cOCTVC1_MAIN_RC_FILE_SEEK_INVALID_OFFSET";
		case cOCTVC1_MAIN_RC_FILE_SEEK:
			return "cOCTVC1_MAIN_RC_FILE_SEEK";
		case cOCTVC1_MAIN_RC_FILE_NOT_FOUND:
			return "cOCTVC1_MAIN_RC_FILE_NOT_FOUND";
		case cOCTVC1_MAIN_RC_FILE_MAX_READ_BYTE_SIZE:
			return "cOCTVC1_MAIN_RC_FILE_MAX_READ_BYTE_SIZE";
		case cOCTVC1_MAIN_RC_FILE_MAX_WRITE_BYTE_SIZE:
			return "cOCTVC1_MAIN_RC_FILE_MAX_WRITE_BYTE_SIZE";
		case cOCTVC1_MAIN_RC_FILE_NAME:
			return "cOCTVC1_MAIN_RC_FILE_NAME";
		case cOCTVC1_MAIN_RC_FILE_ALREADY_OPENED:
			return "cOCTVC1_MAIN_RC_FILE_ALREADY_OPENED";
		case cOCTVC1_MAIN_RC_FILE_BUSY:
			return "cOCTVC1_MAIN_RC_FILE_BUSY";
		case cOCTVC1_MAIN_RC_FILE_ALREADY_CLOSED:
			return "cOCTVC1_MAIN_RC_FILE_ALREADY_CLOSED";
		case cOCTVC1_MAIN_RC_FILE_NOT_OPEN:
			return "cOCTVC1_MAIN_RC_FILE_NOT_OPEN";
		case cOCTVC1_MAIN_RC_FILE_FLASH_CMD_NOT_AVAILABLE:
			return "cOCTVC1_MAIN_RC_FILE_FLASH_CMD_NOT_AVAILABLE";
		case cOCTVC1_MAIN_RC_FILE_GET_MODE_INVALID:
			return "cOCTVC1_MAIN_RC_FILE_GET_MODE_INVALID";
		case cOCTVC1_MAIN_RC_FILE_ACCESS_DENIED:
			return "cOCTVC1_MAIN_RC_FILE_ACCESS_DENIED";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_INFO:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_INFO";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_INFO_NO_MORE_FILE:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_INFO_NO_MORE_FILE";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_CLOSE_LOCAL:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_CLOSE_LOCAL";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_ADD_REMOTE_FILE:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_ADD_REMOTE_FILE";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_DELETE_REMOTE_FILE:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_DELETE_REMOTE_FILE";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_TRANSFER_REMOTE_FILE:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_TRANSFER_REMOTE_FILE";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_NAME:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_NAME";
		case cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_CLOSE_FILE_STILL_OPEN:
			return "cOCTVC1_MAIN_RC_FILE_SYSTEM_CANNOT_CLOSE_FILE_STILL_OPEN";
		case cOCTVC1_MAIN_RC_APPLICATION_ALREADY_START:
			return "cOCTVC1_MAIN_RC_APPLICATION_ALREADY_START";
		case cOCTVC1_MAIN_RC_APPLICATION_MODULE_ALREADY_START:
			return "cOCTVC1_MAIN_RC_APPLICATION_MODULE_ALREADY_START";
		case cOCTVC1_MAIN_RC_APPLICATION_MODULE_ALREADY_STOP:
			return "cOCTVC1_MAIN_RC_APPLICATION_MODULE_ALREADY_STOP";
		case cOCTVC1_MAIN_RC_APPLICATION_MODULE_MAIN_CANNOT_BE_STOP:
			return "cOCTVC1_MAIN_RC_APPLICATION_MODULE_MAIN_CANNOT_BE_STOP";
		case cOCTVC1_MAIN_RC_APPLICATION_MODULE_ACCESS_DENIED:
			return "cOCTVC1_MAIN_RC_APPLICATION_MODULE_ACCESS_DENIED";
		case cOCTVC1_MAIN_RC_LICENSING_DENIED:
			return "cOCTVC1_MAIN_RC_LICENSING_DENIED";
		case cOCTVC1_MAIN_RC_LICENSING_INVALID_LICENSE:
			return "cOCTVC1_MAIN_RC_LICENSING_INVALID_LICENSE";
		case cOCTVC1_MAIN_RC_LICENSING_FEATURE_NOT_FOUND:
			return "cOCTVC1_MAIN_RC_LICENSING_FEATURE_NOT_FOUND";
		case cOCTVC1_MAIN_RC_CPU_USAGE_HANDLE_INVALID:
			return "cOCTVC1_MAIN_RC_CPU_USAGE_HANDLE_INVALID";
		case cOCTVC1_MAIN_RC_CPU_USAGE_THRESHOLD_INVALID:
			return "cOCTVC1_MAIN_RC_CPU_USAGE_THRESHOLD_INVALID";
		case cOCTVC1_MAIN_RC_CPU_USAGE_NOT_ACCESSIBLE:
			return "cOCTVC1_MAIN_RC_CPU_USAGE_NOT_ACCESSIBLE";
		case cOCTVC1_MAIN_RC_API_SESSION_SERVICE_NOT_INIT:
			return "cOCTVC1_MAIN_RC_API_SESSION_SERVICE_NOT_INIT";
		case cOCTVC1_MAIN_RC_API_SESSION_HEARTBEAT_ALREADY_START:
			return "cOCTVC1_MAIN_RC_API_SESSION_HEARTBEAT_ALREADY_START";
		case cOCTVC1_MAIN_RC_API_SESSION_HEARTBEAT_NOT_START:
			return "cOCTVC1_MAIN_RC_API_SESSION_HEARTBEAT_NOT_START";
		case cOCTVC1_MAIN_RC_LOG_LOGGER_NOT_INIT:
			return "cOCTVC1_MAIN_RC_LOG_LOGGER_NOT_INIT";
		case cOCTVC1_MAIN_RC_LOG_MGR_NOT_INIT:
			return "cOCTVC1_MAIN_RC_LOG_MGR_NOT_INIT";
		case cOCTVC1_MAIN_RC_LOG_INTERNAL_ERROR:
			return "cOCTVC1_MAIN_RC_LOG_INTERNAL_ERROR";
		case cOCTVC1_MAIN_RC_LOG_TRACE_ALREADY_START:
			return "cOCTVC1_MAIN_RC_LOG_TRACE_ALREADY_START";
		case cOCTVC1_MAIN_RC_LOG_TRACE_NOT_START:
			return "cOCTVC1_MAIN_RC_LOG_TRACE_NOT_START";
		case cOCTVC1_MAIN_RC_LOG_TRACE_MASK_INVALID:
			return "cOCTVC1_MAIN_RC_LOG_TRACE_MASK_INVALID";
		case cOCTVC1_MAIN_RC_LOG_TRACE_FILTER_PROCESS_EMPTY:
			return "cOCTVC1_MAIN_RC_LOG_TRACE_FILTER_PROCESS_EMPTY";
		case cOCTVC1_MAIN_RC_LOG_TRACE_START_INVALID_FILE_SIZE:
			return "cOCTVC1_MAIN_RC_LOG_TRACE_START_INVALID_FILE_SIZE";
		case cOCTVC1_MAIN_RC_LOG_TRACE_START_INVALID_FILE_NUMBER:
			return "cOCTVC1_MAIN_RC_LOG_TRACE_START_INVALID_FILE_NUMBER";
		case cOCTVC1_MAIN_RC_PROCESS_CPU_USAGE_MONITOR_INVALID_ALARM_THRESHOLD_HIGH_PERCENT:
			return "cOCTVC1_MAIN_RC_PROCESS_CPU_USAGE_MONITOR_INVALID_ALARM_THRESHOLD_HIGH_PERCENT";
		case cOCTVC1_MAIN_RC_PROCESS_CPU_USAGE_MONITOR_INVALID_ALARM_THRESHOLD_LOW_PERCENT:
			return "cOCTVC1_MAIN_RC_PROCESS_CPU_USAGE_MONITOR_INVALID_ALARM_THRESHOLD_LOW_PERCENT";
		case cOCTVC1_JOB_RC_OBJECT_INVALID:
			return "cOCTVC1_JOB_RC_OBJECT_INVALID";
		case cOCTVC1_JOB_RC_SERVICE_UNINITIALIZED:
			return "cOCTVC1_JOB_RC_SERVICE_UNINITIALIZED";
		case cOCTVC1_JOB_RC_UNITS_PACKAGE_NOT_FOUND:
			return "cOCTVC1_JOB_RC_UNITS_PACKAGE_NOT_FOUND";
		case cOCTVC1_JOB_RC_UNITS_SUITE_NOT_FOUND:
			return "cOCTVC1_JOB_RC_UNITS_SUITE_NOT_FOUND";
		case cOCTVC1_JOB_RC_UNITS_CASE_NOT_FOUND:
			return "cOCTVC1_JOB_RC_UNITS_CASE_NOT_FOUND";
		case cOCTVC1_JOB_RC_UNITS_PACKAGE_NAME_TOO_LONG:
			return "cOCTVC1_JOB_RC_UNITS_PACKAGE_NAME_TOO_LONG";
		case cOCTVC1_JOB_RC_UNITS_CASE_NAME_TOO_LONG:
			return "cOCTVC1_JOB_RC_UNITS_CASE_NAME_TOO_LONG";
		case cOCTVC1_JOB_RC_RUNNER_STATE_INVALID:
			return "cOCTVC1_JOB_RC_RUNNER_STATE_INVALID";
		case cOCTVC1_JOB_RC_RUNNER_CASE_IS_ACTIVE:
			return "cOCTVC1_JOB_RC_RUNNER_CASE_IS_ACTIVE";
		case cOCTVC1_JOB_RC_RUNNER_CASE_IS_NOT_ACTIVE:
			return "cOCTVC1_JOB_RC_RUNNER_CASE_IS_NOT_ACTIVE";
		case cOCTVC1_JOB_RC_RUNNER_REACH_MAXIMUM_CASE:
			return "cOCTVC1_JOB_RC_RUNNER_REACH_MAXIMUM_CASE";
		case cOCTVC1_JOB_RC_RUNNER_CASE_NOT_RUNNING:
			return "cOCTVC1_JOB_RC_RUNNER_CASE_NOT_RUNNING";
		case cOCTVC1_JOB_RC_RUNNER_CASES_PULSE_INVALID_PULSE_CNT:
			return "cOCTVC1_JOB_RC_RUNNER_CASES_PULSE_INVALID_PULSE_CNT";
		case cOCTVC1_HW_RC_CORE_NOT_FOUND:
			return "cOCTVC1_HW_RC_CORE_NOT_FOUND";
		case cOCTVC1_HW_RC_ETH_PORT_RESTRICTED_API_DENIED:
			return "cOCTVC1_HW_RC_ETH_PORT_RESTRICTED_API_DENIED";
		case cOCTVC1_HW_RC_ETH_PORT_IN_USED:
			return "cOCTVC1_HW_RC_ETH_PORT_IN_USED";
		case cOCTVC1_HW_RC_RF_PORT_UNUSED:
			return "cOCTVC1_HW_RC_RF_PORT_UNUSED";
		case cOCTVC1_HW_RC_RF_PORT_ANTENNA_UNUSED:
			return "cOCTVC1_HW_RC_RF_PORT_ANTENNA_UNUSED";
		case cOCTVC1_HW_RC_RF_PORT_ANTENNA_INTERNAL_ERROR:
			return "cOCTVC1_HW_RC_RF_PORT_ANTENNA_INTERNAL_ERROR";
		case cOCTVC1_HW_RC_RF_PORT_ANTENNA_CANNOT_MODIFY:
			return "cOCTVC1_HW_RC_RF_PORT_ANTENNA_CANNOT_MODIFY";
		case cOCTVC1_HW_RC_RF_PORT_TX_CALIBRATION_NOT_AVAILABLE:
			return "cOCTVC1_HW_RC_RF_PORT_TX_CALIBRATION_NOT_AVAILABLE";
		case cOCTVC1_HW_RC_RF_PORT_ANTENNA_RX_AGC_MODE:
			return "cOCTVC1_HW_RC_RF_PORT_ANTENNA_RX_AGC_MODE";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_ALREADY_OPEN:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_ALREADY_OPEN";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_OPEN_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_OPEN_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_CLOSE_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_CLOSE_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_BAD_PCB_INFO:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_BAD_PCB_INFO";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_DAC_OPEN_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_DAC_OPEN_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_PROCESS_OPEN_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_PROCESS_OPEN_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_PROCESS_CLOSE_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_PROCESS_CLOSE_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_DAC_CLOSE_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_DAC_CLOSE_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_STATS_ERROR:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_STATS_ERROR";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_NOT_SUPPORTED:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_NOT_SUPPORTED";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_NOT_OPENED:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_NOT_OPENED";
		case cOCTVC1_HW_RC_CLOCK_SYNC_MGR_BAD_CLOCK_SRC_REF_ON_FREE_RUN:
			return "cOCTVC1_HW_RC_CLOCK_SYNC_MGR_BAD_CLOCK_SRC_REF_ON_FREE_RUN";
		case cOCTVC1_HW_RC_RF_PORT_ANTENNA_RX_CONFIG_MODIFY_INVALID_RX_GAIND_B:
			return "cOCTVC1_HW_RC_RF_PORT_ANTENNA_RX_CONFIG_MODIFY_INVALID_RX_GAIND_B";
		case cOCTVC1_HW_RC_RF_PORT_ANTENNA_TX_CONFIG_MODIFY_INVALID_TX_GAIND_B:
			return "cOCTVC1_HW_RC_RF_PORT_ANTENNA_TX_CONFIG_MODIFY_INVALID_TX_GAIND_B";
		case cOCTVC1_IRSC_RC_INVALID_TASK:
			return "cOCTVC1_IRSC_RC_INVALID_TASK";
		case cOCTVC1_IRSC_RC_OBJMGR_LIST_ERROR:
			return "cOCTVC1_IRSC_RC_OBJMGR_LIST_ERROR";
		case cOCTVC1_IRSC_RC_OBJMGR_INVALID_OBJECT:
			return "cOCTVC1_IRSC_RC_OBJMGR_INVALID_OBJECT";
		case cOCTVC1_IRSC_RC_OBJMGR_INTERNAL_ERROR:
			return "cOCTVC1_IRSC_RC_OBJMGR_INTERNAL_ERROR";
		case cOCTVC1_IRSC_RC_OBJMGR_NOT_INIT:
			return "cOCTVC1_IRSC_RC_OBJMGR_NOT_INIT";
		case cOCTVC1_IRSC_RC_ROUTER_ROUTER_IF_INVALID:
			return "cOCTVC1_IRSC_RC_ROUTER_ROUTER_IF_INVALID";
		case cOCTVC1_IRSC_RC_API_COMMAND_MONITORING_DISABLE:
			return "cOCTVC1_IRSC_RC_API_COMMAND_MONITORING_DISABLE";
		case cOCTVC1_IRSC_RC_API_COMMAND_MAX_REACHED:
			return "cOCTVC1_IRSC_RC_API_COMMAND_MAX_REACHED";
		case cOCTVC1_IRSC_RC_API_COMMAND_MONITORING_ALREADY_START:
			return "cOCTVC1_IRSC_RC_API_COMMAND_MONITORING_ALREADY_START";
		case cOCTVC1_IRSC_RC_API_COMMAND_INTERNAL_ERROR:
			return "cOCTVC1_IRSC_RC_API_COMMAND_INTERNAL_ERROR";
		case cOCTVC1_IRSC_RC_ROUTER_STREAMER_MODIFY_INVALID_LIMIT_BANDWIDTH_MBPS:
			return "cOCTVC1_IRSC_RC_ROUTER_STREAMER_MODIFY_INVALID_LIMIT_BANDWIDTH_MBPS";
		case cOCTVC1_IRSC_RC_ROUTER_STREAMER_MODIFY_INVALID_TO_HOST_STREAM_SEQUENCE_ID_INTERVAL:
			return "cOCTVC1_IRSC_RC_ROUTER_STREAMER_MODIFY_INVALID_TO_HOST_STREAM_SEQUENCE_ID_INTERVAL";
		case cOCTVC1_IRSC_RC_ROUTER_STREAMER_MODIFY_INVALID_TO_HOST_STREAM_INITIAL_PKT_CNT:
			return "cOCTVC1_IRSC_RC_ROUTER_STREAMER_MODIFY_INVALID_TO_HOST_STREAM_INITIAL_PKT_CNT";
		case cOCTVC1_GSM_RC_GENERIC_EVENT_MASK_INVALID:
			return "cOCTVC1_GSM_RC_GENERIC_EVENT_MASK_INVALID";
		case cOCTVC1_GSM_RC_TRX_RESOURCE_UNAVAILABLE:
			return "cOCTVC1_GSM_RC_TRX_RESOURCE_UNAVAILABLE";
		case cOCTVC1_GSM_RC_TRX_ALREADY_OPENED:
			return "cOCTVC1_GSM_RC_TRX_ALREADY_OPENED";
		case cOCTVC1_GSM_RC_TRX_ID_INVALID:
			return "cOCTVC1_GSM_RC_TRX_ID_INVALID";
		case cOCTVC1_GSM_RC_TRX_NOT_FOUND:
			return "cOCTVC1_GSM_RC_TRX_NOT_FOUND";
		case cOCTVC1_GSM_RC_TRX_RADIO_INIT:
			return "cOCTVC1_GSM_RC_TRX_RADIO_INIT";
		case cOCTVC1_GSM_RC_TRX_RADIO_CONFIG:
			return "cOCTVC1_GSM_RC_TRX_RADIO_CONFIG";
		case cOCTVC1_GSM_RC_TRX_RADIO_RESET:
			return "cOCTVC1_GSM_RC_TRX_RADIO_RESET";
		case cOCTVC1_GSM_RC_TRX_RADIO_TERMINATE:
			return "cOCTVC1_GSM_RC_TRX_RADIO_TERMINATE";
		case cOCTVC1_GSM_RC_TRX_CENTRE_FREQ_NOT_SAME_ACROSS_TRX:
			return "cOCTVC1_GSM_RC_TRX_CENTRE_FREQ_NOT_SAME_ACROSS_TRX";
		case cOCTVC1_GSM_RC_TRX_CARRIER_OFFSET_OUTOF_RANGE:
			return "cOCTVC1_GSM_RC_TRX_CARRIER_OFFSET_OUTOF_RANGE";
		case cOCTVC1_GSM_RC_TRX_NOT_PROPERLY_SEPARATED:
			return "cOCTVC1_GSM_RC_TRX_NOT_PROPERLY_SEPARATED";
		case cOCTVC1_GSM_RC_TRX_BCCH_NOT_CONFIGURED:
			return "cOCTVC1_GSM_RC_TRX_BCCH_NOT_CONFIGURED";
		case cOCTVC1_GSM_RC_TRX_CLOSE_NONPRIMARY_FIRST:
			return "cOCTVC1_GSM_RC_TRX_CLOSE_NONPRIMARY_FIRST";
		case cOCTVC1_GSM_RC_TRX_PARAMS_INVALID:
			return "cOCTVC1_GSM_RC_TRX_PARAMS_INVALID";
		case cOCTVC1_GSM_RC_TRX_PRIMARY_ONLY_BCCH_CONFIGURED:
			return "cOCTVC1_GSM_RC_TRX_PRIMARY_ONLY_BCCH_CONFIGURED";
		case cOCTVC1_GSM_RC_TRX_PRE_CONFIG_OVERSAMPLE_SELECTION_NOT_DONE:
			return "cOCTVC1_GSM_RC_TRX_PRE_CONFIG_OVERSAMPLE_SELECTION_NOT_DONE";
		case cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_RESOURCE_UNAVAILABLE:
			return "cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_RESOURCE_UNAVAILABLE";
		case cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_ALREADY_ACTIVATED:
			return "cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_ALREADY_ACTIVATED";
		case cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_NOT_ACTIVATED:
			return "cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_NOT_ACTIVATED";
		case cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_ID_INVALID:
			return "cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_ID_INVALID";
		case cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_PARAMS_INVALID:
			return "cOCTVC1_GSM_RC_PHYSICAL_CHANNEL_PARAMS_INVALID";
		case cOCTVC1_GSM_RC_SUB_CHANNEL_ID_INVALID:
			return "cOCTVC1_GSM_RC_SUB_CHANNEL_ID_INVALID";
		case cOCTVC1_GSM_RC_SUB_CHANNEL_DIRECTION_INVALID:
			return "cOCTVC1_GSM_RC_SUB_CHANNEL_DIRECTION_INVALID";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_RESOURCE_UNAVAILABLE:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_RESOURCE_UNAVAILABLE";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_ALREADY_ACTIVATED:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_ALREADY_ACTIVATED";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_NOT_ACTIVATED:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_NOT_ACTIVATED";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_ID_INVALID:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_ID_INVALID";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_DIRECTION_INVALID:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_DIRECTION_INVALID";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_SAPI_INVALID:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_SAPI_INVALID";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_BCCH_BSIC_INVALID:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_BCCH_BSIC_INVALID";
		case cOCTVC1_GSM_RC_TEST_MODULE_GSM_MODULE_NOT_STARTED:
			return "cOCTVC1_GSM_RC_TEST_MODULE_GSM_MODULE_NOT_STARTED";
		case cOCTVC1_GSM_RC_RF_CONFIG_INVALID_RX_GAIN_DB:
			return "cOCTVC1_GSM_RC_RF_CONFIG_INVALID_RX_GAIN_DB";
		case cOCTVC1_GSM_RC_RF_CONFIG_INVALID_TX_ATTND_B:
			return "cOCTVC1_GSM_RC_RF_CONFIG_INVALID_TX_ATTND_B";
		case cOCTVC1_GSM_RC_RF_CONFIG_INVALID_TX_ANTENNA_ID:
			return "cOCTVC1_GSM_RC_RF_CONFIG_INVALID_TX_ANTENNA_ID";
		case cOCTVC1_GSM_RC_RF_CONFIG_INVALID_RX_ANTENNA_ID:
			return "cOCTVC1_GSM_RC_RF_CONFIG_INVALID_RX_ANTENNA_ID";
		case cOCTVC1_GSM_RC_TRX_CONFIG_INVALID_US_TSC:
			return "cOCTVC1_GSM_RC_TRX_CONFIG_INVALID_US_TSC";
		case cOCTVC1_GSM_RC_STUB_STATUS_INVALID_BY_TIMESLOT_USED:
			return "cOCTVC1_GSM_RC_STUB_STATUS_INVALID_BY_TIMESLOT_USED";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_DATA_INVALID_FRAME_NUMBER:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_DATA_INVALID_FRAME_NUMBER";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_DATA_INVALID_DATA_LENGTH:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_DATA_INVALID_DATA_LENGTH";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_RAW_DATA_INVALID_FRAME_NUMBER:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_RAW_DATA_INVALID_FRAME_NUMBER";
		case cOCTVC1_GSM_RC_LOGICAL_CHANNEL_RAW_DATA_INVALID_DATA_LENGTH:
			return "cOCTVC1_GSM_RC_LOGICAL_CHANNEL_RAW_DATA_INVALID_DATA_LENGTH";
		case cOCTVC1_GSM_RC_TAP_FILTER_PHYSICAL_CHANNEL_INVALID_ENTRY_CNT:
			return "cOCTVC1_GSM_RC_TAP_FILTER_PHYSICAL_CHANNEL_INVALID_ENTRY_CNT";
		case cOCTVC1_GSM_RC_TAP_FILTER_LOGICAL_CHANNEL_INVALID_ENTRY_CNT:
			return "cOCTVC1_GSM_RC_TAP_FILTER_LOGICAL_CHANNEL_INVALID_ENTRY_CNT";
		case cOCTVC1_GSM_RC_TAP_FILTER_STATS_INVALID_TAP_ID_CNT:
			return "cOCTVC1_GSM_RC_TAP_FILTER_STATS_INVALID_TAP_ID_CNT";
		case cOCTVC1_GSM_RC_MODULE_DATA_RF_UPLINK_INPUT_HEADER_INVALID_FRAME_NUMBER:
			return "cOCTVC1_GSM_RC_MODULE_DATA_RF_UPLINK_INPUT_HEADER_INVALID_FRAME_NUMBER";
		case cOCTVC1_GSM_RC_TRX_LOGICAL_CHANNEL_EMPTY_FRAME_REQUEST_INVALID_FRAME_NUMBER:
			return "cOCTVC1_GSM_RC_TRX_LOGICAL_CHANNEL_EMPTY_FRAME_REQUEST_INVALID_FRAME_NUMBER";

	}
	sprintf( g_szUnknownoctvc1_rc2string, "0x%.8X", f_ulRc ); 
	return g_szUnknownoctvc1_rc2string;
}
#endif 

#endif /* __OCTVC1_RC2STRING__ */
