/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimChannelManager;
import com.sun.javacard.jcwde.SimPrivAccess;
import com.sun.javacard.jcwde.SimulationException;
import java.util.Vector;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public class SimSystem {
    private static byte transDepth;
    private static byte MAX_NUM_APPLETS;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_TCL = -111;
    private static Vector clearOnResetTransientObjs;
    private static Vector[] clearOnDeselectTransientObjs;
    private static byte transportProtocol;

    public static void init(byte protocolChoice) {
        for (byte i = 0; i < MAX_NUM_APPLETS; i = (byte)(i + 1)) {
            SimSystem.clearOnDeselectTransientObjs[i] = new Vector(0, 5);
        }
        transportProtocol = protocolChoice;
    }

    public static byte getCommProtocol(byte activeInterface) {
        if (activeInterface == 0) {
            return transportProtocol;
        }
        return -111;
    }

    public static byte isTransient(Object object) throws SystemException {
        if (object != null) {
            if (clearOnResetTransientObjs.contains(object)) {
                return 1;
            }
            for (byte i = 0; i < MAX_NUM_APPLETS; i = (byte)(i + 1)) {
                if (!clearOnDeselectTransientObjs[i].contains(object)) continue;
                return 2;
            }
        }
        return 0;
    }

    public static void addTransientArray(Object array, byte event) throws SystemException {
        byte channelId = SimPrivAccess.getCurrentlySelectedChannel();
        byte interfaceID = NativeMethods.getActiveInterface();
        byte arrayDTR = (byte)(SimChannelManager.getActiveContext(channelId, interfaceID) >> 4 & 0xF);
        if (SimSystem.isTransient(array) != 0) {
            SystemException.throwIt((short)3);
        }
        Vector vect = null;
        switch (event) {
            case 1: {
                vect = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vect = clearOnDeselectTransientObjs[arrayDTR];
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        vect.addElement(array);
    }

    public static void clearTransientObjs(byte channelId, byte interfaceId, byte event) {
        int i;
        byte dtrToClean = (byte)(SimChannelManager.getActiveContext(channelId, interfaceId) >> 4 & 0xF);
        Vector vect = null;
        switch (event) {
            case 1: {
                for (i = 0; i < MAX_NUM_APPLETS; i = (int)((byte)(i + 1))) {
                    SimSystem.clearTransientObjs((byte)i, interfaceId, (byte)2);
                }
                vect = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vect = clearOnDeselectTransientObjs[dtrToClean];
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        for (i = vect.size() - 1; i >= 0; --i) {
            int j;
            Object[] array;
            Object object = vect.elementAt(i);
            if (object instanceof boolean[]) {
                array = (boolean[])object;
                for (j = array.length - 1; j >= 0; --j) {
                    array[j] = false;
                }
                continue;
            }
            if (object instanceof byte[]) {
                array = (byte[])object;
                for (j = array.length - 1; j >= 0; --j) {
                    array[j] = false;
                }
                continue;
            }
            if (object instanceof short[]) {
                array = (short[])object;
                for (j = array.length - 1; j >= 0; --j) {
                    array[j] = false;
                }
                continue;
            }
            if (object instanceof Object[]) {
                array = (Object[])object;
                for (j = array.length - 1; j >= 0; --j) {
                    array[j] = null;
                }
                continue;
            }
            System.err.println(Globals._messages.getString("ClearTrans"));
            throw new SimulationException();
        }
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws SystemException {
        boolean[] array = new boolean[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws SystemException {
        byte[] array = new byte[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static short[] makeTransientShortArray(short length, byte event) throws SystemException {
        short[] array = new short[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws SystemException {
        Object[] array = new Object[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static void beginTransaction() throws TransactionException {
        if (transDepth != 0) {
            TransactionException.throwIt((short)1);
        }
        transDepth = 1;
    }

    public static void abortTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static void commitTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static byte getTransactionDepth() {
        return transDepth;
    }

    public static short getUnusedCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public static short getMaxCommitCapacity() {
        return Short.MAX_VALUE;
    }

    static {
        MAX_NUM_APPLETS = (byte)16;
        clearOnResetTransientObjs = new Vector(0, 5);
        clearOnDeselectTransientObjs = new Vector[16];
    }
}

