/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.util;

import com.sun.javacardx.jcwde.SimArrayLogic;
import javacardx.framework.util.UtilException;

public class ArrayLogic {
    private ArrayLogic() {
    }

    public static final short arrayCopyRepack(Object src, short srcOff, short srcLen, Object dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (src == null || dest == null) {
            throw new NullPointerException();
        }
        if (src instanceof byte[] && dest instanceof byte[]) {
            return SimArrayLogic.arrayCopyRepack((byte[])src, srcOff, srcLen, (byte[])dest, destOff);
        }
        if (src instanceof byte[] && dest instanceof short[]) {
            return SimArrayLogic.arrayCopyRepack((byte[])src, srcOff, srcLen, (short[])dest, destOff);
        }
        if (src instanceof byte[] && dest instanceof int[]) {
            return SimArrayLogic.arrayCopyRepack((byte[])src, srcOff, srcLen, (int[])dest, destOff);
        }
        if (src instanceof short[] && dest instanceof byte[]) {
            return SimArrayLogic.arrayCopyRepack((short[])src, srcOff, srcLen, (byte[])dest, destOff);
        }
        if (src instanceof short[] && dest instanceof short[]) {
            return SimArrayLogic.arrayCopyRepack((short[])src, srcOff, srcLen, (short[])dest, destOff);
        }
        if (src instanceof short[] && dest instanceof int[]) {
            return SimArrayLogic.arrayCopyRepack((short[])src, srcOff, srcLen, (int[])dest, destOff);
        }
        if (src instanceof int[] && dest instanceof byte[]) {
            return SimArrayLogic.arrayCopyRepack((int[])src, srcOff, srcLen, (byte[])dest, destOff);
        }
        if (src instanceof int[] && dest instanceof short[]) {
            return SimArrayLogic.arrayCopyRepack((int[])src, srcOff, srcLen, (short[])dest, destOff);
        }
        if (src instanceof int[] && dest instanceof int[]) {
            return SimArrayLogic.arrayCopyRepack((int[])src, srcOff, srcLen, (int[])dest, destOff);
        }
        throw new UtilException(1);
    }

    public static final short arrayCopyRepackNonAtomic(Object src, short srcOff, short srcLen, Object dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        return ArrayLogic.arrayCopyRepack(src, srcOff, srcLen, dest, destOff);
    }

    public static final short arrayFillGenericNonAtomic(Object theArray, short off, short len, Object valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (theArray == null || valArray == null) {
            throw new NullPointerException();
        }
        if (len < 0 || off < 0 || valOff < 0) {
            throw new UtilException(1);
        }
        if (theArray instanceof byte[] && valArray instanceof byte[]) {
            return SimArrayLogic.arrayFill((byte[])theArray, off, len, (byte[])valArray, valOff);
        }
        if (theArray instanceof short[] && valArray instanceof short[]) {
            return SimArrayLogic.arrayFill((short[])theArray, off, len, (short[])valArray, valOff);
        }
        if (theArray instanceof int[] && valArray instanceof int[]) {
            return SimArrayLogic.arrayFill((int[])theArray, off, len, (int[])valArray, valOff);
        }
        throw new UtilException(2);
    }

    public static final byte arrayCompareGeneric(Object src, short srcOff, Object dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (src == null || dest == null) {
            throw new NullPointerException();
        }
        if (length < 0 || srcOff < 0 || destOff < 0) {
            throw new UtilException(1);
        }
        if (src instanceof byte[] && dest instanceof byte[]) {
            return SimArrayLogic.arrayCompare((byte[])src, srcOff, (byte[])dest, destOff, length);
        }
        if (src instanceof short[] && dest instanceof short[]) {
            return SimArrayLogic.arrayCompare((short[])src, srcOff, (short[])dest, destOff, length);
        }
        if (src instanceof int[] && dest instanceof int[]) {
            return SimArrayLogic.arrayCompare((int[])src, srcOff, (int[])dest, destOff, length);
        }
        throw new UtilException(2);
    }

    public static final short arrayFindGeneric(Object theArray, short off, byte[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (theArray == null || valArray == null) {
            throw new NullPointerException();
        }
        if (off < 0 || valOff < 0) {
            throw new UtilException(1);
        }
        if (theArray instanceof byte[]) {
            return SimArrayLogic.arrayFind((byte[])theArray, off, valArray, valOff);
        }
        if (theArray instanceof short[]) {
            return SimArrayLogic.arrayFind((short[])theArray, off, valArray, valOff);
        }
        if (theArray instanceof int[]) {
            return SimArrayLogic.arrayFind((int[])theArray, off, valArray, valOff);
        }
        throw new UtilException(1);
    }
}

