/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import com.sun.javacard.util.JCSystemAccessor;
import java.security.Permission;
import javacardx.facilities.EventRegistryPermission;
import javacardx.facilities.ServiceRegistryPermission;
import javacardx.facilities.TaskRegistryPermission;
import javacardx.framework.ContextPermission;
import javacardx.framework.JCRuntimePermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ConnectorPermission;
import javacardx.security.CryptoServicePermission;
import javacardx.security.NamedPermission;
import javacardx.spi.cardmgmt.CardManagementPermission;
import javacardx.spi.framework.JCREPermission;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class PermissionsParser {
    private static String[] getArgs(String str, int count) {
        String[] args = new String[count];
        int fqIndex = 0;
        int lqIndex = 0;
        try {
            for (int i = 0; i < count && str != null; ++i) {
                fqIndex = str.indexOf("\"");
                lqIndex = str.indexOf("\"", fqIndex + 1);
                args[i] = str.substring(fqIndex + 1, lqIndex);
                fqIndex = str.indexOf("\"", lqIndex + 1);
                str = fqIndex < 0 ? null : str.substring(fqIndex);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return args;
    }

    public static Permission parsePermissionString(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        int spaceIndex = str.indexOf(" ");
        String className = str.substring(0, spaceIndex);
        str = str.substring(spaceIndex).trim();
        Class<?> clazz = null;
        String[] args = null;
        Permission p = null;
        try {
            clazz = JCSystemAccessor.getJCSystemAccessor().getClassForName(className);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (JCREPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 1);
            p = new JCREPermission(args[0]);
        } else if (EventRegistryPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 2);
            p = new EventRegistryPermission(args[0], args[1]);
        } else if (ServiceRegistryPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 2);
            p = new ServiceRegistryPermission(args[0], args[1]);
        } else if (TaskRegistryPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 1);
            p = new TaskRegistryPermission(args[0]);
        } else if (ContextPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 2);
            p = new ContextPermission(args[0], args[1]);
        } else if (JCRuntimePermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 1);
            p = new JCRuntimePermission(args[0]);
        } else if (ConnectorPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 2);
            p = new ConnectorPermission(args[0], args[1]);
        } else if (CardManagementPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 1);
            p = new CardManagementPermission(args[0]);
        } else if (CryptoServicePermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 1);
            p = new CryptoServicePermission(args[0]);
        } else if (NamedPermission.class == clazz) {
            args = PermissionsParser.getArgs(str, 1);
            p = new NamedPermission(args[0]);
        }
        return p;
    }
}

