/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.jcrd;

import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.cm.impl.jcrd.ModuleInfo;
import com.sun.javacard.cm.impl.jcrd.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class JCRuntimeDesc {
    public static final String APP_TYPE_WEB = "web";
    public static final String APP_TYPE_EXTENDED_APPLET = "extended-applet";
    public static final String APP_TYPE_CLASSIC_APPLET = "classic-applet";
    public static final String[] MAPPING_ATTRIBUTES_LIST = new String[]{"-mapped-to-client-uri", "-mapped-to-domain-name", "-mapped-to-auth-credential", "-credential-auth-type", "-credential-auth-duration", "-mapped-to-auth-uri"};
    private String RTDescVersion;
    private Vector<ModuleInfo> modules;
    private byte appType = (byte)10;
    private Vector<String> libraries;
    private Hashtable<String, String> mainAttributes = new Hashtable();
    boolean isStandAloneModule = true;

    public JCRuntimeDesc(BufferedReader br) throws FormatErrorException, IOException {
        Util.startNewFile();
        this.parseBundleInfo(br);
    }

    public String getAppProperty(String requestedPropertyName) {
        requestedPropertyName = requestedPropertyName.toLowerCase();
        return this.mainAttributes.get(requestedPropertyName);
    }

    public String getRTDescVersion() {
        return this.RTDescVersion;
    }

    public String getBundleDisplayName() {
        return this.mainAttributes.get("bundle-display-name");
    }

    public String getBundleDescription() {
        return this.mainAttributes.get("bundle-description");
    }

    public Vector<ModuleInfo> getModuleList() {
        return this.modules;
    }

    public ModuleInfo getModule(String name) {
        for (ModuleInfo mi : this.modules) {
            if (!mi.getModuleName().equals(name)) continue;
            return mi;
        }
        return null;
    }

    public boolean isStandAloneModule() {
        return this.isStandAloneModule;
    }

    public Vector<String> getLibraryList() {
        return this.libraries;
    }

    public byte getAppType() {
        return this.appType;
    }

    void parseBundleInfo(BufferedReader br) throws FormatErrorException, IOException {
        StringBuffer lastLine = new StringBuffer();
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        Util.startReadNewSection();
        while (!Util.atSectionEnd() && !Util.fileEndReached) {
            boolean isSet = false;
            Util.readAttribute(br, name, value, lastLine);
            if (name.toString().equalsIgnoreCase("application-modules")) {
                this.isStandAloneModule = false;
            }
            if (name.toString().equalsIgnoreCase("name")) {
                Util.fatalError("4071", "");
            }
            for (String mappingPropertyName : MAPPING_ATTRIBUTES_LIST) {
                if (!name.toString().toLowerCase().endsWith(mappingPropertyName)) continue;
                int index = name.toString().toLowerCase().indexOf(mappingPropertyName);
                String role = name.toString().substring(0, index);
                if (role.equalsIgnoreCase("on-card-clients")) continue;
                this.mainAttributes.put(role + mappingPropertyName, value.toString());
                isSet = true;
            }
            if (isSet) continue;
            this.mainAttributes.put(name.toString().toLowerCase(), value.toString());
        }
        this.populateMainAttributes();
        Util.startReadNewSection();
        if (this.isStandAloneModule) {
            this.modules = new Vector();
            ModuleInfo singleModuleInfo = new ModuleInfo("");
            singleModuleInfo.setSingleModuleInfo(this.mainAttributes, this.appType);
            this.modules.addElement(singleModuleInfo);
            return;
        }
        Util.fatalError("4069", "");
        Vector<String> moduleNames = new Vector<String>();
        StringTokenizer st = new StringTokenizer(this.mainAttributes.get("application-modules"), ", ");
        while (st.hasMoreTokens()) {
            moduleNames.addElement(st.nextToken());
        }
        if (this.modules == null) {
            this.modules = new Vector();
        }
        while (!Util.fileEndReached) {
            ModuleInfo moduleInfo = new ModuleInfo("");
            moduleInfo.parseModuleinfo(br, this.appType, name, value, lastLine, this.isStandAloneModule);
            if (moduleNames.contains(moduleInfo.getModuleName())) {
                moduleNames.removeElement(moduleInfo.getModuleName());
                this.modules.addElement(moduleInfo);
            }
            if (Util.fileEndReached) continue;
            Util.startReadNewSection();
        }
        if (moduleNames.size() > 0) {
            Util.fatalError("4200", moduleNames.toString());
        }
    }

    private void populateMainAttributes() throws FormatErrorException {
        String appTypeString;
        this.RTDescVersion = this.mainAttributes.get("runtime-descriptor-version");
        if (this.RTDescVersion == null) {
            Util.fatalError("4070", "Runtime-Descriptor-Version");
        }
        if (!this.RTDescVersion.equals("3.0")) {
            Util.fatalError("4085", this.RTDescVersion);
        }
        if (!this.isStandAloneModule) {
            if (!this.mainAttributes.containsKey("application-modules")) {
                Util.fatalError("4070", "Application-Modules");
            }
        } else if (this.mainAttributes.containsKey("bundled-libraries")) {
            Util.fatalError("4072", "");
        }
        if ((appTypeString = this.mainAttributes.get("application-type")) == null) {
            Util.fatalError("4070", "Application-Type");
        }
        if (appTypeString == null || appTypeString.equals(APP_TYPE_WEB)) {
            this.appType = (byte)10;
        } else if (appTypeString.equals(APP_TYPE_EXTENDED_APPLET)) {
            this.appType = (byte)11;
        } else if (appTypeString.equals(APP_TYPE_CLASSIC_APPLET)) {
            this.appType = (byte)12;
        } else {
            Util.fatalError("4075", "");
        }
    }
}

