/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import javacard.framework.OwnerPIN;
import javacard.framework.Shareable;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.SharedPINAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javacardx.servlet.http.HttpDigestAuthentication;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class PINSessionAuthenticatorFactory
implements ServiceFactory {
    private final OwnerPIN ownerPIN;

    public PINSessionAuthenticatorFactory(byte[] pin, int maxSize, int tryLimit) {
        this.ownerPIN = new OwnerPIN((byte)tryLimit, (byte)maxSize);
        this.ownerPIN.update(pin, (short)0, (byte)pin.length);
    }

    @Override
    public Shareable create(String serviceURI, Object parameter) throws SecurityException {
        if ((serviceURI.startsWith("sio:///standard/auth/holder/session") || serviceURI.startsWith("sio:///standard/auth/user/session")) && serviceURI.endsWith("/pin")) {
            return new SessionPINAuth();
        }
        return null;
    }

    public OwnerPIN getOwnerPIN() {
        return this.ownerPIN;
    }

    @TransactionType(value=TransactionTypeValue.SUPPORTS)
    private class SessionPINAuth
    implements SharedPINAuth,
    HttpDigestAuthentication {
        private final TransientReference<Boolean> validated = new TransientReference<Boolean>(false);

        private SessionPINAuth() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(byte[] pin, short offset, byte length) {
            this.validated.set(false);
            OwnerPIN ownerPIN = PINSessionAuthenticatorFactory.this.ownerPIN;
            synchronized (ownerPIN) {
                try {
                    this.validated.set(PINSessionAuthenticatorFactory.this.ownerPIN.check(pin, offset, length));
                }
                finally {
                    PINSessionAuthenticatorFactory.this.ownerPIN.reset();
                }
            }
            return this.validated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(String username, String realm, String method, String uri, String nonce, String nc, String cnonce, String qop, String response) {
            this.validated.set(false);
            OwnerPIN ownerPIN = PINSessionAuthenticatorFactory.this.ownerPIN;
            synchronized (ownerPIN) {
                try {
                    if (PINSessionAuthenticatorFactory.this.ownerPIN instanceof HttpDigestAuthentication) {
                        this.validated.set(((HttpDigestAuthentication)((Object)PINSessionAuthenticatorFactory.this.ownerPIN)).check(username, realm, method, uri, nonce, nc, cnonce, qop, response));
                    }
                }
                finally {
                    PINSessionAuthenticatorFactory.this.ownerPIN.reset();
                }
            }
            return this.validated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getTriesRemaining() {
            OwnerPIN ownerPIN = PINSessionAuthenticatorFactory.this.ownerPIN;
            synchronized (ownerPIN) {
                return PINSessionAuthenticatorFactory.this.ownerPIN.getTriesRemaining();
            }
        }

        @Override
        public boolean isValidated() {
            return this.validated.get() != null && this.validated.get() != false;
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public void reset() {
            if (this.validated.get() != null && this.validated.get().booleanValue()) {
                this.validated.set(false);
            }
        }
    }
}

