/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.socket;

import com.sun.cldc.io.Waiter;
import com.sun.javacard.impl.NativeMethods;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.NetworkConnectionBase;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.serversocket.Socket;
import com.sun.midp.main.Configuration;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.AccessController;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ConnectorPermission;
import javax.microedition.io.Connection;
import javax.microedition.io.SocketConnection;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class Protocol
extends NetworkConnectionBase
implements SocketConnection {
    protected static int bufferSize;
    private String host;
    private int port;
    private boolean outputShutdown;

    public Protocol(String protocol, int defaultPort, boolean supportsPath) {
        super(bufferSize);
        this.protocol = protocol;
        this.defaultPort = defaultPort;
        this.supportsPath = supportsPath;
    }

    public Protocol() {
        this("socket", -1, false);
    }

    @Override
    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\"");
        }
        HttpUrl url = new HttpUrl(this.protocol, name);
        if (url.path != null || url.query != null || url.fragment != null) {
            throw new IllegalArgumentException("Malformed address");
        }
        this.host = url.host;
        this.port = url.port;
        if (this.host != null) {
            if (this.port < 0) {
                throw new IllegalArgumentException("Missing port number");
            }
            if (NativeMethods.getCurrentContext() != 0) {
                AccessController.checkPermission(new ConnectorPermission(url.normalize(this.defaultPort, this.supportsPath), "connect"));
            }
            return super.openPrim(name, mode, timeouts);
        }
        Socket con = new Socket();
        con.open(this.port);
        return con;
    }

    @Override
    public void connect(String name, int mode, boolean timeouts) throws IOException {
        byte[] szHost = Util.toCString(this.host);
        this.open0(szHost, this.port);
        this.registerCleanup();
    }

    public void open(int handle) {
        this.handle = handle;
        try {
            this.setStateOpen();
            if (NativeMethods.getCurrentContext() != 0) {
                String url = this.protocol + "://" + this.getAddress() + ":" + this.getPort();
                AccessController.checkPermission(new ConnectorPermission(url, "accept"));
            }
        }
        catch (Exception e2) {
            SecurityException e2;
            this.setStateClose();
            if (e2 instanceof IOException) {
                e2 = new SecurityException("Unknown TCP client");
            }
            try {
                this.close0();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (RuntimeException)e2;
        }
        this.registerCleanup();
    }

    @Override
    public void reset() {
    }

    @Override
    public void disconnect() throws IOException {
        if (!this.outputShutdown) {
            this.shutdownOutput0();
        }
        this.close0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int nonBufferedRead(byte[] b, int off, int len) throws IOException {
        while (true) {
            int bytesRead;
            try {
                bytesRead = this.read0(b, off, len);
            }
            finally {
                if (this.iStreams == 0) {
                    throw new InterruptedIOException("Stream closed");
                }
            }
            if (bytesRead == -1) {
                this.eof = true;
                return -1;
            }
            if (bytesRead != 0) {
                return bytesRead;
            }
            Waiter.waitForIO();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.count > 0) {
            return this.count;
        }
        return this.available0();
    }

    @Override
    public int writeBytes(byte[] b, int off, int len) throws IOException {
        return this.write0(b, off, len);
    }

    @Override
    protected void closeOutputStream() throws IOException {
        this.shutdownOutput0();
        this.outputShutdown = true;
        super.closeOutputStream();
    }

    private void checkOption(byte option) throws IllegalArgumentException {
        if (option == 2 || option == 1 || option == 4 || option == 3 || option == 0) {
            return;
        }
        throw new IllegalArgumentException("Unsupported Socket Option");
    }

    @Override
    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        this.checkOption(option);
        if (value < 0) {
            throw new IllegalArgumentException("Unsupported Socket Option");
        }
        this.ensureOpen();
        this.setSockOpt0(option, value);
    }

    @Override
    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        this.checkOption(option);
        this.ensureOpen();
        return this.getSockOpt0(option);
    }

    @Override
    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return this.getHost0(true);
    }

    @Override
    public int getLocalPort() throws IOException {
        this.ensureOpen();
        return this.getPort0(true);
    }

    @Override
    public String getAddress() throws IOException {
        this.ensureOpen();
        return this.getHost0(false);
    }

    @Override
    public int getPort() throws IOException {
        this.ensureOpen();
        return this.getPort0(false);
    }

    private native void open0(byte[] var1, int var2) throws IOException;

    private native int read0(byte[] var1, int var2, int var3) throws IOException;

    private native int write0(byte[] var1, int var2, int var3) throws IOException;

    private native int available0() throws IOException;

    private native void close0() throws IOException;

    private native void registerCleanup();

    private native void finalize();

    private native String getHost0(boolean var1);

    private native int getPort0(boolean var1);

    private native int getSockOpt0(int var1);

    private native void setSockOpt0(int var1, int var2);

    private native void shutdownOutput0();

    static {
        String size = Configuration.getProperty("javacard.io.socket.buffersize");
        if (size != null) {
            try {
                bufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

