/*
 * Decompiled with CFR 0.152.
 */
package javacardx.security;

import com.sun.javacard.URI;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.URIUtils;
import java.security.Permission;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ConnectorPermission;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class URIPermission
extends Permission {
    private String canonicalURI;
    private String scheme;
    private String authority;
    private String path;
    private boolean pattern;
    private boolean generic;
    private boolean opaque;
    private String canonicalActions = "";
    private String[] canonicalActionArray;
    private static final String SLASH = "/";
    private static final String STAR_DOT = "*.";
    private static final String STAR_COLON = "*:";
    private static final String COLON_STAR = ":*";
    private static final String STAR_COLON_STAR = "*:*";
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final String STAR = "*";
    private static final String GENERIC_ROOT = "/~";
    private boolean wildCardTarget = false;

    public URIPermission(String uri) {
        this(uri, null);
    }

    public URIPermission(String uri, String actions) {
        super(uri);
        if (this.getClass().equals(ConnectorPermission.class)) {
            this.wildCardTarget = uri.equals(STAR);
        }
        uri.equals(null);
        if (actions != null) {
            actions.equals(null);
        }
        if (!this.wildCardTarget && !URIUtils.isAbsolute(uri)) {
            throw new IllegalArgumentException();
        }
        this.init(uri, actions);
    }

    public URIPermission(String scheme, String uri, String actions) {
        super(uri);
        if (scheme != null) {
            scheme.equals(null);
        }
        uri.equals(null);
        if (actions != null) {
            actions.equals(null);
        }
        if (scheme != null && !scheme.equals("pd") && URIUtils.isOpaque(uri)) {
            throw new IllegalArgumentException();
        }
        uri = URIUtils.resolveWithScheme(scheme, uri);
        this.init(uri, actions);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            NativeMethods.checkPreviousContextAccess(obj);
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URIPermission)) {
            return false;
        }
        URIPermission other = (URIPermission)obj;
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (this.wildCardTarget && other.wildCardTarget) {
            return true;
        }
        if (this.canonicalURI == null ? other.canonicalURI != null : !this.canonicalURI.equals(other.canonicalURI)) {
            return false;
        }
        if (this.canonicalActions == null ? other.canonicalActions != null : !this.canonicalActions.equals(other.canonicalActions)) {
            return false;
        }
        if (this.generic != other.generic) {
            return false;
        }
        return this.pattern == other.pattern;
    }

    @Override
    public String getActions() {
        return this.canonicalActions;
    }

    protected String[] getPossibleActions() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalURI == null ? 0 : this.canonicalURI.hashCode());
        result = 31 * result + (this.canonicalActions == null ? 0 : this.canonicalActions.hashCode());
        result = 31 * result + (this.generic ? 1231 : 1237);
        result = 31 * result + (this.pattern ? 1231 : 1237);
        result = 31 * result + (this.wildCardTarget ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean implies(Permission p) {
        if (p != null) {
            NativeMethods.checkPreviousContextAccess(p);
        }
        if (p == null || p.getClass() != this.getClass()) {
            return false;
        }
        URIPermission that = (URIPermission)p;
        if (this.wildCardTarget) {
            return true;
        }
        if (this.opaque) {
            if (!that.opaque) {
                return false;
            }
            if (!this.canonicalURI.equals(that.canonicalURI)) {
                return false;
            }
        }
        if (this.scheme == null ? that.scheme != null : !this.scheme.equals(that.scheme)) {
            return false;
        }
        if (!this.authority_implies(that)) {
            return false;
        }
        if (!this.path_implies(that)) {
            return false;
        }
        if (this.canonicalActionArray == null && that.canonicalActionArray != null) {
            return false;
        }
        if (this.canonicalActionArray != null && that.canonicalActionArray == null) {
            return true;
        }
        if (this.canonicalActionArray != null && that.canonicalActionArray != null) {
            if (this.canonicalActionArray.length < that.canonicalActionArray.length) {
                return false;
            }
            block0: for (String thatAction : that.canonicalActionArray) {
                for (String thisAction : this.canonicalActionArray) {
                    if (thisAction.equals(thatAction)) continue block0;
                }
                return false;
            }
        }
        return true;
    }

    private boolean authority_implies(URIPermission p) {
        String other = p.authority;
        if (this.authority == null) {
            return other == null;
        }
        if (this.authority.equals(STAR)) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.authority.equals(STAR_COLON_STAR)) {
            return other != null && other.indexOf(COLON) != -1;
        }
        if (this.authority.indexOf(STAR) == -1) {
            return this.authority.equals(other);
        }
        if (this.authority.startsWith(STAR_DOT) && other != null) {
            if (this.authority.indexOf(STAR, 2) == -1) {
                return other.endsWith(this.authority.substring(1));
            }
            int colon_index = this.authority.indexOf(COLON);
            int l1 = colon_index - STAR_DOT.length();
            int dot_index = other.indexOf(DOT);
            int l2 = other.indexOf(COLON) - (dot_index + 1);
            if (l1 != l2) {
                return false;
            }
            return this.authority.regionMatches(false, STAR_DOT.length(), other, dot_index + 1, l1);
        }
        if (this.authority.endsWith(COLON_STAR)) {
            int l = this.authority.indexOf(COLON_STAR);
            return other != null && other.startsWith(this.authority.substring(0, l + 1));
        }
        if (this.authority.startsWith(STAR_COLON)) {
            return other != null && other.endsWith(this.authority.substring(1));
        }
        return false;
    }

    private boolean path_implies(URIPermission p) {
        String other = p.path;
        if (this.path == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        if (this.generic) {
            String appSIORoot = URIUtils.getAppRootURIPath();
            if (appSIORoot != null && other.startsWith(appSIORoot) || p.generic) {
                String prefix;
                if (appSIORoot == null) {
                    prefix = "";
                } else {
                    String string = prefix = other.startsWith(appSIORoot) ? appSIORoot : "";
                }
                if (this.pattern) {
                    if (p.pattern) {
                        if (this.path.length() == other.length() - prefix.length() && other.regionMatches(false, prefix.length(), this.path, 0, this.path.length())) {
                            return true;
                        }
                    } else {
                        if (this.path.length() <= other.length() - prefix.length() && other.regionMatches(false, prefix.length(), this.path, 0, this.path.length())) {
                            return true;
                        }
                        if (this.path.equals("")) {
                            return other.equals("");
                        }
                    }
                } else if (this.path.length() == other.length() - prefix.length() && other.regionMatches(false, prefix.length(), this.path, 0, this.path.length())) {
                    return true;
                }
            }
        } else if (this.pattern) {
            if (p.pattern) {
                if (this.path.length() <= other.length() && other.regionMatches(false, 0, this.path, 0, this.path.length())) {
                    return true;
                }
            } else {
                if (this.path.length() < other.length() && other.startsWith(this.path)) {
                    return true;
                }
                if (this.path.equals("")) {
                    return other.equals("");
                }
            }
        } else if (other.equals(this.path) && !p.pattern) {
            return true;
        }
        return false;
    }

    private void init(String uri, String actions) {
        String[] possibleActions;
        String uriPatternBase;
        if (uri == null) {
            throw new NullPointerException("uri can't be null");
        }
        int len = uri.length();
        if (len == 0) {
            throw new IllegalArgumentException("uri can't be empty");
        }
        char last = uri.charAt(len - 1);
        if (last == '*' && (len == 1 || uri.charAt(len - 2) == '/')) {
            this.pattern = true;
            uriPatternBase = len == 1 ? "" : uri.substring(0, len - 1);
        } else {
            uriPatternBase = uri;
        }
        this.canonicalURI = URIUtils.normalize(uriPatternBase);
        this.canonicalURI = URIUtils.normalizeReservedURI(this.canonicalURI);
        if (actions != null) {
            this.canonicalActions = this.getCanonicalizedActionsString(actions);
        }
        if ((possibleActions = this.getPossibleActions()) != null && this.canonicalActionArray != null) {
            block0: for (String action : this.canonicalActionArray) {
                for (String possibleAction : possibleActions) {
                    if (action.equals(possibleAction)) continue block0;
                }
                throw new IllegalArgumentException("Unknown action: " + action);
            }
        }
        URI u = URI.create(this.canonicalURI);
        u = u.normalize();
        this.scheme = u.getScheme();
        this.authority = u.getRawAuthority();
        this.path = u.getRawPath();
        if (this.path != null && this.path.endsWith(SLASH)) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        boolean bl = this.generic = this.path != null && this.path.startsWith(GENERIC_ROOT);
        if (this.generic) {
            this.path = this.path.substring(GENERIC_ROOT.length());
        }
        this.opaque = u.isOpaque();
    }

    private String getCanonicalizedActionsString(String actions) {
        Vector<String> strings = new Vector<String>();
        StringBuffer sortedString = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            this.addToSortedVector(str.trim(), strings);
        }
        int numStrings = strings.size();
        if (numStrings > 0) {
            String s;
            this.canonicalActionArray = new String[numStrings];
            this.canonicalActionArray[0] = s = strings.elementAt(0).trim();
            sortedString.append(s);
            for (int index = 1; index < numStrings; ++index) {
                this.canonicalActionArray[index] = s = strings.elementAt(index).trim();
                sortedString.append("," + s);
            }
        }
        return sortedString.toString();
    }

    private void addToSortedVector(String newStr, Vector<String> strings) {
        newStr = newStr.toLowerCase();
        int index = 0;
        for (String str : strings) {
            if (str.compareTo(newStr) > 0) break;
            ++index;
        }
        strings.insertElementAt(newStr, index);
    }
}

