/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import com.sun.javacard.impl.NativeMethods;
import java.util.Enumeration;
import java.util.Hashtable;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class MimeTypes {
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MESSAGE_HTTP = "message/http";
    public static final String MULTIPART_BYTERANGES = "multipart/byteranges";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML_8859_1 = "text/html; charset=ISO-8859-1";
    public static final String TEXT_PLAIN_8859_1 = "text/plain; charset=ISO-8859-1";
    public static final String TEXT_XML_8859_1 = "text/xml; charset=ISO-8859-1";
    public static final String TEXT_HTML_UTF_8 = "text/html; charset=UTF-8";
    public static final String TEXT_PLAIN_UTF_8 = "text/plain; charset=UTF-8";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=UTF-8";
    private static int index = 1;
    private static final int FORM_ENCODED_ORDINAL = index++;
    private static final int MESSAGE_HTTP_ORDINAL = index++;
    private static final int MULTIPART_BYTERANGES_ORDINAL = index++;
    private static final int TEXT_HTML_ORDINAL = index++;
    private static final int TEXT_PLAIN_ORDINAL = index++;
    private static final int TEXT_XML_ORDINAL = index++;
    private static final int TEXT_HTML_8859_1_ORDINAL = index++;
    private static final int TEXT_PLAIN_8859_1_ORDINAL = index++;
    private static final int TEXT_XML_8859_1_ORDINAL = index++;
    private static final int TEXT_HTML_UTF_8_ORDINAL = index++;
    private static final int TEXT_PLAIN_UTF_8_ORDINAL = index++;
    private static final int TEXT_XML_UTF_8_ORDINAL = index++;
    public static final BufferCache CACHE = new BufferCache();
    public static final BufferCache.CachedBuffer FORM_ENCODED_BUFFER = CACHE.add("application/x-www-form-urlencoded", FORM_ENCODED_ORDINAL);
    public static final BufferCache.CachedBuffer MESSAGE_HTTP_BUFFER = CACHE.add("message/http", MESSAGE_HTTP_ORDINAL);
    public static final BufferCache.CachedBuffer MULTIPART_BYTERANGES_BUFFER = CACHE.add("multipart/byteranges", MULTIPART_BYTERANGES_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_HTML_BUFFER = CACHE.add("text/html", TEXT_HTML_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_BUFFER = CACHE.add("text/plain", TEXT_PLAIN_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_XML_BUFFER = CACHE.add("text/xml", TEXT_XML_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_HTML_8859_1_BUFFER = new BufferCache.CachedBuffer("text/html; charset=ISO-8859-1", TEXT_HTML_8859_1_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_8859_1_BUFFER = new BufferCache.CachedBuffer("text/plain; charset=ISO-8859-1", TEXT_PLAIN_8859_1_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_XML_8859_1_BUFFER = new BufferCache.CachedBuffer("text/xml; charset=ISO-8859-1", TEXT_XML_8859_1_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_HTML_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/html; charset=UTF-8", TEXT_HTML_UTF_8_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/plain; charset=UTF-8", TEXT_PLAIN_UTF_8_ORDINAL);
    public static final BufferCache.CachedBuffer TEXT_XML_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/xml; charset=UTF-8", TEXT_XML_UTF_8_ORDINAL);
    private static final Hashtable<String, Buffer> __dftMimeMap = new Hashtable();
    private static final Hashtable<String, String> __encodings = new Hashtable();
    private Hashtable<String, Buffer> mimeMap;
    private Hashtable<String, String> encodingMap;

    public static void initMimeTypes() {
        NativeMethods.setJCREentry(TEXT_HTML_8859_1_BUFFER, false);
        NativeMethods.setJCREentry(TEXT_PLAIN_8859_1_BUFFER, false);
        NativeMethods.setJCREentry(TEXT_XML_8859_1_BUFFER, false);
        NativeMethods.setJCREentry(TEXT_HTML_UTF_8_BUFFER, false);
        NativeMethods.setJCREentry(TEXT_PLAIN_UTF_8_BUFFER, false);
        NativeMethods.setJCREentry(TEXT_XML_UTF_8_BUFFER, false);
        NativeMethods.setJCREentry(CACHE, false);
        NativeMethods.setJCREentry(__dftMimeMap, false);
        NativeMethods.setJCREentry(__encodings, false);
        MimeTypes.uglyMimeLoading();
        MimeTypes.uglyEncodingLoading();
        TEXT_HTML_BUFFER.setAssociate("ISO-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("ISO_8859_1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("iso-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO_8859_1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("iso-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO_8859_1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("iso-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("utf-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf-8", TEXT_XML_UTF_8_BUFFER);
        Logger.debug("org.mortbay.jetty.MimeTypes.STATIC() -> DONE");
    }

    public synchronized Hashtable<String, Buffer> getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(Hashtable<String, Buffer> mimeMap) {
        if (mimeMap == null) {
            this.mimeMap = null;
            return;
        }
        Hashtable<String, Buffer> m = new Hashtable<String, Buffer>();
        Enumeration<String> i = mimeMap.keys();
        String key = null;
        Buffer value = null;
        while (i.hasMoreElements()) {
            key = i.nextElement();
            value = mimeMap.get(key);
            m.put(key, MimeTypes.normalizeMimeType(value.toString()));
        }
        this.mimeMap = m;
        NativeMethods.setJCREentry(this.mimeMap, false);
    }

    public Buffer getMimeByExtension(String filename) {
        Logger.debug("org.mortbay.jetty.MimeTypes.getMimeByExtension() -> " + filename);
        Buffer type = null;
        if (filename != null) {
            int i = -1;
            while (type == null && (i = filename.indexOf(".", i + 1)) >= 0 && i < filename.length()) {
                String ext = filename.substring(i + 1).toLowerCase();
                Logger.debug("org.mortbay.jetty.MimeTypes.getMimeByExtension() -> ext = " + ext);
                if (this.mimeMap != null) {
                    type = this.mimeMap.get(ext);
                }
                if (type != null) continue;
                type = __dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this.mimeMap != null) {
                type = this.mimeMap.get("*");
            }
            if (type == null) {
                type = __dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        if (this.mimeMap == null) {
            this.mimeMap = new Hashtable();
        }
        this.mimeMap.put(extension.toLowerCase(), MimeTypes.normalizeMimeType(type));
    }

    public synchronized Hashtable<String, String> getEncodingMap() {
        return this.encodingMap;
    }

    public void setEncodingMap(Hashtable<String, String> encodingMap) {
        if (encodingMap == null) {
            this.encodingMap = null;
            return;
        }
        Hashtable<String, String> e = new Hashtable<String, String>();
        Enumeration<String> i = encodingMap.keys();
        String key = null;
        String value = null;
        while (i.hasMoreElements()) {
            key = i.nextElement();
            value = encodingMap.get(key);
            e.put(key, value);
        }
        this.encodingMap = e;
    }

    public String getEncodingByMimeType(String type) {
        String encoding = null;
        if (type != null) {
            encoding = this.encodingMap.get(type);
        }
        return encoding;
    }

    public void addTypeEncoding(String mimeType, String encoding) {
        this.getEncodingMap().put(mimeType, encoding);
    }

    private static synchronized Buffer normalizeMimeType(String type) {
        BufferCache.CachedBuffer b = CACHE.get(type);
        if (b == null) {
            b = CACHE.add(type, index++);
        }
        return b;
    }

    private static void uglyMimeLoading() {
        __dftMimeMap.put("ai", MimeTypes.normalizeMimeType("application/postscript"));
        __dftMimeMap.put("aif", MimeTypes.normalizeMimeType("audio/x-aiff"));
        __dftMimeMap.put("aifc", MimeTypes.normalizeMimeType("audio/x-aiff"));
        __dftMimeMap.put("aiff", MimeTypes.normalizeMimeType("audio/x-aiff"));
        __dftMimeMap.put("asc", MimeTypes.normalizeMimeType(TEXT_PLAIN));
        __dftMimeMap.put("asf", MimeTypes.normalizeMimeType("video/x.ms.asf"));
        __dftMimeMap.put("asx", MimeTypes.normalizeMimeType("video/x.ms.asx"));
        __dftMimeMap.put("au", MimeTypes.normalizeMimeType("audio/basic"));
        __dftMimeMap.put("avi", MimeTypes.normalizeMimeType("video/x-msvideo"));
        __dftMimeMap.put("bcpio", MimeTypes.normalizeMimeType("application/x-bcpio"));
        __dftMimeMap.put("bin", MimeTypes.normalizeMimeType("application/octet-stream"));
        __dftMimeMap.put("cab", MimeTypes.normalizeMimeType("application/x-cabinet"));
        __dftMimeMap.put("cdf", MimeTypes.normalizeMimeType("application/x-netcdf"));
        __dftMimeMap.put("class", MimeTypes.normalizeMimeType("application/java-vm"));
        __dftMimeMap.put("cpio", MimeTypes.normalizeMimeType("application/x-cpio"));
        __dftMimeMap.put("cpt", MimeTypes.normalizeMimeType("application/mac-compactpro"));
        __dftMimeMap.put("crt", MimeTypes.normalizeMimeType("application/x-x509-ca-cert"));
        __dftMimeMap.put("csh", MimeTypes.normalizeMimeType("application/x-csh"));
        __dftMimeMap.put("css", MimeTypes.normalizeMimeType("text/css"));
        __dftMimeMap.put("csv", MimeTypes.normalizeMimeType("text/comma-separated-values"));
        __dftMimeMap.put("dcr", MimeTypes.normalizeMimeType("application/x-director"));
        __dftMimeMap.put("dir", MimeTypes.normalizeMimeType("application/x-director"));
        __dftMimeMap.put("dll", MimeTypes.normalizeMimeType("application/x-msdownload"));
        __dftMimeMap.put("dms", MimeTypes.normalizeMimeType("application/octet-stream"));
        __dftMimeMap.put("doc", MimeTypes.normalizeMimeType("application/msword"));
        __dftMimeMap.put("dtd", MimeTypes.normalizeMimeType("application/xml-dtd"));
        __dftMimeMap.put("dvi", MimeTypes.normalizeMimeType("application/x-dvi"));
        __dftMimeMap.put("dxr", MimeTypes.normalizeMimeType("application/x-director"));
        __dftMimeMap.put("eps", MimeTypes.normalizeMimeType("application/postscript"));
        __dftMimeMap.put("etx", MimeTypes.normalizeMimeType("text/x-setext"));
        __dftMimeMap.put("exe", MimeTypes.normalizeMimeType("application/octet-stream"));
        __dftMimeMap.put("ez", MimeTypes.normalizeMimeType("application/andrew-inset"));
        __dftMimeMap.put("gif", MimeTypes.normalizeMimeType("image/gif"));
        __dftMimeMap.put("gtar", MimeTypes.normalizeMimeType("application/x-gtar"));
        __dftMimeMap.put("gz", MimeTypes.normalizeMimeType("application/gzip"));
        __dftMimeMap.put("gzip", MimeTypes.normalizeMimeType("application/gzip"));
        __dftMimeMap.put("hdf", MimeTypes.normalizeMimeType("application/x-hdf"));
        __dftMimeMap.put("hqx", MimeTypes.normalizeMimeType("application/mac-binhex40"));
        __dftMimeMap.put("html", MimeTypes.normalizeMimeType(TEXT_HTML));
        __dftMimeMap.put("htm", MimeTypes.normalizeMimeType(TEXT_HTML));
        __dftMimeMap.put("ice", MimeTypes.normalizeMimeType("x-conference/x-cooltalk"));
        __dftMimeMap.put("ico", MimeTypes.normalizeMimeType("image/x-icon"));
        __dftMimeMap.put("ief", MimeTypes.normalizeMimeType("image/ief"));
        __dftMimeMap.put("iges", MimeTypes.normalizeMimeType("model/iges"));
        __dftMimeMap.put("igs", MimeTypes.normalizeMimeType("model/iges"));
        __dftMimeMap.put("jar", MimeTypes.normalizeMimeType("application/java-archive"));
        __dftMimeMap.put("java", MimeTypes.normalizeMimeType(TEXT_PLAIN));
        __dftMimeMap.put("jnlp", MimeTypes.normalizeMimeType("application/x-java-jnlp-file"));
        __dftMimeMap.put("jpeg", MimeTypes.normalizeMimeType("image/jpeg"));
        __dftMimeMap.put("jpe", MimeTypes.normalizeMimeType("image/jpeg"));
        __dftMimeMap.put("jpg", MimeTypes.normalizeMimeType("image/jpeg"));
        __dftMimeMap.put("js", MimeTypes.normalizeMimeType("application/x-javascript"));
        __dftMimeMap.put("jsp", MimeTypes.normalizeMimeType(TEXT_PLAIN));
        __dftMimeMap.put("kar", MimeTypes.normalizeMimeType("audio/midi"));
        __dftMimeMap.put("latex", MimeTypes.normalizeMimeType("application/x-latex"));
        __dftMimeMap.put("lha", MimeTypes.normalizeMimeType("application/octet-stream"));
        __dftMimeMap.put("lzh", MimeTypes.normalizeMimeType("application/octet-stream"));
        __dftMimeMap.put("man", MimeTypes.normalizeMimeType("application/x-troff-man"));
        __dftMimeMap.put("mathml", MimeTypes.normalizeMimeType("application/mathml+xml"));
        __dftMimeMap.put("me", MimeTypes.normalizeMimeType("application/x-troff-me"));
        __dftMimeMap.put("mesh", MimeTypes.normalizeMimeType("model/mesh"));
        __dftMimeMap.put("mid", MimeTypes.normalizeMimeType("audio/midi"));
        __dftMimeMap.put("midi", MimeTypes.normalizeMimeType("audio/midi"));
        __dftMimeMap.put("mif", MimeTypes.normalizeMimeType("application/vnd.mif"));
        __dftMimeMap.put("mol", MimeTypes.normalizeMimeType("chemical/x-mdl-molfile"));
        __dftMimeMap.put("movie", MimeTypes.normalizeMimeType("video/x-sgi-movie"));
        __dftMimeMap.put("mov", MimeTypes.normalizeMimeType("video/quicktime"));
        __dftMimeMap.put("mp2", MimeTypes.normalizeMimeType("audio/mpeg"));
        __dftMimeMap.put("mp3", MimeTypes.normalizeMimeType("audio/mpeg"));
        __dftMimeMap.put("mpeg", MimeTypes.normalizeMimeType("video/mpeg"));
        __dftMimeMap.put("mpe", MimeTypes.normalizeMimeType("video/mpeg"));
        __dftMimeMap.put("mpga", MimeTypes.normalizeMimeType("audio/mpeg"));
        __dftMimeMap.put("mpg", MimeTypes.normalizeMimeType("video/mpeg"));
        __dftMimeMap.put("ms", MimeTypes.normalizeMimeType("application/x-troff-ms"));
        __dftMimeMap.put("msh", MimeTypes.normalizeMimeType("model/mesh"));
        __dftMimeMap.put("msi", MimeTypes.normalizeMimeType("application/octet-stream"));
        __dftMimeMap.put("nc", MimeTypes.normalizeMimeType("application/x-netcdf"));
        __dftMimeMap.put("oda", MimeTypes.normalizeMimeType("application/oda"));
        __dftMimeMap.put("ogg", MimeTypes.normalizeMimeType("application/ogg"));
        __dftMimeMap.put("pbm", MimeTypes.normalizeMimeType("image/x-portable-bitmap"));
        __dftMimeMap.put("pdb", MimeTypes.normalizeMimeType("chemical/x-pdb"));
        __dftMimeMap.put("pdf", MimeTypes.normalizeMimeType("application/pdf"));
        __dftMimeMap.put("pgm", MimeTypes.normalizeMimeType("image/x-portable-graymap"));
        __dftMimeMap.put("pgn", MimeTypes.normalizeMimeType("application/x-chess-pgn"));
        __dftMimeMap.put("png", MimeTypes.normalizeMimeType("image/png"));
        __dftMimeMap.put("pnm", MimeTypes.normalizeMimeType("image/x-portable-anymap"));
        __dftMimeMap.put("ppm", MimeTypes.normalizeMimeType("image/x-portable-pixmap"));
        __dftMimeMap.put("ppt", MimeTypes.normalizeMimeType("application/vnd.ms-powerpoint"));
        __dftMimeMap.put("ps", MimeTypes.normalizeMimeType("application/postscript"));
        __dftMimeMap.put("qt", MimeTypes.normalizeMimeType("video/quicktime"));
        __dftMimeMap.put("ra", MimeTypes.normalizeMimeType("audio/x-pn-realaudio"));
        __dftMimeMap.put("ra", MimeTypes.normalizeMimeType("audio/x-realaudio"));
        __dftMimeMap.put("ram", MimeTypes.normalizeMimeType("audio/x-pn-realaudio"));
        __dftMimeMap.put("ras", MimeTypes.normalizeMimeType("image/x-cmu-raster"));
        __dftMimeMap.put("rdf", MimeTypes.normalizeMimeType("application/rdf+xml"));
        __dftMimeMap.put("rgb", MimeTypes.normalizeMimeType("image/x-rgb"));
        __dftMimeMap.put("rm", MimeTypes.normalizeMimeType("audio/x-pn-realaudio"));
        __dftMimeMap.put("roff", MimeTypes.normalizeMimeType("application/x-troff"));
        __dftMimeMap.put("rpm", MimeTypes.normalizeMimeType("application/x-rpm"));
        __dftMimeMap.put("rpm", MimeTypes.normalizeMimeType("audio/x-pn-realaudio"));
        __dftMimeMap.put("rtf", MimeTypes.normalizeMimeType("application/rtf"));
        __dftMimeMap.put("rtx", MimeTypes.normalizeMimeType("text/richtext"));
        __dftMimeMap.put("ser", MimeTypes.normalizeMimeType("application/java-serialized-object"));
        __dftMimeMap.put("sgml", MimeTypes.normalizeMimeType("text/sgml"));
        __dftMimeMap.put("sgm", MimeTypes.normalizeMimeType("text/sgml"));
        __dftMimeMap.put("sh", MimeTypes.normalizeMimeType("application/x-sh"));
        __dftMimeMap.put("shar", MimeTypes.normalizeMimeType("application/x-shar"));
        __dftMimeMap.put("silo", MimeTypes.normalizeMimeType("model/mesh"));
        __dftMimeMap.put("sit", MimeTypes.normalizeMimeType("application/x-stuffit"));
        __dftMimeMap.put("skd", MimeTypes.normalizeMimeType("application/x-koan"));
        __dftMimeMap.put("skm", MimeTypes.normalizeMimeType("application/x-koan"));
        __dftMimeMap.put("skp", MimeTypes.normalizeMimeType("application/x-koan"));
        __dftMimeMap.put("skt", MimeTypes.normalizeMimeType("application/x-koan"));
        __dftMimeMap.put("smi", MimeTypes.normalizeMimeType("application/smil"));
        __dftMimeMap.put("smil", MimeTypes.normalizeMimeType("application/smil"));
        __dftMimeMap.put("snd", MimeTypes.normalizeMimeType("audio/basic"));
        __dftMimeMap.put("spl", MimeTypes.normalizeMimeType("application/x-futuresplash"));
        __dftMimeMap.put("src", MimeTypes.normalizeMimeType("application/x-wais-source"));
        __dftMimeMap.put("sv4cpio", MimeTypes.normalizeMimeType("application/x-sv4cpio"));
        __dftMimeMap.put("sv4crc", MimeTypes.normalizeMimeType("application/x-sv4crc"));
        __dftMimeMap.put("svg", MimeTypes.normalizeMimeType("image/svg+xml"));
        __dftMimeMap.put("swf", MimeTypes.normalizeMimeType("application/x-shockwave-flash"));
        __dftMimeMap.put("t", MimeTypes.normalizeMimeType("application/x-troff"));
        __dftMimeMap.put("tar", MimeTypes.normalizeMimeType("application/x-tar"));
        __dftMimeMap.put("tar.gz", MimeTypes.normalizeMimeType("application/x-gtar"));
        __dftMimeMap.put("tcl", MimeTypes.normalizeMimeType("application/x-tcl"));
        __dftMimeMap.put("tex", MimeTypes.normalizeMimeType("application/x-tex"));
        __dftMimeMap.put("texi", MimeTypes.normalizeMimeType("application/x-texinfo"));
        __dftMimeMap.put("texinfo", MimeTypes.normalizeMimeType("application/x-texinfo"));
        __dftMimeMap.put("tgz", MimeTypes.normalizeMimeType("application/x-gtar"));
        __dftMimeMap.put("tiff", MimeTypes.normalizeMimeType("image/tiff"));
        __dftMimeMap.put("tif", MimeTypes.normalizeMimeType("image/tiff"));
        __dftMimeMap.put("tr", MimeTypes.normalizeMimeType("application/x-troff"));
        __dftMimeMap.put("tsv", MimeTypes.normalizeMimeType("text/tab-separated-values"));
        __dftMimeMap.put("txt", MimeTypes.normalizeMimeType(TEXT_PLAIN));
        __dftMimeMap.put("ustar", MimeTypes.normalizeMimeType("application/x-ustar"));
        __dftMimeMap.put("vcd", MimeTypes.normalizeMimeType("application/x-cdlink"));
        __dftMimeMap.put("vrml", MimeTypes.normalizeMimeType("model/vrml"));
        __dftMimeMap.put("vxml", MimeTypes.normalizeMimeType("application/voicexml+xml"));
        __dftMimeMap.put("wav", MimeTypes.normalizeMimeType("audio/x-wav"));
        __dftMimeMap.put("wbmp", MimeTypes.normalizeMimeType("image/vnd.wap.wbmp"));
        __dftMimeMap.put("wmlc", MimeTypes.normalizeMimeType("application/vnd.wap.wmlc"));
        __dftMimeMap.put("wmlsc", MimeTypes.normalizeMimeType("application/vnd.wap.wmlscriptc"));
        __dftMimeMap.put("wmls", MimeTypes.normalizeMimeType("text/vnd.wap.wmlscript"));
        __dftMimeMap.put("wml", MimeTypes.normalizeMimeType("text/vnd.wap.wml"));
        __dftMimeMap.put("wrl", MimeTypes.normalizeMimeType("model/vrml"));
        __dftMimeMap.put("wtls-ca-certificate", MimeTypes.normalizeMimeType("application/vnd.wap.wtls-ca-certificate"));
        __dftMimeMap.put("xbm", MimeTypes.normalizeMimeType("image/x-xbitmap"));
        __dftMimeMap.put("xht", MimeTypes.normalizeMimeType("application/xhtml+xml"));
        __dftMimeMap.put("xhtml", MimeTypes.normalizeMimeType("application/xhtml+xml"));
        __dftMimeMap.put("xls", MimeTypes.normalizeMimeType("application/vnd.ms-excel"));
        __dftMimeMap.put("xml", MimeTypes.normalizeMimeType("application/xml"));
        __dftMimeMap.put("xpm", MimeTypes.normalizeMimeType("image/x-xpixmap"));
        __dftMimeMap.put("xpm", MimeTypes.normalizeMimeType("image/x-xpixmap"));
        __dftMimeMap.put("xsl", MimeTypes.normalizeMimeType("application/xml"));
        __dftMimeMap.put("xslt", MimeTypes.normalizeMimeType("application/xslt+xml"));
        __dftMimeMap.put("xul", MimeTypes.normalizeMimeType("application/vnd.mozilla.xul+xml"));
        __dftMimeMap.put("xwd", MimeTypes.normalizeMimeType("image/x-xwindowdump"));
        __dftMimeMap.put("xyz", MimeTypes.normalizeMimeType("chemical/x-xyz"));
        __dftMimeMap.put("z", MimeTypes.normalizeMimeType("application/compress"));
        __dftMimeMap.put("zip", MimeTypes.normalizeMimeType("application/zip"));
    }

    private static void uglyEncodingLoading() {
        __encodings.put(TEXT_HTML, "ISO-8859-1");
        __encodings.put(TEXT_PLAIN, "US-ASCII");
        __encodings.put(TEXT_XML, "UTF-8");
    }
}

