/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import com.sun.javacard.Logger;
import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HandlerWrapper
extends AbstractHandlerContainer {
    private Handler handler;

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        try {
            Handler old_handler = this.handler;
            if (handler != null && this.isStarted() && !handler.isStarted()) {
                handler.start();
            }
            this.handler = handler;
            if (old_handler != null && old_handler.isStarted()) {
                old_handler.stop();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            throw ise;
        }
    }

    @Override
    public void addHandler(Handler handler) {
        Handler old = this.getHandler();
        if (old != null && !(handler instanceof HandlerContainer)) {
            throw new IllegalArgumentException("Cannot add");
        }
        this.setHandler(handler);
        if (old != null) {
            ((HandlerContainer)((Object)handler)).addHandler(old);
        }
    }

    @Override
    protected void doStart() throws Exception {
        Logger.debug("org.mortbay.jetty.handler.HandlerWrapper.doStart() -> ");
        if (this.handler != null) {
            Logger.debug("org.mortbay.jetty.handler.HandlerWrapper.doStart() -> Starting the _handler " + this.handler);
            this.handler.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.handler != null) {
            this.handler.stop();
        }
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this.handler != null && this.isStarted()) {
            this.handler.handle(target, request, response, dispatch);
        }
    }

    @Override
    protected LazyList<Handler> expandChildren(LazyList<Handler> list, Class<?> byClass) {
        return this.expandHandler(this.handler, list, byClass);
    }
}

