/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class MovedContextHandler
extends ContextHandler {
    String newContextURL;
    boolean discardPathInfo;
    boolean discardQuery;
    boolean permanent;
    Redirector redirector;

    public MovedContextHandler() {
        this.redirector = new Redirector();
        this.addHandler(this.redirector);
    }

    public MovedContextHandler(HandlerContainer parent, String contextPath, String newContextURL) {
        super(parent, contextPath);
        this.newContextURL = newContextURL;
        this.redirector = new Redirector();
        this.addHandler(this.redirector);
    }

    public boolean isDiscardPathInfo() {
        return this.discardPathInfo;
    }

    public void setDiscardPathInfo(boolean discardPathInfo) {
        this.discardPathInfo = discardPathInfo;
    }

    public String getNewContextURL() {
        return this.newContextURL;
    }

    public void setNewContextURL(String newContextURL) {
        this.newContextURL = newContextURL;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public boolean isDiscardQuery() {
        return this.discardQuery;
    }

    public void setDiscardQuery(boolean discardQuery) {
        this.discardQuery = discardQuery;
    }

    class Redirector
    extends AbstractHandler {
        Redirector() {
        }

        @Override
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
            if (MovedContextHandler.this.newContextURL == null) {
                return;
            }
            Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            String url = MovedContextHandler.this.newContextURL;
            if (!MovedContextHandler.this.discardPathInfo && request.getPathInfo() != null) {
                url = URIUtil.addPaths(url, request.getPathInfo());
            }
            if (!MovedContextHandler.this.discardQuery && request.getQueryString() != null) {
                url = url + "?" + request.getQueryString();
            }
            response.sendRedirect(url);
            if (MovedContextHandler.this.permanent) {
                response.setStatus(301);
            }
            base_request.setHandled(true);
        }
    }
}

