/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import com.sun.javacard.Logger;
import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.HandlerWrapper;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class RequestLogHandler
extends HandlerWrapper {
    private RequestLog requestLog;

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        super.handle(target, request, response, dispatch);
        if (dispatch == 1 && this.requestLog != null) {
            this.requestLog.log((Request)request, (Response)response);
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        try {
            if (this.requestLog != null) {
                this.requestLog.stop();
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        this.requestLog = requestLog;
        try {
            if (this.isStarted() && this.requestLog != null) {
                this.requestLog.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public RequestLog getRequestLog() {
        return this.requestLog;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.requestLog != null) {
            this.requestLog.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }
}

