/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.HandlerWrapper;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class StatisticsHandler
extends HandlerWrapper {
    transient long statsStartedAt;
    transient int requests;
    transient long requestsDurationMin;
    transient long requestsDurationMax;
    transient long requestsDurationTotal;
    transient int requestsActive;
    transient int requestsActiveMin;
    transient int requestsActiveMax;
    transient int responses1xx;
    transient int responses2xx;
    transient int responses3xx;
    transient int responses4xx;
    transient int responses5xx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statsReset() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            if (this.isStarted()) {
                this.statsStartedAt = System.currentTimeMillis();
            }
            this.requests = 0;
            this.requestsActiveMax = this.requestsActive;
            this.responses1xx = 0;
            this.responses2xx = 0;
            this.responses3xx = 0;
            this.responses4xx = 0;
            this.responses5xx = 0;
            this.requestsActiveMin = this.requestsActive;
            this.requestsActiveMax = this.requestsActive;
            this.requestsActive = 0;
            this.requestsDurationMin = 0L;
            this.requestsDurationMax = 0L;
            this.requestsDurationTotal = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        StatisticsHandler statisticsHandler;
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Response base_response = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
        try {
            statisticsHandler = this;
            synchronized (statisticsHandler) {
                ++this.requests;
                ++this.requestsActive;
                if (this.requestsActive > this.requestsActiveMax) {
                    this.requestsActiveMax = this.requestsActive;
                }
            }
            super.handle(target, request, response, dispatch);
        }
        finally {
            statisticsHandler = this;
            synchronized (statisticsHandler) {
                --this.requestsActive;
                if (this.requestsActive < 0) {
                    this.requestsActive = 0;
                }
                if (this.requestsActive < this.requestsActiveMin) {
                    this.requestsActiveMin = this.requestsActive;
                }
                long duration = System.currentTimeMillis() - base_request.getTimeStamp();
                this.requestsDurationTotal += duration;
                if (this.requestsDurationMin == 0L || duration < this.requestsDurationMin) {
                    this.requestsDurationMin = duration;
                }
                if (duration > this.requestsDurationMax) {
                    this.requestsDurationMax = duration;
                }
                switch (base_response.getStatus() / 100) {
                    case 1: {
                        ++this.responses1xx;
                        break;
                    }
                    case 2: {
                        ++this.responses2xx;
                        break;
                    }
                    case 3: {
                        ++this.responses3xx;
                        break;
                    }
                    case 4: {
                        ++this.responses4xx;
                        break;
                    }
                    case 5: {
                        ++this.responses5xx;
                    }
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.statsStartedAt = System.currentTimeMillis();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    public int getRequests() {
        return this.requests;
    }

    public int getRequestsActive() {
        return this.requestsActive;
    }

    public int getRequestsActiveMax() {
        return this.requestsActiveMax;
    }

    public int getResponses1xx() {
        return this.responses1xx;
    }

    public int getResponses2xx() {
        return this.responses2xx;
    }

    public int getResponses3xx() {
        return this.responses3xx;
    }

    public int getResponses4xx() {
        return this.responses4xx;
    }

    public int getResponses5xx() {
        return this.responses5xx;
    }

    public long getStatsOnMs() {
        return System.currentTimeMillis() - this.statsStartedAt;
    }

    public int getRequestsActiveMin() {
        return this.requestsActiveMin;
    }

    public long getRequestsDurationMin() {
        return this.requestsDurationMin;
    }

    public long getRequestsDurationTotal() {
        return this.requestsDurationTotal;
    }

    public long getRequestsDurationAve() {
        return this.requests == 0 ? 0L : this.requestsDurationTotal / (long)this.requests;
    }

    public long getRequestsDurationMax() {
        return this.requestsDurationMax;
    }
}

