/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.resource.FileResource;
import org.mortbay.resource.InputStreamResource;
import org.mortbay.util.IO;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class Resource {
    public static boolean defaultUseCaches = true;
    Object associate;

    public static void setDefaultUseCaches(boolean useCaches) {
        defaultUseCaches = useCaches;
    }

    public static boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public static Resource newResource(String resource) throws IOException {
        return Resource.newResource(resource, defaultUseCaches);
    }

    public static Resource newResource(InputStream resource) {
        return new InputStreamResource(resource);
    }

    public static Resource newResource(String resource, boolean useCaches) throws IOException {
        if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
            try {
                if (resource.startsWith("./")) {
                    resource = resource.substring(2);
                }
                FileConnection file = new FileConnection(resource).getCanonicalFile();
                Logger.debug("org.mortbay.resource.Resource.newResource() ->Creating file resource from canonical file" + file);
                Logger.debug("org.mortbay.resource.Resource.newResource() ->ABSOLUTEPATH = " + file.getAbsolutePath());
                FileResource fileResource = new FileResource(file.getAbsolutePath(), file);
                Logger.debug("got fileResource");
                return fileResource;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage() + "  newResource() failed");
            }
        }
        Logger.debug("Bad Resource: " + resource);
        throw new IOException("Bad Resource: " + resource);
    }

    public static Resource newSystemResource(String resource) {
        InputStream inputStream = null;
        ClassLoader loader = ClassLoader.getCurrentClassLoader();
        if (loader != null && (inputStream = loader.getResourceAsStream(resource)) == null && resource.startsWith("/")) {
            inputStream = loader.getResourceAsStream(resource.substring(1));
        }
        if (inputStream == null && loader != null && (inputStream = loader.getResourceAsStream(resource)) == null && resource.startsWith("/")) {
            inputStream = loader.getResourceAsStream(resource.substring(1));
        }
        if (inputStream == null) {
            return null;
        }
        return Resource.newResource(inputStream);
    }

    public abstract void release();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    public abstract String getURL();

    public abstract FileConnection getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException, SecurityException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException;

    public String encode(String uri) {
        return URIUtil.encodePath(uri);
    }

    public Object getAssociate() {
        return this.associate;
    }

    public void setAssociate(Object o) {
        this.associate = o;
    }

    public String getAlias() {
        return null;
    }

    public String getListHTML(String base, boolean parent) throws IOException {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ls = this.list();
        if (ls == null) {
            return null;
        }
        String title = "Directory: " + base;
        StringBuffer buf = new StringBuffer(4096);
        buf.append("<HTML><HEAD><TITLE>");
        buf.append(title);
        buf.append("</TITLE></HEAD><BODY>\n<H1>");
        buf.append(title);
        buf.append("</H1><TABLE BORDER=0>");
        if (parent) {
            buf.append("<TR><TD><A HREF=");
            buf.append(URIUtil.encodePath(URIUtil.addPaths(base, "../")));
            buf.append(">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        for (String element : ls) {
            String encoded = URIUtil.encodePath(element);
            Resource item = this.addPath(encoded);
            buf.append("<TR><TD><A HREF=\"");
            String path = URIUtil.addPaths(base, encoded);
            if (item.isDirectory() && !path.endsWith("/")) {
                path = URIUtil.addPaths(path, "/");
            }
            buf.append(path);
            buf.append("\">");
            buf.append(StringUtil.replace(StringUtil.replace(element, "<", "&lt;"), ">", "&gt;"));
            buf.append("&nbsp;");
            buf.append("</TD><TD ALIGN=right>");
            buf.append(item.length());
            buf.append(" bytes&nbsp;</TD><TD>");
            buf.append(new Date(item.lastModified()));
            buf.append("</TD></TR>\n");
        }
        buf.append("</TABLE>\n");
        buf.append("</BODY></HTML>\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, long start, long count) throws IOException {
        InputStream in = this.getInputStream();
        try {
            in.skip(start);
            if (count < 0L) {
                IO.copy(in, out);
            } else {
                IO.copy(in, out, (long)((int)count));
            }
        }
        finally {
            in.close();
        }
    }
}

