/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import com.sun.javacard.impl.PrivAccess;
import javacard.framework.APDU;
import javacard.framework.Util;
import javacard.framework.service.Service;
import javacard.framework.service.ServiceException;

public class BasicService
implements Service {
    private static final byte INS_SELECT = -92;
    private static final byte APDU_CMD_MASK = -4;

    private boolean isInputState(APDU apdu) {
        byte state = apdu.getCurrentState();
        return state >= 0 && state <= 2;
    }

    private boolean isOutputState(APDU apdu) {
        byte state = apdu.getCurrentState();
        return state >= 3 && state <= 6;
    }

    private boolean isErrorState(APDU apdu) {
        byte state = apdu.getCurrentState();
        return state < 0;
    }

    public boolean processDataIn(APDU apdu) {
        return false;
    }

    public boolean processCommand(APDU apdu) {
        return false;
    }

    public boolean processDataOut(APDU apdu) {
        return false;
    }

    public short receiveInData(APDU apdu) throws ServiceException {
        byte[] buffer;
        if (!this.isInputState(apdu) || apdu.getCurrentState() == 1) {
            ServiceException.throwIt((short)4);
        }
        if ((short)(0xFF & (buffer = apdu.getBuffer())[4]) > (short)(buffer.length - 5 & 0xFF)) {
            ServiceException.throwIt((short)3);
        }
        if (apdu.getCurrentState() == 0) {
            short s = apdu.setIncomingAndReceive();
        }
        return apdu.getBuffer()[4];
    }

    public void setProcessed(APDU apdu) throws ServiceException {
        if (this.isErrorState(apdu)) {
            ServiceException.throwIt((short)5);
        }
        if (apdu.getCurrentState() < 3) {
            apdu.setOutgoing();
        }
    }

    public boolean isProcessed(APDU apdu) {
        if (this.isErrorState(apdu)) {
            return true;
        }
        return apdu.getCurrentState() >= 3;
    }

    public void setOutputLength(APDU apdu, short length) throws ServiceException {
        if (length < 0 || length > (short)(apdu.getBuffer().length - 5)) {
            ServiceException.throwIt((short)1);
        }
        apdu.getBuffer()[4] = (byte)length;
    }

    public short getOutputLength(APDU apdu) throws ServiceException {
        if (!this.isOutputState(apdu)) {
            ServiceException.throwIt((short)5);
        }
        return (short)(apdu.getBuffer()[4] & 0xFF);
    }

    public void setStatusWord(APDU apdu, short sw) {
        Util.setShort(apdu.getBuffer(), (short)2, sw);
    }

    public short getStatusWord(APDU apdu) throws ServiceException {
        if (!this.isOutputState(apdu)) {
            ServiceException.throwIt((short)5);
        }
        return Util.getShort(apdu.getBuffer(), (short)2);
    }

    public boolean fail(APDU apdu, short sw) throws ServiceException {
        this.setProcessed(apdu);
        apdu.getBuffer()[4] = 0;
        Util.setShort(apdu.getBuffer(), (short)2, sw);
        return true;
    }

    public boolean succeed(APDU apdu) throws ServiceException {
        this.setProcessed(apdu);
        Util.setShort(apdu.getBuffer(), (short)2, (short)-28672);
        return true;
    }

    public boolean succeedWithStatusWord(APDU apdu, short sw) throws ServiceException {
        this.setProcessed(apdu);
        Util.setShort(apdu.getBuffer(), (short)2, sw);
        return true;
    }

    public byte getCLA(APDU apdu) {
        return apdu.getBuffer()[0];
    }

    public byte getINS(APDU apdu) {
        return apdu.getBuffer()[1];
    }

    public byte getP1(APDU apdu) throws ServiceException {
        if (!this.isInputState(apdu) || apdu.getCurrentState() == 1) {
            ServiceException.throwIt((short)4);
        }
        return apdu.getBuffer()[2];
    }

    public byte getP2(APDU apdu) throws ServiceException {
        if (!this.isInputState(apdu) || apdu.getCurrentState() == 1) {
            ServiceException.throwIt((short)4);
        }
        return apdu.getBuffer()[3];
    }

    public boolean selectingApplet() {
        return PrivAccess.getPrivAccess().selectingApplet();
    }
}

