/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.capdump;

import com.sun.javacard.ToolsVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class CapDump {
    protected static ResourceBundle _messages = ResourceBundle.getBundle("com/sun/javacard/capdump/MessagesBundle");
    static final String eol = System.getProperty("line.separator", "\n");
    static final int BYTES_PER_LINE = 16;

    public static void main(String[] args) {
        System.err.println(ToolsVersion.getToolName(7) + ToolsVersion.getVersion(7));
        System.err.println(ToolsVersion.getCopyrightBanner());
        if (args.length != 1) {
            System.err.println(_messages.getString("usage.1"));
            System.exit(1);
        }
        try {
            String zipFileName = new File(args[0]).getCanonicalPath();
            ZipFile zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                if (ze.getName().equals("META-INF/MANIFEST.MF")) continue;
                InputStream in = zipFile.getInputStream(ze);
                System.out.println(CapDump.zipEntryString(ze, in));
            }
            zipFile.close();
        }
        catch (ZipException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static String zipEntryString(ZipEntry ze, InputStream in) throws IOException {
        int length;
        StringBuffer sb = new StringBuffer();
        sb.append(ze.getName() + " :" + eol);
        byte[] buf = new byte[10240];
        int j = 0;
        while ((length = in.read(buf, 0, buf.length)) != -1) {
            for (int i = 0; i < length; ++i) {
                int data = buf[i] & 0xFF;
                if (data < 16) {
                    sb.append(" 0" + Integer.toHexString(data));
                } else {
                    sb.append(" " + Integer.toHexString(data));
                }
                if (++j % 16 != 0) continue;
                sb.append(eol);
            }
        }
        return sb.toString();
    }
}

