/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.jpcsclite.ConnectionType;
import com.sun.javacard.jpcsclite.PCSCLite;
import com.sun.javacard.jpcsclite.State;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ClientPCSCProtocol
extends ClientProtocol {
    protected ConnectionType ctx;
    protected static ResourceBundle _messages = ResourceBundle.getBundle("com/sun/javacard/apduio/MessagesBundle");

    public void setAuto61xx(boolean bl) {
    }

    public boolean getAuto61xx() {
        return true;
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException {
        byte[] byArray = apdu.getCommandApduBytes();
        byte[] byArray2 = this.ctx.getCard().Transmit(byArray, 0, byArray.length);
        if (byArray2.length < 2) {
            throw new IOException(_messages.getString("pcsc.8"));
        }
        apdu.setDataOut(byArray2, byArray2.length - 2);
        apdu.sw1sw2 = new byte[2];
        System.arraycopy(byArray2, byArray2.length - 2, apdu.sw1sw2, 0, 2);
    }

    public byte[] openCard(int n) throws Exception {
        try {
            Object[] objectArray;
            this.ctx = new ConnectionType();
            this.ctx.establishContext(PCSCLite.SCOPE_SYSTEM, null, null);
            String[] stringArray = this.ctx.getReaders();
            if (stringArray == null) {
                throw new RuntimeException(_messages.getString("pcsc.9"));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray = new Object[]{"" + i, stringArray[i]};
                System.out.println(MessageFormat.format(_messages.getString("pcsc.10"), objectArray));
            }
            if (stringArray.length == 0) {
                throw new Exception(_messages.getString("pcsc.7"));
            }
            if (stringArray.length > 1) {
                Object[] objectArray2 = new Object[]{stringArray[n]};
                System.out.println(MessageFormat.format(_messages.getString("pcsc.11"), objectArray2));
            }
            State[] stateArray = new State[]{new State(stringArray[n])};
            this.ctx.statusChange(1000, stateArray);
            if ((stateArray[0].getEventState() & PCSCLite.STATE_PRESENT) != PCSCLite.STATE_PRESENT) {
                throw new Exception(_messages.getString("pcsc.6"));
            }
            if ((stateArray[0].getEventState() & PCSCLite.STATE_MUTE) == PCSCLite.STATE_MUTE) {
                throw new Exception(_messages.getString("pcsc.5"));
            }
            objectArray = stateArray[0].getrgbAtr();
            this.ctx.connect(stringArray[n], PCSCLite.SHARE_SHARED, PCSCLite.PROTOCOL_T1 | PCSCLite.PROTOCOL_T0);
            State state = this.ctx.getCard().getStatus();
            return objectArray;
        }
        catch (Exception exception) {
            System.out.println(exception);
            throw exception;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            throw new Exception(_messages.getString("pcsc.4"));
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            throw new Exception(_messages.getString("pcsc.3"));
        }
    }

    public void closeCard() {
        if (this.ctx == null) {
            return;
        }
        try {
            this.ctx.getCard().Disconnect(PCSCLite.RESET_CARD);
            this.ctx.releaseContext();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

