/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void zip(File file, File file2, boolean bl) throws Exception {
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        String string = file.getAbsolutePath();
        if (!string.endsWith(File.pathSeparator)) {
            string = string + File.pathSeparator;
        }
        try {
            File[] fileArray;
            fileOutputStream = new FileOutputStream(file2);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (File file3 : fileArray = file.listFiles()) {
                ZipUtils.addToZipFile(file3, zipOutputStream, bl, string);
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void addToZipFile(File file, ZipOutputStream zipOutputStream, boolean bl, String string) throws Exception {
        if (!file.exists()) {
            return;
        }
        String string2 = file.getAbsolutePath();
        string2 = string2.substring(string.length());
        string2 = string2.replace('\\', '/');
        ZipEntry zipEntry = null;
        if (file.isDirectory()) {
            File[] fileArray;
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            for (File file2 : fileArray = file.listFiles()) {
                ZipUtils.addToZipFile(file2, zipOutputStream, bl, string);
            }
            return;
        }
        byte[] byArray = null;
        byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n = fileInputStream.read(byArray);
            if (n != byArray.length) {
                throw new Exception("Reading problem for file " + file);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        zipEntry = new ZipEntry(string2);
        if (bl) {
            zipEntry.setMethod(8);
        } else {
            zipEntry.setMethod(0);
            CRC32 cRC32 = new CRC32();
            cRC32.reset();
            cRC32.update(byArray, 0, byArray.length);
            zipEntry.setCrc(cRC32.getValue());
            zipEntry.setCompressedSize(byArray.length);
            zipEntry.setSize(byArray.length);
        }
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray);
        zipOutputStream.closeEntry();
    }

    public static void unzip(File file, File file2) throws Exception {
        if (!file.exists()) {
            throw new Exception("File " + file + "does not exists.");
        }
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        File file3 = null;
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            boolean bl = zipEntry.isDirectory();
            file3 = new File(file2, string);
            if (bl) {
                file3.mkdirs();
                continue;
            }
            if (!file3.getParentFile().exists()) {
                file3.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            int n = 0;
            byte[] byArray = new byte[1024];
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            while ((n = inputStream.read(byArray, 0, 1024)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
        zipFile.close();
    }

    public static void main(String[] stringArray) {
        try {
            ZipUtils.zip(new File("./TestApp/valid"), new File("./ankiCompress.zip"), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            ZipUtils.unzip(new File("./anki.zip"), new File("./ankiExplodeCompress"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

