/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.AppletInfo;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Enumeration;
import java.util.Vector;

class AppletComponent
extends Safeptr {
    private static TypeMethod installMethodType = new TypeMethod(Type.ByteArray, Type.Short, Type.Byte, Type.Void);

    AppletComponent(byte[] data) {
        super(data, "Applet");
    }

    AppletInfo appletInfo() {
        return new AppletInfo(this.offset(1));
    }

    int count() {
        return this.u1(0);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("AppletComponent.100");
        }
        Vector appletAids = new Vector();
        AppletInfo appl = this.appletInfo();
        int i = this.count();
        while (i > 0) {
            this.verifyApplet(appl, appletAids);
            appl = appl.next();
            --i;
        }
        if (!appl.atComponentEnd()) {
            throw new VerifierError("AppletComponent.1");
        }
    }

    private void verifyApplet(AppletInfo appl, Vector appletAids) {
        if (!AID.isValid(appl)) {
            throw new VerifierError("AppletComponent.3", appl.AID_length());
        }
        if (!AID.sameRID(appl, Cap.Header.thisPackage())) {
            throw new VerifierError("AppletComponent.4");
        }
        if (AID.same((AIDintf)appl, Cap.Header.thisPackage())) {
            throw new VerifierError("AppletComponent.6");
        }
        Enumeration e = appletAids.elements();
        while (e.hasMoreElements()) {
            AppletInfo a = (AppletInfo)e.nextElement();
            if (!AID.same((AIDintf)appl, a)) continue;
            throw new VerifierError("AppletComponent.7", AID.pretty(appl));
        }
        appletAids.add(appl);
        ClassAndMethodDescriptor cm = Methodref.checkInternalStaticRef(appl.installMethod());
        TypeMethod mty = TypeMethod.parseCap(Cap.TypeDescr.at(cm.methodDescr.type()));
        if (!mty.equals(installMethodType)) {
            throw new VerifierError("AppletComponent.2", mty);
        }
        if (!Classref.isSubclass(cm.classDescr.thisClass(), Classref.refForName("javacard/framework/Applet"))) {
            throw new VerifierError("AppletComponent.5");
        }
    }
}

