/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Iterator;
import java.util.TreeSet;

class StaticFieldComponent
extends Safeptr {
    private Safeptr endInitArray;
    private TreeSet allStaticFields;

    StaticFieldComponent(byte[] data) {
        super(data, "StaticField");
    }

    InitializedArray arrayInit() {
        return new InitializedArray(this.offset(6));
    }

    int arrayInitCount() {
        return this.u2(4);
    }

    int defaultValueCount() {
        return this.endInitArray.u2(0);
    }

    int imageSize() {
        return this.u2(0);
    }

    int nonDefaultValueCount() {
        return this.endInitArray.u2(2);
    }

    Safeptr nonDefaultValuesStaticfield() {
        return this.endInitArray.offset(4);
    }

    int referenceCount() {
        return this.u2(2);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("StaticFieldComponent.100");
        }
        this.allStaticFields = new TreeSet();
        InitializedArray ai = this.arrayInit();
        int i = this.arrayInitCount();
        while (i > 0) {
            ai.next();
            --i;
        }
        this.endInitArray = ai;
        if (this.arrayInitCount() > this.referenceCount()) {
            throw new VerifierError("StaticFieldComponent.1");
        }
        if (this.imageSize() != this.referenceCount() * 2 + this.defaultValueCount() + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.2");
        }
        ClassDescriptor cdesc = Cap.Descriptor.firstClassDescriptor();
        int i2 = Cap.Descriptor.classCount();
        while (i2 > 0) {
            if ((cdesc.flags() & 0x40) == 0) {
                int j = 0;
                while (j < cdesc.fieldCount()) {
                    FieldDescriptor fdesc = cdesc.fieldDescr(j);
                    this.verifyField(fdesc);
                    ++j;
                }
            }
            --i2;
            cdesc.next();
        }
        this.verifyOverlap();
        this.allStaticFields = null;
        if (this.size() != this.endInitArray.ofs + 4 + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.17");
        }
    }

    private void verifyField(FieldDescriptor f) {
        int sz;
        if ((f.flags() & 8) == 0) {
            return;
        }
        int ofs = f.staticRef();
        Type ty = Type.parseField(f.type());
        if (ofs < this.referenceCount() * 2) {
            sz = 2;
            if ((ofs & 1) != 0) {
                throw new VerifierError("StaticFieldComponent.3");
            }
            if (ofs < this.arrayInitCount()) {
                int szElt;
                Type initTy;
                InitializedArray init = this.arrayInit();
                int k = 0;
                while (k < ofs) {
                    init.next();
                    k += 2;
                }
                switch (init.type()) {
                    case 2: {
                        initTy = Type.BooleanArray;
                        szElt = 1;
                        break;
                    }
                    case 3: {
                        initTy = Type.ByteArray;
                        szElt = 1;
                        break;
                    }
                    case 4: {
                        initTy = Type.ShortArray;
                        szElt = 2;
                        break;
                    }
                    case 5: {
                        initTy = Type.IntArray;
                        szElt = 4;
                        break;
                    }
                    default: {
                        throw new VerifierError("StaticFieldComponent.4", init.type());
                    }
                }
                if (!ty.equals(initTy)) {
                    throw new VerifierError("StaticFieldComponent.5", (Object)ty, (Object)initTy);
                }
                if (init.count() % szElt != 0) {
                    throw new VerifierError("StaticFieldComponent.13", init.count(), szElt);
                }
                if (init.count() / szElt > Short.MAX_VALUE) {
                    throw new VerifierError("StaticFieldComponent.16", init.count() / szElt);
                }
                if (init.type() == 2) {
                    int i = 0;
                    while (i < init.count()) {
                        int data = init.values().u1(i);
                        if (data != 0 && data != 1) {
                            throw new VerifierError("StaticFieldComponent.14", data);
                        }
                        ++i;
                    }
                }
            } else if (!(ty instanceof TypeClass) && !(ty instanceof TypeArray)) {
                throw new VerifierError("StaticFieldComponent.6", (Object)ty, ofs);
            }
        } else {
            if (!(ty instanceof TypeBase)) {
                throw new VerifierError("StaticFieldComponent.7", (Object)ty, ofs);
            }
            switch (((TypeBase)ty).kind) {
                case 2: 
                case 3: {
                    sz = 1;
                    break;
                }
                case 4: {
                    sz = 2;
                    break;
                }
                case 5: {
                    sz = 4;
                    break;
                }
                default: {
                    throw new VerifierError("StaticFieldComponent.8", (Object)ty, ofs);
                }
            }
            if (((TypeBase)ty).kind == 2 && ofs >= this.imageSize() - this.nonDefaultValueCount()) {
                int ofsNonDefaultValue = ofs - (this.imageSize() - this.nonDefaultValueCount());
                int data = this.nonDefaultValuesStaticfield().u1(ofsNonDefaultValue);
                if (data != 0 && data != 1) {
                    throw new VerifierError("StaticFieldComponent.15", data);
                }
            }
        }
        this.allStaticFields.add(new OffsetAndLength(ofs, sz));
    }

    private void verifyOverlap() {
        int ofs = 0;
        Iterator fields = this.allStaticFields.iterator();
        while (fields.hasNext()) {
            OffsetAndLength ol = (OffsetAndLength)fields.next();
            if (ol.offset < ofs) {
                throw new VerifierError("StaticFieldComponent.9", ofs);
            }
            if (ol.offset > ofs) {
                throw new VerifierError("StaticFieldComponent.10", ofs);
            }
            ofs += ol.length;
        }
        if (ofs > this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.11");
        }
        if (ofs < this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.12");
        }
    }
}

