/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfConstantInfo;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Integer;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Vector;

public class ExportFile {
    DataInputStream in;
    static final byte CONSTANT_PACKAGE = 13;
    static final byte CONSTANT_CLASS_REF = 7;
    static final byte CONSTANT_INTEGER = 3;
    static final byte CONSTANT_UTF8 = 1;
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_SHAREABLE = 2048;
    public static final short ACC_LIBRARY = 1;
    public String file;
    EfConstantInfo[] constantPool;
    int thisPackage;
    public EfClass[] classes;
    private Vector newClasses;
    private boolean sameVersion;
    static final int MAGIC_NUMBER = 16435934;
    static final int MAJOR_VERSION = 2;
    static final int MINOR_VERSION = 1;

    void checkClassrefIndex(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_ClassRef)) {
            throw new VerifierError("ExportFile.4", index);
        }
    }

    public void checkEquality(ExportFile ef) {
        this.sameVersion = true;
        this.thisPackage().checkEquality(ef.thisPackage());
        this.compareClasses(ef);
    }

    void checkIntegerIndex(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_Integer)) {
            throw new VerifierError("ExportFile.5", index);
        }
    }

    void checkPackageIndex(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_Package)) {
            throw new VerifierError("ExportFile.3", index);
        }
    }

    void checkUtf8Index(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_Utf8)) {
            throw new VerifierError("ExportFile.6", index);
        }
    }

    private void compareClasses(ExportFile ef) {
        boolean found = false;
        int oldSize = this.classes.length;
        int newSize = ef.classes.length;
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.2");
        }
        int i = 0;
        while (i < oldSize) {
            found = false;
            EfClass oldClass = this.classes[i];
            String className1 = oldClass.thisName();
            int j = 0;
            while (j < newSize) {
                EfClass newClass = ef.classes[j];
                String className2 = newClass.thisName();
                if (className2.equals(className1)) {
                    found = true;
                    if (this.sameVersion) {
                        oldClass.checkEquality(newClass);
                        break;
                    }
                    oldClass.compareTo(newClass);
                    break;
                }
                ++j;
            }
            if (!found) {
                throw new VerifierError("RevisionError.3", className1);
            }
            ++i;
        }
    }

    public void compareTo(ExportFile ef) {
        this.sameVersion = false;
        this.thisPackage().compareTo(ef.thisPackage());
        this.compareClasses(ef);
    }

    void read() throws IOException {
        int magic = this.in.readInt();
        if (magic != 16435934) {
            throw new VerifierError("ExportFile.2");
        }
        int minorVersion = this.in.readUnsignedByte();
        int majorVersion = this.in.readUnsignedByte();
        if (majorVersion != 2 || minorVersion != 1) {
            throw new VerifierError("ExportFile.7", majorVersion, minorVersion);
        }
        int constantPoolCount = this.in.readUnsignedShort();
        this.constantPool = new EfConstantInfo[constantPoolCount];
        int i = 0;
        while (i < constantPoolCount) {
            EfConstantInfo ci;
            int tag = this.in.readUnsignedByte();
            switch (tag) {
                case 3: {
                    ci = new EfConstant_Integer(this);
                    break;
                }
                case 1: {
                    ci = new EfConstant_Utf8(this);
                    break;
                }
                case 7: {
                    ci = new EfConstant_ClassRef(this);
                    break;
                }
                case 13: {
                    ci = new EfConstant_Package(this);
                    break;
                }
                default: {
                    throw new VerifierError("ExportFile.8", tag);
                }
            }
            ci.read();
            this.constantPool[i] = ci;
            ++i;
        }
        int i2 = 0;
        while (i2 < constantPoolCount) {
            this.constantPool[i2].validate();
            ++i2;
        }
        this.thisPackage = this.in.readUnsignedShort();
        this.checkPackageIndex(this.thisPackage);
        int exportClassCount = this.in.readUnsignedByte();
        this.classes = new EfClass[exportClassCount];
        int i3 = 0;
        while (i3 < exportClassCount) {
            EfClass cl = new EfClass(this);
            cl.read();
            this.classes[i3] = cl;
            ++i3;
        }
    }

    public static ExportFile readFromFile(File filename) {
        try {
            FileInputStream fs = new FileInputStream(filename);
            ExportFile ef = new ExportFile();
            ef.file = filename.toString();
            ef.in = new DataInputStream(new BufferedInputStream(fs));
            ef.read();
            fs.close();
            return ef;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new VerifierError("ExportFile.50", filename.toString());
        }
        catch (IOException iOException) {
            throw new VerifierError("ExportFile.51", filename.toString());
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportFile.52", (Object)filename.toString(), (Object)e.getMessage());
        }
    }

    public String thisName() {
        EfConstant_Package thisPkg = this.thisPackage();
        return ((EfConstant_Utf8)this.constantPool[thisPkg.nameIndex]).contents;
    }

    public EfConstant_Package thisPackage() {
        return (EfConstant_Package)this.constantPool[this.thisPackage];
    }

    public void verify() {
        try {
            BitSet classTokens = new BitSet();
            HashSet classNames = new HashSet();
            int i = 0;
            while (i < this.classes.length) {
                this.classes[i].verify(classNames, classTokens);
                ++i;
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportFile.52", (Object)this.file, (Object)e.getMessage());
        }
    }
}

