/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import java.rmi.Remote;
import javacard.framework.SystemException;

public class CardRemoteObject
implements Remote {
    private static final short MAX_OBJECTS = 16;
    private static short[] array;

    public CardRemoteObject() {
        CardRemoteObject.export(this);
    }

    public static void export(Remote obj) throws SecurityException {
        if (array == null) {
            array = new short[16];
            NativeMethods.setJCREentry(array, false);
            GarbageCollector.setExpObjArray(array);
        }
        if (obj == null) {
            return;
        }
        short id = NativeMethods.getObjectID(obj);
        CardRemoteObject.export(id);
    }

    public static void unexport(Remote obj) throws SecurityException {
        if (obj == null) {
            return;
        }
        short objID = NativeMethods.getObjectID(obj);
        CardRemoteObject.unexport(objID);
    }

    private static void unexport(short objID) throws SecurityException {
        NativeMethods.checkAccess(objID);
        if (array == null) {
            return;
        }
        int i2 = 0;
        while (i2 < 16) {
            if (array[i2] == objID) {
                CardRemoteObject.array[i2] = 0;
            }
            i2 = (short)(i2 + 1);
        }
    }

    private static void export(short objID) throws SecurityException {
        NativeMethods.checkAccess(objID);
        int i2 = 0;
        while (i2 < 16) {
            if (array[i2] == 0) {
                CardRemoteObject.array[i2] = objID;
                return;
            }
            i2 = (short)(i2 + 1);
        }
        SystemException.throwIt((short)5);
    }

    static boolean isExported(Remote obj) throws SecurityException {
        if (obj == null) {
            return true;
        }
        short objID = NativeMethods.getObjectID(obj);
        return CardRemoteObject.isExported(objID);
    }

    private static boolean isExported(short objID) throws SecurityException {
        NativeMethods.checkAccess(objID);
        if (array == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < 16) {
            if (array[i2] == objID) {
                return true;
            }
            i2 = (short)(i2 + 1);
        }
        return false;
    }
}

