/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tee.tools.util;

import com.oracle.tee.tools.util.Flushable;
import java.io.Closeable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class Closables
implements Closeable {
    private final ArrayList<Closeable> list = new ArrayList();
    private boolean directOrder = false;

    public Closables() {
    }

    public void setDirectOrder(boolean order) {
        this.directOrder = order;
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(PrintWriter log) {
        ArrayList<Closeable> actions = new ArrayList<Closeable>();
        ArrayList<Closeable> arrayList = this.list;
        synchronized (arrayList) {
            actions.addAll(this.list);
            this.list.clear();
        }
        if (!this.directOrder) {
            Collections.reverse(actions);
        }
        for (Closeable action : actions) {
            try {
                action.close();
            }
            catch (Exception e) {
                if (log == null) continue;
                log.println("While closing Closables");
                e.printStackTrace(log);
            }
        }
    }

    public Closables(Closeable[] list) {
        this.list.addAll(Arrays.asList(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Closeable element) {
        ArrayList<Closeable> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<Closeable> actions = new ArrayList<Closeable>();
        ArrayList<Closeable> arrayList = this.list;
        synchronized (arrayList) {
            actions.addAll(this.list);
        }
        for (Closeable action : actions) {
            try {
                if (!(action instanceof Flushable)) continue;
                ((Flushable)action).close();
            }
            catch (Exception e) {}
        }
    }
}

