/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ChainPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ArrayReferenceConverters {
    public static final int MAX_GET_VALUES_PER_REQUEST = 49;
    public static final int MAX_SET_VALUES_PER_REQUEST = 61;

    private static int getElementSize(ClassicProxyProtocol proxy, int objectID) throws Exception {
        byte[] data = new byte[]{(byte)VMPacketHandler.CommandCode.GET_OBJECT_CLASS.getTag(), 2, (byte)(objectID >> 8), (byte)objectID};
        DataInputStream answer = proxy.sendToVmSync(data);
        byte typeTag = answer.readByte();
        switch (typeTag) {
            case -128: 
            case 96: {
                return 1;
            }
            case -96: {
                return 2;
            }
            case -64: 
            case -32: {
                return 4;
            }
        }
        throw new InvalidRequestException(20);
    }

    static void registerArrayReferenceConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(13, 1, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.GET_ARRAY_LENGTH){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                Log.LOGN(3, "ArrayReference: Length");
                int arrayID = handlerState.in.readInt();
                toVm.writeShort((short)arrayID);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState hState, DataInputStream fromVm, int length) throws Exception {
                hState.out.writeInt(fromVm.readShort());
            }
        });
        proxy.addConverter(13, 2, new ChainPacketHandler(VMPacketHandler.CommandCode.GET_ARRAY_VALUES, 49){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                Log.LOGN(3, "ArrayReference: GetValues");
                state.args.put("arrayID", state.in.readInt());
                state.args.put("firstIndex", state.in.readInt());
                int length = state.in.readInt();
                state.args.put("totalLength", length);
                return length;
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                int arrayID = (Integer)state.args.get("arrayID");
                int firstIndex = (Integer)state.args.get("firstIndex");
                toVm.writeShort((short)arrayID);
                toVm.writeShort((short)firstIndex);
                toVm.writeShort((short)chunkSize);
                state.args.put("firstIndex", firstIndex + chunkSize);
            }

            @Override
            protected void handleResponseChunk(boolean isHead, HandlerState state, int chunkSize, DataInputStream in, int length) throws Exception {
                byte jdwpTag = in.readByte();
                in.readInt();
                if (isHead) {
                    state.out.writeByte(jdwpTag);
                    state.out.writeInt((Integer)state.args.get("totalLength"));
                }
                EncodingUtils.copy(in, state.out, length - 5);
            }
        });
        proxy.addConverter(13, 3, new ChainPacketHandler(VMPacketHandler.CommandCode.SET_ARRAY_VALUES, 61){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                Log.LOGN(3, "ArrayReference: SetValues");
                int arrayID = state.in.readInt();
                state.args.put("arrayID", arrayID);
                state.args.put("firstIndex", state.in.readInt());
                int length = state.in.readInt();
                state.args.put("totalLength", length);
                state.args.put("elementSize", ArrayReferenceConverters.getElementSize(this.proxy, arrayID));
                return length;
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                int arrayID = (Integer)state.args.get("arrayID");
                int firstIndex = (Integer)state.args.get("firstIndex");
                int elementSize = (Integer)state.args.get("elementSize");
                toVm.writeShort((short)arrayID);
                toVm.writeShort((short)firstIndex);
                toVm.writeShort((short)chunkSize);
                EncodingUtils.copy(state.in, toVm, chunkSize * elementSize);
                state.args.put("firstIndex", firstIndex + chunkSize);
            }

            @Override
            protected void handleResponseChunk(boolean isHead, HandlerState state, int chunkSize, DataInputStream in, int length) throws Exception {
            }
        });
    }
}

