/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.basicstructure;

public class FieldDefinition {
    protected int access_flags;
    protected String descriptor;
    protected String field_name;
    protected int[] value;
    protected int token = 255;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;

    public FieldDefinition() {
    }

    public FieldDefinition(FieldDefinition a_field) {
        this.token = a_field.token;
        this.field_name = a_field.field_name;
        this.descriptor = a_field.descriptor;
        this.access_flags = a_field.access_flags;
        this.value = a_field.value;
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public String getFieldDescriptor() {
        return this.descriptor;
    }

    public String getFieldName() {
        return this.field_name;
    }

    public int getFieldToken() {
        return this.token;
    }

    public int[] getValue() {
        return this.value;
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) != 0;
    }

    public boolean isProtected() {
        return (this.getAccessFlags() & 4) != 0;
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) != 0;
    }

    public boolean isReferenceType() {
        return this.getFieldDescriptor().startsWith("[") || this.getFieldDescriptor().startsWith("L");
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    public void setAccessFlags(int access_flags) {
        this.access_flags = access_flags;
    }

    public void setFieldDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public void setFieldName(String field_name) {
        this.field_name = field_name;
    }

    public void setFieldToken(int token) {
        this.token = token;
    }

    public void setValue(int[] value) {
        this.value = value;
    }
}

