/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.LinkException;
import com.sun.javacard.converter.converters.BaseClassInterfaceConverter;
import com.sun.javacard.converter.converters.ClinitConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import com.sun.javacard.jcfile.JcPackage;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

public class ClassConverter
extends BaseClassInterfaceConverter {
    private static final int CLINIT_METHOD = 0;
    private static final int EXTERNAL_VIRTUAL_METHOD = 1;
    private static final int INTERNAL_VIRTUAL_METHOD = 2;
    private static final int EXTERNAL_STATIC_METHOD = 3;
    private static final int INTERNAL_STATIC_METHOD = 4;
    private static final int PRIVATE_METHOD = 5;
    private static final int EXTERNAL_PRIMITIVE_INSTANCE_FIELD = 0;
    private static final int EXTERNAL_REFERENCE_INSTANCE_FIELD = 1;
    private static final int INTERNAL_REFERENCE_INSTANCE_FIELD = 2;
    private static final int INTERNAL_PRIMITIVE_INSTANCE_FIELD = 3;
    private static final int EXTERNAL_STATIC_COMPILE_TIME_CONST_FIELD = 4;
    private static final int EXTERNAL_STATIC_NON_COMPILE_TIME_CONST_FIELD = 5;
    private static final int INTERNAL_STATIC_FIELD = 6;

    public ClassConverter(JClassFile java_class, PackageConverter p_converter) {
        super(java_class, p_converter);
    }

    private void assignFieldTokenAndComputeFieldData() {
        this.assignKnownFieldTokens();
        this.presortFieldsByTokens();
        int declared_instance_size = 0;
        int first_reference_token = 255;
        int reference_count = 0;
        int token = 0;
        int index = 0;
        JcField[] jc_fields = this.getJcClass().getFields();
        while (index < jc_fields.length) {
            if (jc_fields[index].isStatic()) break;
            String descriptor = jc_fields[index].getFieldDescriptor();
            if (DataType.getType(descriptor) == 10) {
                if (first_reference_token > token) {
                    first_reference_token = token;
                }
                ++reference_count;
            }
            jc_fields[index].setFieldToken(token);
            int size = this.getFieldSize(descriptor);
            declared_instance_size += size;
            token += size;
            ++index;
        }
        this.jc_class.setDeclaredInstanceSize(declared_instance_size);
        this.jc_class.setFirstReferenceToken(first_reference_token);
        this.jc_class.setReferenceCount(reference_count);
        token = 0;
        while (index < jc_fields.length) {
            int access_flags = jc_fields[index].getAccessFlags();
            if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                if (Modifier.isFinal(access_flags)) {
                    if (DataType.getType(jc_fields[index].getFieldDescriptor()) == 10) {
                        jc_fields[index].setFieldToken(token);
                        ++token;
                    }
                } else {
                    jc_fields[index].setFieldToken(token);
                    ++token;
                }
            }
            ++index;
        }
    }

    private void assignMethodTokens() throws Exception {
        MethodDefinition[] jc_methods = this.getJcClass().getMethods();
        Vector vector = this.findMethodsByType(jc_methods, 1);
        Object[] pub_virtual_methods = new JcMethod[vector.size()];
        vector.copyInto(pub_virtual_methods);
        MethodDefinition[] all_pub_virtual_methods = this.jc_class.getPublicMethodTable().getMethods();
        int i = 0;
        while (i < pub_virtual_methods.length) {
            Object jc_method = pub_virtual_methods[i];
            ((MethodDefinition)jc_method).setMethodToken(ClassConverter.getToken(all_pub_virtual_methods, (MethodDefinition)jc_method));
            ++i;
        }
        ClassConverter.sortMethodsByTokens(all_pub_virtual_methods);
        ClassConverter.assignNewMethodTokens(all_pub_virtual_methods);
        vector = this.findMethodsByType(jc_methods, 2);
        Object[] pac_virtual_methods = new JcMethod[vector.size()];
        vector.copyInto(pac_virtual_methods);
        MethodDefinition[] all_pac_virtual_methods = this.jc_class.getPackageMethodTable().getMethods();
        int i2 = 0;
        while (i2 < pac_virtual_methods.length) {
            Object jc_method = pac_virtual_methods[i2];
            ((MethodDefinition)jc_method).setMethodToken(ClassConverter.getToken(all_pac_virtual_methods, (MethodDefinition)jc_method) | 0x80);
            ++i2;
        }
        vector = this.findMethodsByType(jc_methods, 3);
        Object[] pub_static_methods = new JcMethod[vector.size()];
        vector.copyInto(pub_static_methods);
        if (this.isThisExpProvided()) {
            MethodDefinition[] methods_in_export_file = this.getMethodsFromExportClass(this.jc_class.getClassName(), 3);
            int i3 = 0;
            while (i3 < pub_static_methods.length) {
                Object jc_method = pub_static_methods[i3];
                ((MethodDefinition)jc_method).setMethodToken(ClassConverter.getToken(methods_in_export_file, (MethodDefinition)jc_method));
                ++i3;
            }
        } else {
            int i4 = 0;
            while (i4 < pub_static_methods.length) {
                ((MethodDefinition)pub_static_methods[i4]).setMethodToken(i4);
                ++i4;
            }
        }
        ClassConverter.sortMethodsByTokens((MethodDefinition[])pub_static_methods);
        ClassConverter.assignNewMethodTokens((MethodDefinition[])pub_static_methods);
    }

    private static void assignNewMethodTokens(MethodDefinition[] methods) {
        int i = 0;
        while (i < methods.length) {
            methods[i].setMethodToken(i);
            ++i;
        }
    }

    private JcImplementedInterfaceInfo[] constructImplementedInterfaceInfos() throws Exception {
        String[] all_interfaces = this.jc_class.getSuperInterfaces();
        JcImplementedInterfaceInfo[] interface_infos = new JcImplementedInterfaceInfo[all_interfaces.length];
        MethodDefinition[] public_method_table = this.jc_class.getPublicMethodTable().getMethods();
        String this_package_name = Names.getPackageName(this.jc_class.getClassName());
        int i = 0;
        while (i < all_interfaces.length) {
            JcImplementedInterfaceInfo interface_info;
            MethodDefinition[] interface_methods;
            String an_interface = all_interfaces[i];
            if (Names.getPackageName(an_interface).equals(this_package_name)) {
                JcClass jc_interface = this.p_converter.getJcClass(an_interface);
                if (jc_interface == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), an_interface.replace('/', '.')};
                    Notifier.error("linking.5", args);
                    throw new ConversionException();
                }
                interface_methods = jc_interface.getPublicMethodTable().getMethods();
            } else {
                EfClass ef_interface = this.getExportClass(an_interface);
                if (ef_interface == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), an_interface.replace('/', '.'), Names.getExportFileName(Names.getPackageName(an_interface))};
                    Notifier.error("linking.4", args);
                    throw new ConversionException();
                }
                interface_methods = ef_interface.getMethods();
            }
            MethodDefinition[] sorted_interface_methods = new MethodDefinition[interface_methods.length];
            int j = 0;
            while (j < interface_methods.length) {
                MethodDefinition method_j = interface_methods[j];
                int token = method_j.getMethodToken();
                sorted_interface_methods[token] = method_j;
                ++j;
            }
            int[] tokens = new int[sorted_interface_methods.length];
            int j2 = 0;
            while (j2 < sorted_interface_methods.length) {
                MethodDefinition method_j = sorted_interface_methods[j2];
                int k = 0;
                while (k < public_method_table.length) {
                    MethodDefinition method_k = public_method_table[k];
                    if (method_j.getMethodName().equals(method_k.getMethodName()) && method_j.getMethodDescriptor().equals(method_k.getMethodDescriptor())) {
                        tokens[j2] = k;
                        break;
                    }
                    ++k;
                }
                if (k == public_method_table.length) {
                    throw new ClassFormatError();
                }
                ++j2;
            }
            interface_infos[i] = interface_info = new JcImplementedInterfaceInfo(an_interface, sorted_interface_methods, tokens);
            ++i;
        }
        return interface_infos;
    }

    /*
     * WARNING - void declaration
     */
    private JcMethodTable constructVirtualMethodTable(int type) throws Exception {
        void var7_8;
        Object[] methods;
        MethodDefinition[] super_class_methods = this.getSuperClassMethodTable(this.java_class.getSuperClassName(), type);
        Vector vector = this.findMethodsByType(this.java_class.getMethods(), type);
        Object[] this_class_methods = new MethodDefinition[vector.size()];
        vector.copyInto(this_class_methods);
        if (type == 1) {
            this.sortMethods((MethodDefinition[])this_class_methods);
        }
        int method_table_base = 0;
        if (super_class_methods == null) {
            methods = this_class_methods;
            method_table_base = 0;
        } else {
            Vector<MethodDefinition> method_table_vector = new Vector<MethodDefinition>(Arrays.asList(super_class_methods));
            method_table_base = method_table_vector.size();
            int i = 0;
            while (i < this_class_methods.length) {
                int j = 0;
                while (j < super_class_methods.length) {
                    if (((MethodDefinition)this_class_methods[i]).getMethodSignature().equals(super_class_methods[j].getMethodSignature()) && ((MethodDefinition)this_class_methods[i]).getMethodName().equals(super_class_methods[j].getMethodName())) {
                        if (method_table_base > j) {
                            method_table_base = j;
                        }
                        method_table_vector.set(j, (MethodDefinition)this_class_methods[i]);
                        break;
                    }
                    ++j;
                }
                if (j == super_class_methods.length) {
                    method_table_vector.addElement((MethodDefinition)this_class_methods[i]);
                }
                ++i;
            }
            methods = new MethodDefinition[method_table_vector.size()];
            method_table_vector.copyInto(methods);
        }
        boolean i = false;
        while (var7_8 < methods.length) {
            if (type == 1) {
                ((MethodDefinition)methods[var7_8]).setMethodToken((int)var7_8);
            } else {
                ((MethodDefinition)methods[var7_8]).setMethodToken((int)(var7_8 | 0x80));
            }
            ++var7_8;
        }
        JcMethodTable method_table = new JcMethodTable((MethodDefinition[])methods, method_table_base);
        return method_table;
    }

    public JcClass convert() throws Exception {
        this.intTypeCheck();
        this.jc_class.setAccessFlags(this.jc_class.getAccessFlags() & 0xFFFFF7FF);
        String[] super_classes = this.determinePublicSuperClasses();
        this.jc_class.setPublicSuperClasses(super_classes);
        String[] super_interfaces = this.determineAllSuperInterfaces();
        this.jc_class.setSuperInterfaces(super_interfaces);
        String[] public_super_interfaces = this.determinePublicSuperInterfaces();
        this.jc_class.setPublicSuperInterfaces(public_super_interfaces);
        this.detectRemovedPublicSuperinterfaces();
        if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
            this.detectAddedPublicSuperinterfaces();
        }
        this.detectRemovedPublicSuperclasses();
        if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
            this.detectAddedPublicSuperclasses();
        }
        boolean flag = this.determineShareableType();
        this.jc_class.setShareableType(flag);
        JField[] java_fields = this.sortFields();
        JcField[] jc_fields = new JcField[java_fields.length];
        int i = 0;
        while (i < java_fields.length) {
            jc_fields[i] = new JcField(java_fields[i]);
            if (this.getJcClass().getEfClass() != null) {
                jc_fields[i].setEfField(this.getJcClass().getEfClass().getField(java_fields[i].getFieldName(), java_fields[i].getFieldDescriptor()));
            }
            ++i;
        }
        this.jc_class.setFields(jc_fields);
        this.detectRemovedAPIFields();
        this.detectAddedAPIFields();
        this.checkFieldFlags();
        this.checkFieldValues();
        this.assignFieldTokenAndComputeFieldData();
        this.orderMethods();
        JcMethodTable pub_method_table = this.constructVirtualMethodTable(1);
        this.jc_class.setPublicMethodTable(pub_method_table);
        JcMethodTable pac_method_table = this.constructVirtualMethodTable(2);
        this.jc_class.setPackageMethodTable(pac_method_table);
        MethodDefinition[] java_methods = this.java_class.getMethods();
        JcMethod[] jc_methods = null;
        Vector vector = this.findMethodsByType(java_methods, 0);
        if (vector.size() == 0) {
            jc_methods = new JcMethod[java_methods.length];
        } else {
            jc_methods = new JcMethod[java_methods.length - 1];
            ClinitConverter clinit_converter = new ClinitConverter((JMethod)vector.elementAt(0), this.jc_class);
            clinit_converter.convert();
        }
        this.jc_class.setMethods(jc_methods);
        int j = 0;
        int i2 = 0;
        while (i2 < java_methods.length) {
            MethodDefinition java_method = java_methods[i2];
            if (!java_method.getMethodName().equals("<clinit>")) {
                MethodConverter m_converter = new MethodConverter((JMethod)java_methods[i2], this, this.p_converter);
                jc_methods[j++] = m_converter.convert();
            }
            ++i2;
        }
        this.detectRemovedAPIMethods();
        this.detectModifiedAPIMethods();
        this.detectAddedAPIMethods();
        this.checkMethodFlags();
        this.assignMethodTokens();
        JcImplementedInterfaceInfo[] interface_infos = this.constructImplementedInterfaceInfos();
        this.jc_class.setImplementedInterfaceInfos(interface_infos);
        return this.jc_class;
    }

    protected void detectAddedAPIMethods() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        JcMethod[] jcMethods = this.getJcClass().getMethods();
        int i = 0;
        while (i < jcMethods.length) {
            EfMethod efMethod;
            if ((jcMethods[i].isPublic() || jcMethods[i].isProtected()) && (efMethod = this.getJcClass().getEfClass().getMethod(jcMethods[i].getMethodName(), jcMethods[i].getMethodDescriptor())) == null) {
                if (!this.getPackageConverter().getConversionProfile().packageUpgrade && jcMethods[i].isStatic()) {
                    Object[] args = new Object[]{jcMethods[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.23", args);
                    throw new ConverterException();
                }
                if (!this.getJcClass().isFinal() && !jcMethods[i].isStatic()) {
                    Object[] args = new Object[]{jcMethods[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.24", args);
                    throw new ConverterException();
                }
                if (!this.getPackageConverter().getConversionProfile().packageUpgrade && !jcMethods[i].isStatic() && this.getJcClass().isFinal()) {
                    Object[] args = new Object[]{jcMethods[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.25", args);
                    throw new ConverterException();
                }
            }
            ++i;
        }
    }

    protected void detectAddedPublicSuperclasses() throws Exception {
        Vector<String> jv;
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> ev = new Vector<String>(Arrays.asList(efClass.getSuperClassNames()));
        if (ev.containsAll(jv = new Vector<String>(Arrays.asList(jcClass.getPublicSuperClasses())))) {
            return;
        }
        jv.removeAll(ev);
        if (!jv.isEmpty()) {
            Object[] args = new Object[]{jv.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.38", args);
            throw new ConverterException();
        }
    }

    protected void detectModifiedAPIMethods() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfMethod[] efMethods = this.getJcClass().getEfClass().getMethods();
        int i = 0;
        while (i < efMethods.length) {
            EfMethod efMethod = efMethods[i];
            MethodDefinition jcMethod = this.getJcClass().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor());
            if (jcMethod == null) {
                jcMethod = this.getJcClass().getPublicMethodTable().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor());
            }
            if (efMethod.isStatic() && !jcMethod.isStatic()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.26", args);
                throw new ConverterException();
            }
            if (!efMethod.isStatic() && jcMethod.isStatic()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.27", args);
                throw new ConverterException();
            }
            if (efMethod.isPublic() && jcMethod.isPrivate()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.28", args);
                throw new ConverterException();
            }
            if (efMethod.isPublic() && jcMethod.isProtected()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.29", args);
                throw new ConverterException();
            }
            if (efMethod.isProtected() && jcMethod.isPrivate()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.30", args);
                throw new ConverterException();
            }
            if (efMethod.isPublic() && jcMethod.isDefault()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.31", args);
                throw new ConverterException();
            }
            if (efMethod.isProtected() && jcMethod.isDefault()) {
                Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.32", args);
                throw new ConverterException();
            }
            if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
                if (efMethod.isProtected() && jcMethod.isPublic()) {
                    Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.33", args);
                    throw new ConverterException();
                }
                if (efMethod.isFinal() && !jcMethod.isFinal()) {
                    Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.34", args);
                    throw new ConverterException();
                }
                if (efMethod.isAbstract() && !jcMethod.isAbstract()) {
                    Object[] args = new Object[]{efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.35", args);
                    throw new ConverterException();
                }
            }
            ++i;
        }
    }

    protected void detectRemovedAPIMethods() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfMethod[] efMethods = this.getJcClass().getEfClass().getMethods();
        int i = 0;
        while (i < efMethods.length) {
            MethodDefinition mdMethod;
            EfMethod efMethod = efMethods[i];
            JcMethod jcMethod = this.getJcClass().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor());
            if (jcMethod == null && (mdMethod = this.getJcClass().getPublicMethodTable().getMethod(efMethod.getMethodName(), efMethod.getMethodDescriptor())) == null) {
                Object[] args = new Object[]{efMethod.getMethodDescriptor(), efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.22", args);
                throw new ConverterException();
            }
            ++i;
        }
    }

    protected void detectRemovedPublicSuperclasses() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> ev = new Vector<String>(Arrays.asList(efClass.getSuperClassNames()));
        Vector<String> jv = new Vector<String>(Arrays.asList(jcClass.getPublicSuperClasses()));
        if (jv.containsAll(ev)) {
            return;
        }
        ev.removeAll(jv);
        if (!ev.isEmpty()) {
            Object[] args = new Object[]{ev.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.36", args);
            throw new ConverterException();
        }
    }

    private String[] determineAllSuperInterfaces() throws Exception {
        Vector interface_vector = new Vector(15);
        String super_class = this.java_class.getSuperClassName();
        String this_package_name = Names.getPackageName(this.java_class.getClassName());
        if (super_class != null) {
            String[] super_super_interfaces;
            if (Names.getPackageName(super_class).equals(this_package_name)) {
                JcClass jc_super_class = this.p_converter.getJcClass(super_class);
                if (jc_super_class == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), super_class.replace('/', '.')};
                    Notifier.error("linking.3", args);
                    throw new ConversionException();
                }
                super_super_interfaces = jc_super_class.getSuperInterfaces();
                this.addInterfaces(interface_vector, super_super_interfaces);
            } else {
                EfClass ef_super_class = this.getExportClass(super_class);
                if (ef_super_class == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), super_class.replace('/', '.'), Names.getExportFileName(Names.getPackageName(super_class))};
                    Notifier.error("linking.2", args);
                    throw new ConversionException();
                }
                super_super_interfaces = ef_super_class.getInterfaceNames();
                this.addInterfaces(interface_vector, super_super_interfaces);
            }
        }
        String[] direct_interfaces = this.java_class.getInterfaceNames();
        int i = 0;
        while (i < direct_interfaces.length) {
            String[] super_super_interfaces;
            String direct_interface = direct_interfaces[i];
            if (Names.getPackageName(direct_interface).equals(this_package_name)) {
                JcClass jc_super_interface = this.p_converter.getJcClass(direct_interface);
                if (jc_super_interface == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), direct_interface.replace('/', '.')};
                    Notifier.error("linking.5", args);
                    throw new ConversionException();
                }
                super_super_interfaces = jc_super_interface.getSuperInterfaces();
            } else {
                EfClass ef_super_class = this.getExportClass(direct_interface);
                if (ef_super_class == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), direct_interface.replace('/', '.'), Names.getExportFileName(Names.getPackageName(direct_interface))};
                    Notifier.error("linking.4", args);
                    throw new ConversionException();
                }
                super_super_interfaces = ef_super_class.getInterfaceNames();
            }
            this.addInterfaces(interface_vector, super_super_interfaces);
            this.addInterface(interface_vector, direct_interface);
            ++i;
        }
        Object[] all_interfaces = new String[interface_vector.size()];
        interface_vector.copyInto(all_interfaces);
        return all_interfaces;
    }

    private String[] determinePublicSuperClasses() throws Exception {
        String super_class_name = this.jc_class.getSuperClassName();
        if (super_class_name == null) {
            return new String[0];
        }
        String this_class_name = this.jc_class.getClassName();
        String this_package_name = Names.getPackageName(this_class_name);
        if (!Names.getPackageName(super_class_name).equals(this_package_name)) {
            EfClass ef_class = this.getExportClass(super_class_name);
            if (ef_class == null) {
                Object[] args = new String[]{this.jc_class.getClassName().replace('/', '.'), super_class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(super_class_name))};
                Notifier.error("linking.2", args);
                throw new ConversionException();
            }
            String[] super_super_classes = ef_class.getSuperClassNames();
            String[] all_super_classes = new String[super_super_classes.length + 1];
            System.arraycopy(super_super_classes, 0, all_super_classes, 0, super_super_classes.length);
            all_super_classes[super_super_classes.length] = super_class_name;
            return all_super_classes;
        }
        JcClass jc_super_class = this.p_converter.getJcClass(super_class_name);
        if (Modifier.isPublic(jc_super_class.getAccessFlags())) {
            String[] super_super_classes = jc_super_class.getPublicSuperClasses();
            String[] all_super_classes = new String[super_super_classes.length + 1];
            System.arraycopy(super_super_classes, 0, all_super_classes, 0, super_super_classes.length);
            all_super_classes[super_super_classes.length] = super_class_name;
            return all_super_classes;
        }
        if (!Modifier.isPublic(jc_super_class.getAccessFlags()) && this.jc_class.isPublic() && (jc_super_class.hasPublicMethods() || jc_super_class.hasProtectedMethods())) {
            Object[] args = new String[]{this.jc_class.getClassName().replace('/', '.'), super_class_name.replace('/', '.')};
            Notifier.error("subset.54", args);
            throw new ConversionException();
        }
        return jc_super_class.getPublicSuperClasses();
    }

    private Vector findFieldsByType(FieldDefinition[] fields, int type) {
        Vector<FieldDefinition> found_fields_vector = new Vector<FieldDefinition>(20);
        int i = 0;
        while (i < fields.length) {
            int access_flags = fields[i].getAccessFlags();
            String descriptor = fields[i].getFieldDescriptor();
            switch (type) {
                case 4: {
                    if (!Modifier.isStatic(access_flags) || !Modifier.isFinal(access_flags) || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags) || DataType.getType(descriptor) == 10) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                case 5: {
                    if (Modifier.isStatic(access_flags) && !Modifier.isFinal(access_flags) && (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags))) {
                        found_fields_vector.addElement(fields[i]);
                    }
                    if (!Modifier.isStatic(access_flags) || !Modifier.isFinal(access_flags) || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags) || DataType.getType(descriptor) != 10) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                case 6: {
                    if (!Modifier.isStatic(access_flags) || Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                case 0: {
                    if (Modifier.isStatic(access_flags) || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags) || DataType.getType(descriptor) == 10) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                case 1: {
                    if (Modifier.isStatic(access_flags) || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags) || DataType.getType(descriptor) != 10) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                case 2: {
                    if (Modifier.isStatic(access_flags) || Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags) || DataType.getType(descriptor) != 10) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                case 3: {
                    if (Modifier.isStatic(access_flags) || Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags) || DataType.getType(descriptor) == 10) break;
                    found_fields_vector.addElement(fields[i]);
                    break;
                }
                default: {
                    throw new ConverterInternalError();
                }
            }
            ++i;
        }
        return found_fields_vector;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private Vector findMethodsByType(MethodDefinition[] methods, int type) {
        found_methods_vector = new Vector<MethodDefinition>(20);
        i = 0;
        while (i < methods.length) {
            block14: {
                block13: {
                    access_flags = methods[i].getAccessFlags();
                    if (!methods[i].getMethodName().equals("<clinit>")) break block13;
                    if (type == 0) {
                        found_methods_vector.addElement(methods[i]);
                    }
                    break block14;
                }
                if (!methods[i].getMethodName().equals("<init>")) ** GOTO lbl20
                switch (type) {
                    case 3: {
                        if (!Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) break;
                        found_methods_vector.addElement(methods[i]);
                        break;
                    }
                    case 4: {
                        if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) break;
                        found_methods_vector.addElement(methods[i]);
                        break;
                    }
lbl20:
                    // 1 sources

                    switch (type) {
                        case 1: {
                            if (Modifier.isStatic(access_flags) || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) break;
                            found_methods_vector.addElement(methods[i]);
                            break;
                        }
                        case 2: {
                            if (Modifier.isStatic(access_flags) || Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags) || Modifier.isPrivate(access_flags)) break;
                            found_methods_vector.addElement(methods[i]);
                            break;
                        }
                        case 3: {
                            if (!Modifier.isStatic(access_flags) || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) break;
                            found_methods_vector.addElement(methods[i]);
                            break;
                        }
                        case 4: {
                            if (!Modifier.isStatic(access_flags) || Modifier.isPublic(access_flags) && Modifier.isProtected(access_flags)) break;
                            found_methods_vector.addElement(methods[i]);
                            break;
                        }
                        case 5: {
                            if (Modifier.isStatic(access_flags) || !Modifier.isPrivate(access_flags)) break;
                            found_methods_vector.addElement(methods[i]);
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        return found_methods_vector;
    }

    private int getFieldSize(String descriptor) {
        if (descriptor.equals("I")) {
            return 2;
        }
        return 1;
    }

    private EfField[] getFieldsFromExportFile(int type) throws Exception {
        EfClass export_class = this.getExportClass(this.java_class.getClassName());
        if (export_class == null) {
            Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), this.java_class.getClassName().replace('/', '.'), Names.getExportFileName(Names.getPackageName(this.java_class.getClassName()))};
            Notifier.error("linking.6", args);
            throw new LinkException();
        }
        Vector vector = this.findFieldsByType(export_class.getFields(), type);
        Object[] fields = new EfField[vector.size()];
        vector.copyInto(fields);
        int i = 0;
        while (i < fields.length) {
            Object field_i = fields[i];
            int j = i + 1;
            while (j < fields.length) {
                Object field_j = fields[j];
                if (((FieldDefinition)field_i).getFieldToken() > ((FieldDefinition)field_j).getFieldToken()) {
                    Object temp = field_i;
                    fields[i] = fields[j];
                    fields[j] = temp;
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return fields;
    }

    private MethodDefinition[] getMethodsFromExportClass(String class_name, int type) throws Exception {
        EfClass export_class = this.getExportClass(class_name);
        if (export_class == null) {
            return new MethodDefinition[0];
        }
        Vector vector = this.findMethodsByType(export_class.getMethods(), type);
        Object[] found_methods = new EfMethod[vector.size()];
        vector.copyInto(found_methods);
        int i = 0;
        while (i < found_methods.length) {
            Object method_i = found_methods[i];
            int j = ((MethodDefinition)method_i).getMethodToken();
            if (i != j) {
                found_methods[i] = found_methods[j];
                found_methods[j] = method_i;
            }
            ++i;
        }
        return found_methods;
    }

    private MethodDefinition[] getSuperClassMethodTable(String super_class_name, int type) throws Exception {
        if (super_class_name == null) {
            return new MethodDefinition[0];
        }
        String super_class_package_name = Names.getPackageName(super_class_name);
        JcPackage jc_package = this.p_converter.getJcPackage();
        if (jc_package.getPackageName().equals(super_class_package_name)) {
            JcClass super_class = this.p_converter.getJcClass(super_class_name);
            if (type == 1) {
                return super_class.getPublicMethodTable().getMethods();
            }
            return super_class.getPackageMethodTable().getMethods();
        }
        if (type == 1) {
            return this.getMethodsFromExportClass(super_class_name, 1);
        }
        return new MethodDefinition[0];
    }

    private static int getToken(MethodDefinition[] methods, MethodDefinition method) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getMethodName().equals(method.getMethodName()) && methods[i].getMethodSignature().equals(method.getMethodSignature())) {
                return methods[i].getMethodToken();
            }
            ++i;
        }
        return 255;
    }

    private boolean isThisExpProvided() {
        int access_flags = this.java_class.getAccessFlags();
        if (Modifier.isPublic(access_flags)) {
            return this.p_converter.isThisExpProvided();
        }
        return false;
    }

    private void orderMethods() {
        JMethod[] methods = this.java_class.getMethods();
        int i = 0;
        while (i < methods.length) {
            JMethod method_i = methods[i];
            int access_flags = methods[i].getAccessFlags();
            if (Modifier.isFinal(access_flags)) {
                int j = 0;
                while (j < methods.length) {
                    JMethod method_j = methods[j];
                    if (!Modifier.isFinal(method_j.getAccessFlags())) {
                        if (j >= i) break;
                        int k = i;
                        while (k > j) {
                            methods[k] = methods[k - 1];
                            --k;
                        }
                        methods[j] = method_i;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = methods.length - 1;
        while (i2 >= 0) {
            JMethod method_i = methods[i2];
            int access_flags = methods[i2].getAccessFlags();
            if (!Modifier.isFinal(access_flags) && Modifier.isAbstract(access_flags)) {
                int j = methods.length - 1;
                while (j >= 0) {
                    JMethod method_j = methods[j];
                    if (!Modifier.isAbstract(method_j.getAccessFlags())) {
                        if (i2 >= j) break;
                        int k = i2;
                        while (k < j) {
                            methods[k] = methods[k + 1];
                            ++k;
                        }
                        methods[j] = method_i;
                        ++i2;
                        break;
                    }
                    --j;
                }
            }
            --i2;
        }
    }

    private int selectFieldsByType(JField[] sorted_fields, int count, int type) {
        FieldDefinition[] java_fields = this.java_class.getFields();
        Vector vector = this.findFieldsByType(java_fields, type);
        Object[] selected_fields = new JField[vector.size()];
        vector.copyInto(selected_fields);
        System.arraycopy(selected_fields, 0, sorted_fields, count, selected_fields.length);
        return count += selected_fields.length;
    }

    private int selectSortFieldsByType(JField[] sorted_fields, int counter, int type) {
        FieldDefinition[] all_fields = this.java_class.getFields();
        Vector vector = this.findFieldsByType(all_fields, type);
        Object[] selected_fields = new JField[vector.size()];
        vector.copyInto(selected_fields);
        String class_name = this.java_class.getClassName();
        System.arraycopy(selected_fields, 0, sorted_fields, counter, selected_fields.length);
        return counter += selected_fields.length;
    }

    private JField[] sortFields() {
        JField[] java_fields = this.java_class.getFields();
        JField[] sorted_fields = new JField[java_fields.length];
        int count = 0;
        count = this.selectSortFieldsByType(sorted_fields, count, 0);
        count = this.selectSortFieldsByType(sorted_fields, count, 1);
        count = this.selectFieldsByType(sorted_fields, count, 2);
        count = this.selectFieldsByType(sorted_fields, count, 3);
        count = this.selectSortFieldsByType(sorted_fields, count, 4);
        count = this.selectSortFieldsByType(sorted_fields, count, 5);
        count = this.selectFieldsByType(sorted_fields, count, 6);
        return sorted_fields;
    }

    private void sortMethods(MethodDefinition[] methods) throws Exception {
        if (!this.isThisExpProvided()) {
            return;
        }
        if (!this.jc_class.isAPIElement(this.p_converter.getJcPackage())) {
            return;
        }
        String class_name = this.java_class.getClassName();
        EfClass ef_class = this.getExportClass(class_name);
        if (ef_class == null) {
            int i = 0;
            while (i < methods.length) {
                methods[i].setMethodToken(255);
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < methods.length) {
            MethodDefinition method_i = methods[i];
            EfMethod ef_method = ef_class.getMethod(method_i.getMethodName(), method_i.getMethodDescriptor());
            if (ef_method == null) {
                methods[i].setMethodToken(255);
            } else {
                methods[i].setMethodToken(ef_method.getMethodToken());
            }
            ++i;
        }
        ClassConverter.sortMethodsByTokens(methods);
    }

    private static void sortMethodsByTokens(MethodDefinition[] methods) {
        boolean again = true;
        while (again) {
            again = false;
            int i = 0;
            while (i < methods.length - 1) {
                if (methods[i].getMethodToken() > methods[i + 1].getMethodToken()) {
                    again = true;
                    MethodDefinition tmp = methods[i];
                    methods[i] = methods[i + 1];
                    methods[i + 1] = tmp;
                }
                ++i;
            }
        }
    }
}

