/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

public class DataType {
    public static final byte _undefined = 0;
    public static final byte _byte = 1;
    public static final byte _short = 2;
    public static final byte _int = 3;
    public static final byte _long = 4;
    public static final byte _float = 5;
    public static final byte _double = 6;
    public static final byte _boolean = 7;
    public static final byte _char = 8;
    public static final byte _void = 9;
    public static final byte _reference = 10;
    public static final byte _string = 20;

    public static final int getSize(String descriptor) {
        if (DataType.getType(descriptor) == 3) {
            return 2;
        }
        return 1;
    }

    public static final int getType(int value) {
        if (value < 128 && value >= -128) {
            return 1;
        }
        if (value < 32768 && value >= Short.MIN_VALUE) {
            return 2;
        }
        return 3;
    }

    public static final int getType(String descriptor) {
        if (descriptor.startsWith("L")) {
            return 10;
        }
        if (descriptor.startsWith("[")) {
            return 10;
        }
        if (descriptor.equals("B")) {
            return 1;
        }
        if (descriptor.equals("S")) {
            return 2;
        }
        if (descriptor.equals("I")) {
            return 3;
        }
        if (descriptor.equals("J")) {
            return 4;
        }
        if (descriptor.equals("F")) {
            return 5;
        }
        if (descriptor.equals("D")) {
            return 6;
        }
        if (descriptor.equals("Z")) {
            return 1;
        }
        if (descriptor.equals("C")) {
            return 8;
        }
        if (descriptor.equals("V")) {
            return 9;
        }
        return 0;
    }

    public static final String getTypeString(String descriptor) {
        if (descriptor.startsWith("L")) {
            return "reference";
        }
        if (descriptor.startsWith("[")) {
            return "reference";
        }
        if (descriptor.equals("B")) {
            return "byte";
        }
        if (descriptor.equals("S")) {
            return "short";
        }
        if (descriptor.equals("I")) {
            return "int";
        }
        if (descriptor.equals("J")) {
            return "long";
        }
        if (descriptor.equals("F")) {
            return "float";
        }
        if (descriptor.equals("D")) {
            return "double";
        }
        if (descriptor.equals("Z")) {
            return "boolean";
        }
        if (descriptor.equals("C")) {
            return "char";
        }
        if (descriptor.equals("V")) {
            return "void";
        }
        return "undefined";
    }

    public static final boolean isArrayType(String descriptor) {
        return descriptor.startsWith("[");
    }

    public static final boolean isBooleanType(String descriptor) {
        return descriptor.equals("Z");
    }

    public static final boolean isMultiDimensionArray(String descriptor) {
        return descriptor.startsWith("[[");
    }

    public static final boolean isPrimitiveType(String descriptor) {
        if (descriptor.startsWith("L")) {
            return false;
        }
        return !descriptor.startsWith("[");
    }
}

