/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcfile.JcField;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class FieldDebugInfo
extends FieldDefinition {
    private int name_index;
    private int descriptor_index;
    private int location;

    public FieldDebugInfo(JcField jc_field, DebugComponent debug_comp) {
        super(jc_field);
        this.build(jc_field, debug_comp);
    }

    private void build(JcField jc_field, DebugComponent debug_comp) {
        this.name_index = debug_comp.addString(this.field_name);
        this.descriptor_index = debug_comp.addString(this.descriptor);
    }

    public int getSize() {
        return 10;
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort(this.access_flags);
        if (Modifier.isStatic(this.access_flags)) {
            if (Modifier.isFinal(this.access_flags) && DataType.isPrimitiveType(this.descriptor)) {
                dos.writeInt(this.value[0]);
            } else {
                dos.writeInt(this.location);
            }
        } else {
            dos.writeInt(this.token);
        }
        dos.flush();
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(String.valueOf(indent) + "field_debug_info { ");
        pw.println(String.valueOf(indent) + "\tname_index " + this.name_index + "\t\t//" + this.field_name);
        pw.println(String.valueOf(indent) + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        pw.println(String.valueOf(indent) + "\taccess_flags " + Modifier.toString(this.access_flags));
        if (Modifier.isStatic(this.access_flags)) {
            if (Modifier.isFinal(this.access_flags) && DataType.isPrimitiveType(this.descriptor)) {
                pw.println(String.valueOf(indent) + "\tvalue " + this.value[0]);
            } else {
                pw.println(String.valueOf(indent) + "\tlocation " + this.location);
            }
        } else {
            pw.println(String.valueOf(indent) + "\ttoken " + this.token);
        }
        pw.println(String.valueOf(indent) + "}");
        pw.flush();
    }
}

