/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CrefOutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble = new StringBuffer();
    protected StringBuffer rom;
    protected int romLength = 0;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected int nonZeroStaticInitSize = 0;
    protected int zeroStaticInitSize = 0;
    protected StringBuffer applets;
    protected int napplets = 0;
    protected StringBuffer packages;
    protected int npackages = 0;
    protected StringBuffer exceptionTable;
    static final int exceptionEntrySize = 8;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries = 0;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    protected Vector suppressionVector;
    private int relocPc;
    private int relocFieldPc;
    private int m_romBase = 0;
    private int m_e2Base = 32768;
    private static final int ARRAY_HEADER_SIZE = 6;

    public CrefOutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
        String noExportComponent;
        this.preamble.append("#include \"profile.h\"" + Msg.eol);
        this.preamble.append("#include \"opcode.h\"" + Msg.eol);
        this.preamble.append("#include \"mask.h\"" + Msg.eol);
        this.rom = new StringBuffer();
        this.staticFields = new StringBuffer();
        this.staticInit = new StringBuffer();
        this.applets = new StringBuffer();
        this.packages = new StringBuffer();
        this.defineList = new StringBuffer();
        this.exceptionTable = new StringBuffer();
        this.exportComponent = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        try {
            String strRomBase = this.getMapEntry("ROMBASE");
            if (strRomBase != null) {
                this.m_romBase = Integer.decode(strRomBase);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.0", null);
        }
        try {
            String strE2Base = this.getMapEntry("E2BASE");
            if (strE2Base != null) {
                this.m_e2Base = Integer.decode(strE2Base);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.1", null);
        }
        if ((noExportComponent = this.getMapEntry("NOEXPORTCOMPONENT")) != null) {
            StringTokenizer parser = new StringTokenizer(noExportComponent, ",");
            while (parser.hasMoreTokens()) {
                this.suppressionVector.addElement(parser.nextToken().trim());
            }
        }
        this.relocPc = this.m_romBase;
        this.relocFieldPc = this.m_e2Base;
    }

    protected void format(Instruction i) {
        this.rom.append("_" + i.getMnemonic().toUpperCase());
        ++this.romLength;
        Enumeration e = i.operandElements();
        while (e.hasMoreElements()) {
            Operand o = (Operand)e.nextElement();
            this.format(o);
        }
    }

    protected void format(Operand o) {
        block17: {
            block18: {
                block16: {
                    if (o.getType() != 8) break block16;
                    Info info = o.resolve();
                    switch (info.getType()) {
                        case 1: 
                        case 4: 
                        case 6: {
                            int addr = info.resolve().getRelocAddr();
                            this.rom.append(", HIGH(" + Msg.toHexString((short)addr) + "), LOW(" + Msg.toHexString((short)addr) + ")");
                            this.romLength += 2;
                            break block17;
                        }
                        case 5: {
                            int addr = info.resolve().getRelocAddr();
                            this.rom.append(", HIGH(" + Msg.toHexString((short)addr) + "), LOW(" + Msg.toHexString((short)addr) + ")");
                            this.romLength += 2;
                            break block17;
                        }
                        case 3: {
                            JCMethod m = (JCMethod)info.resolve();
                            MethodIdentifier mid = m.getMethodIdentifier();
                            int token = mid.getMethodToken();
                            int params = m.getParams();
                            this.rom.append(", " + Msg.toHexString((byte)params) + ", " + Msg.toHexString((byte)token));
                            this.romLength += 2;
                            break block17;
                        }
                        case 2: {
                            Field f = (Field)info.resolve();
                            JCClass c = f.getParentClass();
                            int fToken = f.getFieldIdentifier().getFieldToken();
                            int offset = fToken + c.getInstanceBase();
                            this.rom.append(", " + Msg.toHexString((byte)offset >> 8) + ", " + Msg.toHexString((byte)offset));
                            this.romLength += 2;
                            break block17;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                if (o.getType() != 7) break block18;
                Info info = o.resolve();
                switch (info.getType()) {
                    case 2: {
                        Field f = (Field)info.resolve();
                        JCClass c = f.getParentClass();
                        int fToken = f.getFieldIdentifier().getFieldToken();
                        int offset = fToken + c.getInstanceBase();
                        this.rom.append(", " + Msg.toHexString((byte)offset));
                        ++this.romLength;
                        break block17;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            if (o.size() == 1) {
                if (o.getValue() >= 0) {
                    this.rom.append(", " + o.getValue());
                } else {
                    this.rom.append(", LOW(" + o.getValue() + ")");
                }
                ++this.romLength;
            } else if (o.size() == 2) {
                this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
                this.romLength += 2;
            } else if (o.size() == 4) {
                this.rom.append(", " + (o.getValue() >> 24 & 0xFF) + ", " + (o.getValue() >> 16 & 0xFF));
                this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
                this.romLength += 4;
            }
        }
    }

    protected void format(Statement s, JCMethod m) {
        if (s.getInstruction() == null) {
            return;
        }
        this.rom.append("/* " + Msg.toHexString((short)(m.getRelocAddr() + 2 + s.getRelPc())) + ": */ ");
        this.format(s.getInstruction());
    }

    public void format(RomMask r) {
        this.pass1(r);
        if (Globals.errors == 0) {
            this.pass2(r);
        }
    }

    public String formatBigEndian(short value) {
        return "HIGH(" + Msg.toHexString(value) + "), " + "LOW(" + Msg.toHexString(value) + ")";
    }

    protected void pass1(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = (JCClass)f.nextElement();
                Enumeration g = c.fieldElements();
                while (g.hasMoreElements()) {
                    StaticFieldInitializer init;
                    Field field = (Field)g.nextElement();
                    if (!Modifier.isStatic(field.getAttributes())) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive() || (init = field.getFieldInitializer()) == null) continue;
                    field.relocate(this.relocFieldPc);
                    this.relocFieldPc += field.size();
                    if (init.isPrimitive()) continue;
                    if (p.appletCount() == 0) {
                        Object[] args = new Object[]{field.getName(), p.getName()};
                        Msg.error("mlink.17", args);
                        continue;
                    }
                    String descStr = descriptor.getDescriptorString();
                    int[] data = init.getArrayData();
                    if (descStr.equals("[B") || descStr.equals("[Z")) {
                        this.relocFieldPc += 6 + data.length;
                        continue;
                    }
                    if (descStr.equals("[S")) {
                        this.relocFieldPc += 6 + data.length * 2;
                        continue;
                    }
                    if (descStr.equals("[I")) {
                        this.relocFieldPc += 6 + data.length * 4;
                        continue;
                    }
                    throw new InternalError();
                }
            }
        }
        Enumeration e2 = r.packageElements();
        while (e2.hasMoreElements()) {
            JCPackage p = (JCPackage)e2.nextElement();
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = (JCClass)f.nextElement();
                c.relocate(this.relocPc);
                this.relocPc += c.size();
                if (Modifier.isInterface(c.getAttributes())) continue;
                Enumeration g = c.fieldElements();
                while (g.hasMoreElements()) {
                    StaticFieldInitializer init;
                    Field field = (Field)g.nextElement();
                    if (!Modifier.isStatic(field.getAttributes())) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive() || (init = field.getFieldInitializer()) != null) continue;
                    field.relocate(this.relocFieldPc);
                    this.relocFieldPc += field.size();
                }
                Enumeration g2 = c.methodElements();
                while (g2.hasMoreElements()) {
                    JCMethod m = (JCMethod)g2.nextElement();
                    m.relocate(this.relocPc);
                    this.relocPc += m.size();
                    if (!Modifier.isNative(m.getAttributes())) continue;
                    this.relocPc += 2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void pass2(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            boolean suppressExportComponent = this.suppressionVector.contains(p.getName());
            ExportComponent export = new ExportComponent(p);
            PackageIdentifier pid = p.getIdentifier();
            this.packageDirectory.addPackage(pid);
            byte[] aid = pid.getAid().toByteArray();
            this.packages.append("/* " + p.getName() + " */" + Msg.eol);
            this.packages.append("{ { " + aid.length + ", { ");
            this.packages.append(String.valueOf(Msg.toHexString(aid, ", ")) + ", ");
            this.packages.append("} }, " + pid.getMajorVersion() + ", " + pid.getMinorVersion() + ", " + this.exportComponentLength + " }," + Msg.eol);
            this.packages.append(Msg.eol);
            String mapTo = this.getMapEntry(p.getName());
            if (mapTo != null) {
                this.defineList.append("#define " + mapTo + " " + this.npackages + "\t/* " + p.getName() + " */" + Msg.eol);
            }
            ++this.npackages;
            Enumeration f = p.appletElements();
            while (f.hasMoreElements()) {
                AppletDeclarator applet = (AppletDeclarator)f.nextElement();
                byte[] appletAid = applet.getAid().toByteArray();
                int addr = applet.resolve().getRelocAddr();
                this.applets.append("{ " + this.packageDirectory.indexOf(pid) + ", { " + appletAid.length + ", { ");
                this.applets.append(String.valueOf(Msg.toHexString(appletAid, ", ")) + ", ");
                this.applets.append(" } }, " + Msg.toHexString((short)addr) + " }," + Msg.eol);
                ++this.napplets;
            }
            Enumeration f2 = p.classElements();
            while (f2.hasMoreElements()) {
                void var14_16;
                void var13_15;
                int i;
                Enumeration g;
                int flags;
                JCClass c = (JCClass)f2.nextElement();
                if (!suppressExportComponent) {
                    export.add(c);
                }
                this.rom.append(String.valueOf(Msg.eol) + "/* class@" + Msg.toHexString((short)c.getRelocAddr()) + ": " + Modifier.toString(c.getAttributes()) + " " + c.getName() + " */" + Msg.eol);
                mapTo = this.getMapEntry(c.getName());
                if (mapTo != null) {
                    this.defineList.append("#define " + mapTo + " " + Msg.toHexString((short)c.getRelocAddr()) + "\t/* " + c.getName() + " */" + Msg.eol);
                }
                int n = flags = c.isShareable() ? 64 : 0;
                if (Modifier.isInterface(c.getAttributes())) {
                    int superCount = c.superInterfaceVector.size();
                    this.rom.append(String.valueOf(Msg.toHexString((byte)((flags |= 0x80) | superCount & 0xF))) + ", ");
                    ++this.romLength;
                    g = c.superInterfaceVector.elements();
                    while (g.hasMoreElements()) {
                        SuperInterface si = (SuperInterface)g.nextElement();
                        int addr = si.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
                        this.rom.append("LOW(" + Msg.toHexString((short)addr) + "), ");
                        this.romLength += 2;
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append(String.valueOf(Msg.toHexString((byte)(flags | c.interfaceVector.size() & 0xF))) + ", ");
                ++this.romLength;
                JCClass superClass = c.getSuperClass();
                if (superClass == null) {
                    this.rom.append(String.valueOf(Msg.toHexString((byte)-1)) + ", ");
                    this.rom.append(String.valueOf(Msg.toHexString((byte)-1)) + ", ");
                    this.romLength += 2;
                } else {
                    this.rom.append("HIGH(" + Msg.toHexString((short)superClass.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)superClass.getRelocAddr()) + "), ");
                    this.romLength += 2;
                }
                JCClass currentClass = c;
                int instanceSize = 0;
                while (currentClass != null) {
                    instanceSize += currentClass.getInstanceSize();
                    currentClass = currentClass.getSuperClass();
                }
                this.rom.append(String.valueOf(Msg.toHexString((byte)instanceSize)) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)c.getFirstReferenceToken())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)c.getReferenceCount())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)c.publicMethodTable.getBase())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)c.publicMethodTable.getCount())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)c.packageMethodTable.getBase())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)c.packageMethodTable.getCount())) + ", ");
                this.rom.append(Msg.eol);
                this.romLength += 7;
                Enumeration g2 = c.publicMethodTable.elements();
                while (g2.hasMoreElements()) {
                    JCMethod m = (JCMethod)g2.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)m.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)m.getRelocAddr()) + "),\t\t/* " + m.getName() + " */" + Msg.eol);
                    this.romLength += 2;
                }
                Enumeration g3 = c.packageMethodTable.elements();
                while (g3.hasMoreElements()) {
                    JCMethod m = (JCMethod)g3.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)m.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)m.getRelocAddr()) + "),\t\t/* " + m.getName() + " */" + Msg.eol);
                    this.romLength += 2;
                }
                Enumeration g4 = c.interfaceVector.elements();
                while (g4.hasMoreElements()) {
                    InterfaceTable itbl = (InterfaceTable)g4.nextElement();
                    byte[] table = itbl.toByteArray();
                    int addr = itbl.resolve().getRelocAddr();
                    this.rom.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)addr) + "), ");
                    this.romLength += 2;
                    i = 2;
                    while (i < table.length) {
                        this.rom.append(String.valueOf(table[i]) + ", ");
                        ++this.romLength;
                        ++i;
                    }
                    this.rom.append(Msg.eol);
                }
                Enumeration g5 = c.fieldElements();
                while (var13_15.hasMoreElements()) {
                    Field field = (Field)g5.nextElement();
                    int mod = field.getAttributes();
                    if (Modifier.isStatic(mod) && !Modifier.isFinal(mod) && (mapTo = this.getMapEntry(field.getName())) != null) {
                        this.defineList.append("#define " + mapTo + " " + Msg.toHexString((short)field.getRelocAddr()) + "\t/* " + field.getName() + " */" + Msg.eol);
                    }
                    if (!Modifier.isStatic(mod) && (mapTo = this.getMapEntry(field.getName())) != null) {
                        this.defineList.append("#define " + mapTo + " " + field.getFieldIdentifier().getFieldToken() + "\t/* " + field.getName() + " */" + Msg.eol);
                    }
                    if (!Modifier.isStatic(mod)) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    StaticFieldInitializer init = field.getFieldInitializer();
                    if (init != null && init.isPrimitive()) {
                        int data = init.getPrimitiveData();
                        switch (field.size()) {
                            case 1: {
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)data)) + ",");
                                ++this.nonZeroStaticInitSize;
                                break;
                            }
                            case 2: {
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(data >> 8))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)data)) + ",");
                                this.nonZeroStaticInitSize += 2;
                                break;
                            }
                            case 4: {
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(data >> 24))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(data >> 16))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(data >> 8))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)data)) + ",");
                                this.nonZeroStaticInitSize += 4;
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                        this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toHexString((short)field.getRelocAddr()) + " */" + Msg.eol);
                        continue;
                    }
                    if (init != null && !init.isPrimitive()) {
                        byte[] obj;
                        int addr = field.getRelocAddr() + 2;
                        this.staticInit.append(String.valueOf(Msg.toHexString((byte)(addr >> 8))) + ", ");
                        this.staticInit.append(String.valueOf(Msg.toHexString((byte)addr)) + ",");
                        this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toHexString((short)field.getRelocAddr()) + " */" + Msg.eol);
                        this.nonZeroStaticInitSize += 2;
                        String descStr = descriptor.getDescriptorString();
                        int[] data = init.getArrayData();
                        if (descStr.equals("[B")) {
                            obj = new byte[data.length + 6];
                            obj[0] = -128;
                            addr = ((JCClass)r.classSymbolTable.get("[B")).getRelocAddr();
                            i = 0;
                            while (i < data.length) {
                                obj[6 + i] = (byte)data[i];
                                ++i;
                            }
                        } else if (descStr.equals("[Z")) {
                            obj = new byte[data.length + 6];
                            obj[0] = 96;
                            addr = ((JCClass)r.classSymbolTable.get("[Z")).getRelocAddr();
                            i = 0;
                            while (i < data.length) {
                                obj[6 + i] = (byte)data[i];
                                ++i;
                            }
                        } else if (descStr.equals("[S")) {
                            obj = new byte[data.length * 2 + 6];
                            obj[0] = -96;
                            addr = ((JCClass)r.classSymbolTable.get("[S")).getRelocAddr();
                            i = 0;
                            while (i < data.length) {
                                obj[6 + i * 2] = (byte)(data[i] >> 8);
                                obj[6 + i * 2 + 1] = (byte)data[i];
                                ++i;
                            }
                        } else if (descStr.equals("[I")) {
                            obj = new byte[data.length * 4 + 6];
                            obj[0] = -64;
                            addr = ((JCClass)r.classSymbolTable.get("[I")).getRelocAddr();
                            i = 0;
                            while (i < data.length) {
                                obj[6 + i * 4] = (byte)(data[i] >> 24);
                                obj[6 + i * 4 + 1] = (byte)(data[i] >> 16);
                                obj[6 + i * 4 + 2] = (byte)(data[i] >> 8);
                                obj[6 + i * 4 + 3] = (byte)data[i];
                                ++i;
                            }
                        } else {
                            throw new InternalError();
                        }
                        obj[1] = (byte)(this.packageDirectory.indexOf(pid) << 4);
                        obj[2] = (byte)(addr >> 8);
                        obj[3] = (byte)addr;
                        obj[4] = (byte)(data.length >> 8);
                        obj[5] = (byte)data.length;
                        this.staticInit.append(String.valueOf(Msg.toHexString(obj, ", ")) + "," + Msg.eol);
                        this.nonZeroStaticInitSize += obj.length;
                        continue;
                    }
                    switch (field.size()) {
                        case 1: {
                            ++this.zeroStaticInitSize;
                            break;
                        }
                        case 2: {
                            this.zeroStaticInitSize += 2;
                            break;
                        }
                        case 4: {
                            this.zeroStaticInitSize += 4;
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toHexString((short)field.getRelocAddr()) + " */" + Msg.eol);
                }
                g = c.methodElements();
                while (var14_16.hasMoreElements()) {
                    JCMethod m = (JCMethod)var14_16.nextElement();
                    mapTo = this.getMapEntry(m.getName());
                    if (mapTo != null) {
                        this.defineList.append("#define " + mapTo + " " + Msg.toHexString((short)m.getRelocAddr()) + "\t/* " + m.getName() + " */" + Msg.eol);
                    }
                    this.rom.append(String.valueOf(Msg.eol) + "/* method@" + Msg.toHexString((short)m.getRelocAddr()) + ": " + Modifier.toString(m.getAttributes()) + " " + m.getName() + " */" + Msg.eol);
                    byte[] methodHeader = m.getMethodHeader();
                    this.rom.append(String.valueOf(Msg.toHexString(methodHeader, ", ")) + ", " + Msg.eol);
                    this.romLength += methodHeader.length;
                    if (Modifier.isAbstract(m.getAttributes())) continue;
                    if (Modifier.isNative(m.getAttributes())) {
                        int tag = m.getRelocAddr();
                        this.rom.append(String.valueOf(Msg.toHexString((byte)(tag >> 8))) + ", " + Msg.toHexString((byte)tag) + ", " + Msg.eol);
                        this.romLength += 2;
                        continue;
                    }
                    Enumeration h = m.statementElements();
                    while (h.hasMoreElements()) {
                        Statement s = (Statement)h.nextElement();
                        this.format(s, m);
                        this.rom.append(", " + Msg.eol);
                    }
                    ExceptionTable exTbl = m.getExceptionTable();
                    if (exTbl == null) continue;
                    Enumeration h2 = exTbl.elements();
                    while (h2.hasMoreElements()) {
                        ExceptionTableEntry entry = (ExceptionTableEntry)h2.nextElement();
                        short start = (short)entry.getStartOffset();
                        short activeLength = (short)entry.getActiveLength();
                        if (entry.isOuterMost()) {
                            activeLength = (short)(activeLength | 0x8000);
                        }
                        short handlerOffset = (short)entry.getHandlerOffset();
                        short catchIndex = (short)entry.getCatchIndex();
                        this.exceptionTable.append(String.valueOf(this.formatBigEndian(start)) + ", " + this.formatBigEndian(activeLength) + ", " + this.formatBigEndian(handlerOffset) + ", " + this.formatBigEndian(catchIndex) + ", " + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            byte[] exportComponentByteArray = export.toByteArray();
            this.exportComponent.append("/* " + p.getName() + " */" + Msg.eol);
            int i = 0;
            while (i < exportComponentByteArray.length) {
                this.exportComponent.append(String.valueOf(Msg.toHexString(exportComponentByteArray[i])) + ", ");
                if (i % 8 == 7) {
                    this.exportComponent.append(Msg.eol);
                }
                ++i;
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += exportComponentByteArray.length;
        }
        this.defineList.append(Msg.eol);
        this.defineList.append("#define EXPORT_COMPONENT_BASE " + Msg.toHexString((short)(this.m_romBase + this.romLength)) + Msg.eol);
        this.romLength += this.exportComponentLength;
        short initialExceptionTable = (short)(this.m_romBase + this.romLength);
        this.romLength += 1 + 8 * this.nExceptionEntries;
        this.defineList.append("#define INITIAL_EXCEPTION_TABLE_LIST " + Msg.toHexString((short)(this.m_romBase + this.romLength)) + Msg.eol);
        this.exceptionTable.append("/* Initial exception table list */" + Msg.eol);
        this.exceptionTable.append(String.valueOf(this.formatBigEndian((short)0)) + ", " + this.formatBigEndian(initialExceptionTable) + ", " + Msg.eol);
        this.romLength += 4;
        this.defineList.append("#define ROMSIZE " + this.romLength + Msg.eol);
        this.defineList.append("#define NON_ZERO_STATIC_FIELD_SIZE " + this.nonZeroStaticInitSize + Msg.eol);
        this.defineList.append("#define ZERO_STATIC_FIELD_SIZE " + this.zeroStaticInitSize + Msg.eol);
        this.defineList.append("#define NAPPLETS " + this.napplets + Msg.eol);
        this.defineList.append("#define NPACKAGES " + this.npackages + Msg.eol);
    }

    public void write(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/jcasm/MessagesBundle");
        Object[] arguments = new Object[]{new Integer(0), new Integer(55)};
        pw.println("/*");
        pw.println(" * " + MessageFormat.format(messages.getString("crefbanner.1"), null));
        pw.println(" *");
        pw.println(" * " + MessageFormat.format(messages.getString("crefbanner.2"), null));
        pw.println(" * " + MessageFormat.format(messages.getString("maskMain.0"), arguments));
        pw.println(" * " + MessageFormat.format(messages.getString("main.2"), null));
        pw.println(" */");
        pw.println(" ");
        pw.println("#ifdef __MASK_HEADER__" + Msg.eol);
        pw.println(this.defineList.toString());
        pw.println("#else" + Msg.eol);
        pw.println(this.preamble.toString());
        pw.println("ROM_ARRAY(u8, rommask) = {");
        pw.println(this.rom.toString());
        pw.println("/* Export components of masked packages */");
        pw.println(this.exportComponent.toString());
        pw.println("/* Initial exception table */");
        pw.println(String.valueOf(this.nExceptionEntries) + ", ");
        pw.println(this.exceptionTable);
        pw.println("};");
        pw.println("ROM_ARRAY(u8, staticinit) = {");
        if (this.staticInit.length() == 0) {
            pw.println(" NULL ");
        } else {
            pw.print(this.staticInit.toString());
        }
        pw.println("};");
        pw.println("ROM_ARRAY(struct applet, applets) = {");
        if (this.applets.length() == 0) {
            pw.println(" NULL ");
        } else {
            pw.print(this.applets.toString());
        }
        pw.println("};" + Msg.eol);
        pw.println("#if POST_ISSUANCE_INSTALL");
        pw.println("ROM_ARRAY(struct package, packages) = {");
        pw.print(this.packages.toString());
        pw.println("};" + Msg.eol);
        pw.println("#endif /* __POST_ISSUANCE_INSTALL__ */");
        pw.println("#endif /* __MASK_HEADER__ */" + Msg.eol);
        pw.flush();
    }
}

