/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import com.sun.javacard.jcfile.JcPackage;

public class JcClass
extends ClassDefinition {
    private boolean interface_type;
    private boolean shareable_type;
    private String[] public_super_classes;
    private String[] super_interfaces;
    private String[] public_super_interfaces;
    private JcField[] fields;
    private JcMethod[] methods;
    private JcMethodTable public_method_table;
    private JcMethodTable package_method_table;
    private int declared_instance_size;
    private int first_reference_token;
    private int reference_count = 0;
    private JcImplementedInterfaceInfo[] implemented_interface_infos;
    private EfClass efClass;

    public JcClass(ClassDefinition this_class) {
        super(this_class);
        this.access_flags &= 0xFFFFFFDF;
    }

    public int getDeclaredInstanceSize() {
        return this.declared_instance_size;
    }

    public EfClass getEfClass() {
        return this.efClass;
    }

    public JcField getField(String name, String descriptor) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].getFieldName().equals(name) && this.fields[i].getFieldDescriptor().equals(descriptor)) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public JcField[] getFields() {
        return this.fields;
    }

    public int getFirstReferenceToken() {
        return this.first_reference_token;
    }

    public JcImplementedInterfaceInfo[] getImplementedInterfaceInfos() {
        return this.implemented_interface_infos;
    }

    public JcMethod getMethod(String signature) {
        int index = signature.indexOf("(");
        if (index == -1) {
            return null;
        }
        String method_name = signature.substring(0, index);
        String descriptor = signature.substring(index, signature.length());
        return this.getMethod(method_name, descriptor);
    }

    public JcMethod getMethod(String method_name, String descriptor) {
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].getMethodName().equals(method_name) && this.methods[i].getMethodDescriptor().equals(descriptor)) {
                return this.methods[i];
            }
            ++i;
        }
        return null;
    }

    public JcMethod[] getMethods() {
        return this.methods;
    }

    public JcMethodTable getPackageMethodTable() {
        return this.package_method_table;
    }

    public JcMethodTable getPublicMethodTable() {
        return this.public_method_table;
    }

    public String[] getPublicSuperClasses() {
        return this.public_super_classes;
    }

    public String[] getPublicSuperInterfaces() {
        return this.public_super_interfaces;
    }

    public int getReferenceCount() {
        return this.reference_count;
    }

    public String[] getSuperInterfaces() {
        return this.super_interfaces;
    }

    public boolean hasProtectedMethods() {
        JcMethod[] md = this.getMethods();
        int i = 0;
        while (i < md.length) {
            if (md[i].isProtected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasPublicMethods() {
        JcMethod[] md = this.getMethods();
        int i = 0;
        while (i < md.length) {
            if (md[i].isPublic()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isAPIElement(JcPackage jc_package) {
        if (jc_package.isLibraryPackage() && this.isPublic()) {
            return true;
        }
        return jc_package.isAppletPackage() && this.isPublic() && this.isShareableType() && this.isInterfaceType();
    }

    public boolean isApplet() {
        int i = 0;
        while (i < this.public_super_classes.length) {
            if (this.public_super_classes[i].equals("javacard/framework/Applet")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInterfaceType() {
        return this.interface_type;
    }

    public boolean isShareableType() {
        return this.shareable_type;
    }

    public void printFields() {
        System.out.println("\n Fields of " + this.getClassName() + " (as read from *.class files)");
        int i = 0;
        while (i < this.fields.length) {
            JcField f = this.fields[i];
            String s = i + " " + f.getFieldToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + f.getFieldDescriptor() + " " + f.getFieldName();
            System.out.println(s);
            ++i;
        }
    }

    public void printMethods() {
        System.out.println("\n Methods of " + this.getClassName() + " (as read from *.class files)");
        int i = 0;
        while (i < this.methods.length) {
            JcMethod f = this.methods[i];
            String s = i + " " + f.getMethodToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + (f.isAbstract() ? "abstract" : "") + " " + f.getMethodDescriptor() + " " + f.getMethodName();
            System.out.println(s);
            ++i;
        }
        System.out.println("\n Methods of " + this.getClassName() + " (in its PUBLIC method table)");
        int i2 = 0;
        while (i2 < this.public_method_table.getMethods().length) {
            MethodDefinition f = this.public_method_table.getMethods()[i2];
            String s = i2 + " " + f.getMethodToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + (f.isAbstract() ? "abstract" : "") + " " + f.getMethodDescriptor() + " " + f.getMethodName();
            System.out.println(s);
            ++i2;
        }
        System.out.println("\n Methods of " + this.getClassName() + " (in its PACKAGE method table)");
        int i3 = 0;
        while (i3 < this.package_method_table.getMethods().length) {
            MethodDefinition f = this.package_method_table.getMethods()[i3];
            String s = i3 + " " + f.getMethodToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + (f.isAbstract() ? "abstract" : "") + " " + f.getMethodDescriptor() + " " + f.getMethodName();
            System.out.println(s);
            ++i3;
        }
    }

    public void setDeclaredInstanceSize(int size) {
        this.declared_instance_size = size;
    }

    public void setEfClass(EfClass efc) {
        this.efClass = efc;
    }

    public void setFields(JcField[] fields) {
        this.fields = fields;
    }

    public void setFirstReferenceToken(int token) {
        this.first_reference_token = token;
    }

    public void setImplementedInterfaceInfos(JcImplementedInterfaceInfo[] interface_infos) {
        this.implemented_interface_infos = interface_infos;
    }

    public void setInterfaceType(boolean flag) {
        this.interface_type = flag;
    }

    public void setMethods(JcMethod[] methods) {
        this.methods = methods;
    }

    public void setPackageMethodTable(JcMethodTable package_method_table) {
        this.package_method_table = package_method_table;
    }

    public void setPublicMethodTable(JcMethodTable public_method_table) {
        this.public_method_table = public_method_table;
    }

    public void setPublicSuperClasses(String[] super_classes) {
        this.public_super_classes = super_classes;
    }

    public void setPublicSuperInterfaces(String[] interfaces) {
        this.public_super_interfaces = interfaces;
    }

    public void setReferenceCount(int count) {
        this.reference_count = count;
    }

    public void setShareableType(boolean flag) {
        this.shareable_type = flag;
    }

    public void setSuperInterfaces(String[] interfaces) {
        this.super_interfaces = interfaces;
    }
}

