/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.CustomComponent;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.BitSet;

class DirectoryComponent
extends Safeptr {
    private short componentCount = (short)12;

    DirectoryComponent(byte[] byArray) {
        super(byArray, "Directory");
    }

    int componentSize(int n) {
        return this.u2((n - 1) * 2);
    }

    int imageSize() {
        return this.u2(this.componentCount * 2);
    }

    int arrayInitCount() {
        return this.u2(this.componentCount * 2 + 2);
    }

    int arrayInitSize() {
        return this.u2(this.componentCount * 2 + 4);
    }

    int importCount() {
        return this.u1(this.componentCount * 2 + 6);
    }

    int appletCount() {
        return this.u1(this.componentCount * 2 + 7);
    }

    int customCount() {
        return this.u1(this.componentCount * 2 + 8);
    }

    CustomComponent customComps() {
        return new CustomComponent(this.offset(this.componentCount * 2 + 9));
    }

    void verify() {
        int n;
        if (Verifier.verbose >= 2) {
            Messages.println("DirectoryComponent.100");
        }
        Safeptr[] safeptrArray = new Safeptr[]{null, Cap.Header, Cap.Directory, Cap.Applet, Cap.Import, Cap.ConstantPool, Cap.Class, Cap.Method, Cap.StaticField, Cap.ReferenceLocation, Cap.Export, Cap.Descriptor, Cap.Debug};
        String[] stringArray = new String[]{null, "Header", "Directory", "Applet", "Import", "ConstantPool", "Class", "Method", "StaticField", "ReferenceLocation", "Export", "Descriptor", "Debug"};
        if (Cap.capMinorVersion < 2) {
            this.componentCount = (short)11;
        }
        int n2 = 1;
        while (n2 <= this.componentCount) {
            int n3;
            Safeptr safeptr = safeptrArray[n2];
            int n4 = n3 = safeptr == null ? 0 : safeptr.size();
            if (n3 != this.componentSize(n2)) {
                throw new VerifierError("DirectoryComponent.1", (Object)stringArray[n2], this.componentSize(n2), n3);
            }
            ++n2;
        }
        if (this.imageSize() != Cap.StaticField.imageSize()) {
            throw new VerifierError("DirectoryComponent.2", Cap.StaticField.imageSize(), this.imageSize());
        }
        if (this.arrayInitCount() != Cap.StaticField.arrayInitCount()) {
            throw new VerifierError("DirectoryComponent.3", Cap.StaticField.arrayInitCount(), this.arrayInitCount());
        }
        int n5 = 0;
        InitializedArray initializedArray = Cap.StaticField.arrayInit();
        int n6 = Cap.StaticField.arrayInitCount();
        while (n6 > 0) {
            n5 += initializedArray.count();
            initializedArray.next();
            --n6;
        }
        if (this.arrayInitSize() != n5) {
            throw new VerifierError("DirectoryComponent.4", n5, this.arrayInitSize());
        }
        if (this.importCount() != Cap.Import.count()) {
            throw new VerifierError("DirectoryComponent.5", Cap.Import.count(), this.importCount());
        }
        int n7 = n = Cap.Applet == null ? 0 : Cap.Applet.count();
        if (this.appletCount() != n) {
            throw new VerifierError("DirectoryComponent.6", n, this.appletCount());
        }
        BitSet bitSet = new BitSet(256);
        CustomComponent customComponent = this.customComps();
        int n8 = this.customCount();
        while (n8 > 0) {
            int n9 = customComponent.componentTag();
            if (n9 < 128 || n9 > 255) {
                throw new VerifierError("DirectoryComponent.8", n9);
            }
            if (bitSet.get(n9)) {
                throw new VerifierError("DirectoryComponent.9", n9);
            }
            bitSet.set(n9);
            if (!AID.isValid(customComponent)) {
                throw new VerifierError("DirectoryComponent.12", customComponent.AID_length(), n9);
            }
            Safeptr safeptr = Cap.customComponent(n9);
            if (safeptr == null) {
                throw new VerifierError("DirectoryComponent.10", n9);
            }
            if (customComponent.componentSize() != safeptr.size()) {
                throw new VerifierError("DirectoryComponent.11", n9, safeptr.size(), customComponent.componentSize());
            }
            customComponent.next();
            --n8;
        }
        if (!customComponent.atComponentEnd()) {
            throw new VerifierError("DirectoryComponent.14");
        }
    }
}

