/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfAttribute;
import com.sun.javacard.offcardverifier.exportfile.EfAttributeConstantValue;
import com.sun.javacard.offcardverifier.exportfile.EfAttributeGeneric;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;

public class EfField
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    int descriptorIndex;
    public EfAttribute[] attributes;
    private boolean sameVersion;
    private String parentClassName;
    private static final int validFlags = 29;
    private static final int staticFinalFlags = 24;
    private static final int publicProtectedFlags = 5;

    EfField(ExportFile exportFile, String string) {
        super(exportFile);
        this.parentClassName = string;
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.nameIndex);
        this.descriptorIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.descriptorIndex);
        int n = this.ef.in.readUnsignedShort();
        this.attributes = new EfAttribute[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.ef.in.readUnsignedShort();
            int n4 = this.ef.in.readInt();
            this.ef.checkUtf8Index(n3);
            String string = ((EfConstant_Utf8)this.ef.constantPool[n3]).contents;
            EfAttribute efAttribute = string.equals("ConstantValue") ? new EfAttributeConstantValue(this.ef) : new EfAttributeGeneric(this.ef);
            efAttribute.attributeNameIndex = n3;
            efAttribute.attributeLength = n4;
            efAttribute.read();
            this.attributes[n2] = efAttribute;
            ++n2;
        }
    }

    public String name() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
    }

    public String sig() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.descriptorIndex]).contents;
    }

    EfAttributeConstantValue constantvalue() {
        int n = 0;
        while (n < this.attributes.length) {
            if (this.attributes[n] instanceof EfAttributeConstantValue) {
                return (EfAttributeConstantValue)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public boolean isInlined() {
        String string = this.sig();
        return (this.accessFlag & 0x18) == 24 && (string.equals("B") || string.equals("I") || string.equals("S") || string.equals("Z"));
    }

    public boolean isStatic() {
        return (this.accessFlag & 8) != 0;
    }

    public int wordSize() {
        if (this.sig().equals("I")) {
            return 2;
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    void verify(boolean var1_1, HashSet var2_2, BitSet var3_3, BitSet var4_4) {
        block18: {
            if (!EfNames.validFieldName(this.name())) {
                throw new VerifierError("EfField.5", this.name());
            }
            if (!EfNames.validFieldDescriptor(this.sig())) {
                throw new VerifierError("EfField.6", this.sig());
            }
            try {
                block19: {
                    if ((this.accessFlag & -30) != 0) {
                        throw new VerifierError("EfField.1", this.accessFlag);
                    }
                    if ((this.accessFlag & 5) == 5) {
                        throw new VerifierError("EfField.2");
                    }
                    if ((this.accessFlag & 5) == 0) {
                        throw new VerifierError("EfField.3");
                    }
                    if (var1_1 && (this.accessFlag & 24) != 24) {
                        throw new VerifierError("EfField.4");
                    }
                    if (!this.isInlined()) {
                        if (this.attributes.length != 0) {
                            throw new VerifierError("EfField.7");
                        }
                    } else {
                        if (this.attributes.length != 1 || !(this.attributes[0] instanceof EfAttributeConstantValue)) {
                            throw new VerifierError("EfField.8");
                        }
                        var5_5 = this.constantvalue();
                        var5_5.verify(this.sig());
                    }
                    if (!var2_2.add(this)) {
                        throw new VerifierError("EfField.9");
                    }
                    if (this.isInlined()) {
                        if (this.token != 255) {
                            throw new VerifierError("EfField.10");
                        }
                        break block18;
                    }
                    v0 = var5_5 = this.isStatic() != false ? var3_3 : var4_4;
                    if (var5_5.get(this.token)) {
                        throw new VerifierError("EfField.11", this.token);
                    }
                    if (this.isStatic()) break block19;
                    var6_7 = var2_2.iterator();
                    if (EfNames.isFieldReferenceType(this.sig())) ** GOTO lbl-1000
                    if (this.token == 255) break block19;
                    while (var6_7.hasNext()) {
                        var7_8 = (EfField)var6_7.next();
                        if (var7_8.isStatic() || !EfNames.isFieldReferenceType(var7_8.sig()) || var7_8.token > this.token) continue;
                        throw new VerifierError("EfField.13");
                    }
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        var7_9 = (EfField)var6_7.next();
                        if (var7_9.isStatic() || EfNames.isFieldReferenceType(var7_9.sig()) || var7_9.token == 255 || var7_9.token < this.token) continue;
                        throw new VerifierError("EfField.13");
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** while (var6_7.hasNext())
                    }
                }
                var5_5.set(this.token);
            }
            catch (VerifierError var5_6) {
                throw new VerifierError("EfField.12", (Object)this, (Object)var5_6.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof EfField)) {
            return false;
        }
        EfField efField = (EfField)object;
        return this.name().equals(efField.name()) && this.sig().equals(efField.sig());
    }

    public String toString() {
        return EfNames.prettyField(this.name(), this.sig());
    }

    public void compareTo(EfField efField) {
        this.sameVersion = false;
        this.compareCommon(efField);
        if ((this.accessFlag & 1) > (efField.accessFlag & 1)) {
            throw new VerifierError("RevisionError.29", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) < (efField.accessFlag & 4)) {
            throw new VerifierError("RevisionError.29", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) < (efField.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.33", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void checkEquality(EfField efField) {
        this.sameVersion = true;
        this.compareCommon(efField);
        if ((this.accessFlag & 1) != (efField.accessFlag & 1)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) != (efField.accessFlag & 4)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) != (efField.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void compareCommon(EfField efField) {
        if (this.token != efField.token) {
            throw new VerifierError("RevisionError.31", (Object)this.name(), (Object)this.parentClassName);
        }
        if (!this.sig().equals(efField.sig())) {
            throw new VerifierError("RevisionError.32", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 8) != (efField.accessFlag & 8)) {
            throw new VerifierError("RevisionError.39", (Object)this.name(), (Object)this.parentClassName);
        }
        EfAttributeConstantValue efAttributeConstantValue = this.constantvalue();
        EfAttributeConstantValue efAttributeConstantValue2 = efField.constantvalue();
        if (efAttributeConstantValue == null && efAttributeConstantValue2 != null) {
            throw new VerifierError("RevisionError.33", (Object)this.name(), (Object)this.parentClassName);
        }
        if (efAttributeConstantValue != null && efAttributeConstantValue2 == null) {
            throw new VerifierError("RevisionError.34", (Object)this.name(), (Object)this.parentClassName);
        }
        if (efAttributeConstantValue != null && efAttributeConstantValue.value() != efAttributeConstantValue2.value()) {
            throw new VerifierError("RevisionError.35", (Object)efField.name(), (Object)this.parentClassName);
        }
    }
}

