/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JLineNumberRecord;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class JLineNumberTableAttr
extends JAttribute {
    private JLineNumberRecord[] records;

    JLineNumberRecord[] getJLineNumberRecords() {
        return this.records;
    }

    JLineNumberTableAttr(JConstantPool cp) {
        super(cp);
    }

    public void parse(DataInputStream dis) throws IOException {
        int attri_length = dis.readInt();
        int length = dis.readUnsignedShort();
        this.records = new JLineNumberRecord[length];
        for (int i = 0; i < length; ++i) {
            int pc = dis.readUnsignedShort();
            int line_number = dis.readUnsignedShort();
            this.records[i] = new JLineNumberRecord(pc, line_number);
        }
    }

    public int getLineNumber(int pc) {
        int line_number = -1;
        int distance = -1;
        for (int i = 0; i < this.records.length; ++i) {
            JLineNumberRecord record = this.records[i];
            if (record.getStartPc() > pc) continue;
            if (distance == -1) {
                distance = pc - record.getStartPc();
                line_number = record.getSourceLineNumber();
                continue;
            }
            if (pc - record.getStartPc() >= distance) continue;
            distance = pc - record.getStartPc();
            line_number = record.getSourceLineNumber();
        }
        return line_number;
    }
}

