/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.Converter;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.ParseException;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcasm.cap.CapFile;
import com.sun.javacard.jcasm.cap.CapGenWrapperException;
import com.sun.javacard.jcasm.cap.CapLinker;
import com.sun.javacard.jcasm.cap.ErrorTranslator;
import com.sun.javacard.offcardverifier.Verifier;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;

public class CapgenWrapper {
    public static void generateCAPFile(ConversionProfile cp, Converter converter) throws Exception {
        ConversionProfile conversion_profile = cp;
        File output_file = null;
        File input_file = null;
        Globals.mode = 1;
        String jca_file_name = Names.getJcaFileName(conversion_profile.package_profile.package_name);
        input_file = new File(conversion_profile.getFullOutputPath(), jca_file_name);
        String cap_file_name = Names.getCAPFileName(conversion_profile.package_profile.package_name);
        output_file = new File(conversion_profile.getFullOutputPath(), cap_file_name);
        Parser parser = null;
        boolean verifierError = false;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(input_file));
            parser = new Parser(bis);
            Parser.inputSpec = input_file.getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            Object[] arguments = new Object[]{input_file.getName()};
            Msg.error("main.16", arguments);
            String dir = conversion_profile.getFullOutputPath().getAbsolutePath();
            throw new CapGenWrapperException();
        }
        JCPackage pack = null;
        try {
            pack = parser.PackageDeclaration();
        }
        catch (ParseException e) {
            System.err.println(e);
            ++Globals.errors;
        }
        CapFile cap = null;
        if (Globals.errors == 0) {
            cap = new CapFile(pack);
        }
        if (Globals.errors == 0) {
            CapLinker.link(pack);
        }
        if (Globals.errors == 0) {
            try {
                cap.gen(output_file);
                if (!conversion_profile.noVerify) {
                    File thisExpFile;
                    if (conversion_profile.this_exp_provided) {
                        ExportFileManager expM = converter.getExportFileManager();
                        expM.load(conversion_profile.package_profile.package_name);
                    }
                    if ((thisExpFile = new File(conversion_profile.getFullOutputPath(), Names.getExportFileName(conversion_profile.package_profile.package_name))).exists() && Globals.errors == 0) {
                        CapgenWrapper.callVerifier(converter, output_file, pack.getName(), thisExpFile);
                    }
                } else {
                    Notifier.progress("converter.11");
                }
            }
            catch (Exception e) {
                ++Globals.errors;
                ErrorTranslator et = ErrorTranslator.getTranslator(e, cap.getCapGen(), converter.getExportFileManager(), converter);
                if (et != null) {
                    System.err.println(et);
                } else {
                    int index = e.toString().indexOf("com.sun.javacard.offcardverifier.VerifierError:");
                    String str = null;
                    str = index != -1 ? Msg.getMessage("ver.err") + e.toString().substring(index + 47) : e.toString();
                    System.err.println(str);
                }
                verifierError = true;
            }
        }
        if (Globals.errors != 0) {
            output_file.delete();
            Notifier.newLine();
            String dir = conversion_profile.getFullOutputPath().getAbsolutePath();
            if (verifierError && !conversion_profile.noVerify) {
                Notifier.out("error.3");
            } else {
                Notifier.out("error.4");
            }
            throw new CapGenWrapperException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void callVerifier(Converter converter, File outFile, String packageName, File thisExpFile) throws Exception {
        if (converter == null) {
            Notifier.warning("converter.10");
            return;
        }
        ExportFileManager expM = converter.getExportFileManager();
        expM.getExportFile("java/lang");
        Vector exps = expM.getJavaExportFiles();
        if (thisExpFile != null) {
            exps.addElement(thisExpFile);
        }
        FileInputStream fis = new FileInputStream(outFile);
        try {
            Verifier.verifyCap((FileInputStream)fis, (String)packageName, (Vector)exps);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
    }
}

