/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import java.util.Vector;

public class JcImportTokenTable {
    public static final byte PACKAGE = 0;
    public static final byte CLASS = 1;
    public static final byte METHOD = 2;
    public static final byte FIELD = 3;
    Vector token_table = new Vector(20);
    PackageDefinition[] import_packages;

    public JcImportTokenTableEntry addPackageEntry(String package_name) {
        int token = -1;
        int i = 0;
        while (i < this.token_table.size()) {
            JcImportTokenTableEntry entry = (JcImportTokenTableEntry)this.token_table.elementAt(i);
            if (entry.getType() == 0) {
                token = entry.getToken();
                if (entry.getName().equals(package_name)) {
                    return entry;
                }
            }
            ++i;
        }
        JcImportTokenTableEntry new_package_entry = new JcImportTokenTableEntry(0, package_name, token + 1);
        this.token_table.addElement(new_package_entry);
        return new_package_entry;
    }

    public JcImportTokenTableEntry addClassEntry(String class_name, int class_token) {
        JcImportTokenTableEntry class_entry = this.getClassEntry(class_name);
        if (class_entry != null) {
            return class_entry;
        }
        String package_name = Names.getPackageName(class_name);
        JcImportTokenTableEntry package_entry = this.addPackageEntry(package_name);
        int token = package_entry.getToken() << 8 | class_token & 0xFF;
        JcImportTokenTableEntry new_class_entry = new JcImportTokenTableEntry(1, class_name, token);
        this.token_table.addElement(new_class_entry);
        return new_class_entry;
    }

    public JcImportTokenTableEntry addMethodEntry(String class_name, int class_token, String method_name, String descriptor, int method_token) {
        JcImportTokenTableEntry method_entry = this.getMethodEntry(class_name, method_name, descriptor);
        if (method_entry != null) {
            return method_entry;
        }
        JcImportTokenTableEntry class_entry = this.addClassEntry(class_name, class_token);
        int token = class_entry.getToken() << 8 | method_token & 0xFF;
        JcImportTokenTableEntry new_method_entry = new JcImportTokenTableEntry(2, class_name + "/" + method_name + descriptor, token);
        this.token_table.addElement(new_method_entry);
        return new_method_entry;
    }

    public JcImportTokenTableEntry addFieldEntry(String class_name, int class_token, String field_name, int field_token) {
        JcImportTokenTableEntry field_entry = this.getFieldEntry(class_name, field_name);
        if (field_entry != null) {
            return field_entry;
        }
        JcImportTokenTableEntry class_entry = this.addClassEntry(class_name, class_token);
        int token = class_entry.getToken() << 8 | field_token & 0xFF;
        JcImportTokenTableEntry new_field_entry = new JcImportTokenTableEntry(3, class_name + "/" + field_name, token);
        this.token_table.addElement(new_field_entry);
        return new_field_entry;
    }

    public JcImportTokenTableEntry getPackageEntry(String package_name) {
        int i = 0;
        while (i < this.token_table.size()) {
            JcImportTokenTableEntry entry = (JcImportTokenTableEntry)this.token_table.elementAt(i);
            if (entry.getType() == 0 && entry.getName().equals(package_name)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public JcImportTokenTableEntry getClassEntry(String class_name) {
        int i = 0;
        while (i < this.token_table.size()) {
            JcImportTokenTableEntry entry = (JcImportTokenTableEntry)this.token_table.elementAt(i);
            if (entry.getType() == 1 && entry.getName().equals(class_name)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public JcImportTokenTableEntry getMethodEntry(String class_name, String method_name, String descriptor) {
        int i = 0;
        while (i < this.token_table.size()) {
            JcImportTokenTableEntry entry = (JcImportTokenTableEntry)this.token_table.elementAt(i);
            if (entry.getType() == 2 && entry.getName().equals(class_name + "/" + method_name + descriptor)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public JcImportTokenTableEntry getFieldEntry(String class_name, String field_name) {
        int i = 0;
        while (i < this.token_table.size()) {
            JcImportTokenTableEntry entry = (JcImportTokenTableEntry)this.token_table.elementAt(i);
            if (entry.getType() == 3 && entry.getName().equals(class_name + "/" + field_name)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public JcImportTokenTableEntry[] getEntries() {
        Object[] entries = new JcImportTokenTableEntry[this.token_table.size()];
        this.token_table.copyInto(entries);
        return entries;
    }

    public PackageDefinition[] getImportPackageInfos() {
        return this.import_packages;
    }

    public void setImportPackageInfos(PackageDefinition[] import_packages) {
        this.import_packages = import_packages;
    }
}

