/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;

public class EfMethod
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    int descriptorIndex;
    private boolean sameVersion;
    private String parentClassName;
    private static final int validFlags = 1053;
    private static final int publicProtectedFlags = 5;
    private static final int abstractFinalFlags = 1040;
    private static final int abstractStaticFlags = 1032;
    private static final int abstractPublicFlags = 1025;

    EfMethod(ExportFile exportFile, String string) {
        super(exportFile);
        this.parentClassName = string;
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.nameIndex);
        this.descriptorIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.descriptorIndex);
    }

    public String name() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
    }

    public String sig() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.descriptorIndex]).contents;
    }

    public boolean isStaticOrInit() {
        return (this.accessFlag & 8) != 0 || this.name().equals("<init>");
    }

    void verify(boolean bl, HashSet hashSet, BitSet bitSet, BitSet bitSet2) {
        if (!EfNames.validMethodName(this.name())) {
            throw new VerifierError("EfMethod.3", this.name());
        }
        if (!EfNames.validMethodDescriptor(this.sig())) {
            throw new VerifierError("EfMethod.4", this.sig());
        }
        try {
            BitSet bitSet3;
            if ((this.accessFlag & 0xFFFFFBE2) != 0) {
                throw new VerifierError("EfMethod.5", this.accessFlag);
            }
            if ((this.accessFlag & 5) == 5) {
                throw new VerifierError("EfMethod.6");
            }
            if ((this.accessFlag & 5) == 0) {
                throw new VerifierError("EfMethod.7");
            }
            if ((this.accessFlag & 0x410) == 1040) {
                throw new VerifierError("EfMethod.8");
            }
            if ((this.accessFlag & 0x408) == 1032) {
                throw new VerifierError("EfMethod.9");
            }
            if (bl && (this.accessFlag & 0x401) != 1025) {
                throw new VerifierError("EfMethod.10");
            }
            if (this.name().equals("<init>") && (this.accessFlag & 8) != 0) {
                throw new VerifierError("EfMethod.11");
            }
            if (!hashSet.add(this)) {
                throw new VerifierError("EfMethod.1");
            }
            BitSet bitSet4 = bitSet3 = this.isStaticOrInit() ? bitSet : bitSet2;
            if (bitSet3.get(this.token)) {
                throw new VerifierError("EfMethod.2", this.token);
            }
            if (!bl && !this.isStaticOrInit()) {
                for (int i = 0; i < this.ef.classes.length; ++i) {
                    if (!this.ef.classes[i].thisName().equals(this.parentClassName)) continue;
                    EfClass efClass = this.ef.classes[i];
                    for (int j = 0; j < efClass.supers.length; ++j) {
                        String string = efClass.superName(j);
                        boolean bl2 = false;
                        for (int k = 0; k < this.ef.classes.length && !bl2; ++k) {
                            if (!this.ef.classes[k].thisName().equals(string)) continue;
                            EfClass efClass2 = this.ef.classes[k];
                            bl2 = true;
                            boolean bl3 = false;
                            short s = 0;
                            for (int i2 = 0; i2 < efClass2.methods.length && !bl3; ++i2) {
                                EfMethod efMethod = efClass2.methods[i2];
                                if (efMethod.isStaticOrInit()) continue;
                                if (efMethod.token > s) {
                                    s = efMethod.token;
                                }
                                if (!efMethod.equals(this)) continue;
                                bl3 = true;
                                if (efMethod.token == this.token) continue;
                                throw new VerifierError("EfMethod.13");
                            }
                            if (bl3 || this.token >= s) continue;
                            throw new VerifierError("EfMethod.14");
                        }
                    }
                }
            }
            bitSet3.set(this.token);
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("EfMethod.12", (Object)this, (Object)verifierError.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof EfMethod)) {
            return false;
        }
        EfMethod efMethod = (EfMethod)object;
        return this.name().equals(efMethod.name()) && this.sig().equals(efMethod.sig());
    }

    public String toString() {
        return EfNames.prettyMethod(this.name(), this.sig());
    }

    public void compareTo(EfMethod efMethod, boolean bl) {
        this.sameVersion = false;
        this.compareCommon(efMethod);
        if ((this.accessFlag & 1) > (efMethod.accessFlag & 1)) {
            throw new VerifierError("RevisionError.25", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) < (efMethod.accessFlag & 0x10) && !bl) {
            throw new VerifierError("RevisionError.26", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x400) < (efMethod.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.27", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void checkEquality(EfMethod efMethod) {
        this.sameVersion = true;
        this.compareCommon(efMethod);
        if ((this.accessFlag & 1) != (efMethod.accessFlag & 1)) {
            throw new VerifierError("RevisionError.24", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) != (efMethod.accessFlag & 4)) {
            throw new VerifierError("RevisionError.24", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) != (efMethod.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.24", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x400) != (efMethod.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.28", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    void compareCommon(EfMethod efMethod) {
        if (this.token != efMethod.token) {
            throw new VerifierError("RevisionError.23", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 8) != (efMethod.accessFlag & 8)) {
            throw new VerifierError("RevisionError.38", (Object)this.name(), (Object)this.parentClassName);
        }
    }
}

