/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.ParseException;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcasm.mask.A51OutputFormatter;
import com.sun.javacard.jcasm.mask.Cref211OutputFormatter;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.MaskLinker;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.SizeOutputFormatter;
import com.sun.javacard.jcasm.mask.jrefmask.JrefOutputFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public class Main {
    static final String PKG_DEBUG_INFO_FILE_NAME = "debug.msk";
    static final String MASK_DEBUG_INFO_FILE_NAME = "maskdebuginfo.zip";
    public static boolean noBanner;
    public static boolean FLAG_32_BIT;

    public static void main(String[] argv) {
        int i;
        String outputFile = "a.out";
        Vector<String> inputList = new Vector<String>();
        String generator = null;
        String configFile = null;
        OutputFormatter backEnd = null;
        boolean debugInfo = false;
        Vector<File> debugFiles = new Vector<File>();
        Globals.mode = 2;
        for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
            if (argv[i].equals("-debug")) {
                Globals.debug = true;
                try {
                    Globals.debugLevel = Integer.decode(argv[++i]);
                }
                catch (NumberFormatException e) {
                    Main.usage(true);
                }
                continue;
            }
            if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-debuginfo")) {
                debugInfo = true;
                continue;
            }
            if (argv[i].equals("-16bit")) {
                FLAG_32_BIT = false;
                continue;
            }
            if (argv[i].equals("-32bit")) {
                FLAG_32_BIT = true;
                continue;
            }
            if (argv[i].equals("-c")) {
                if (++i < argv.length) {
                    configFile = argv[i];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-c")) {
                configFile = argv[i].substring(2);
                continue;
            }
            if (argv[i].equals("-o")) {
                if (++i < argv.length) {
                    outputFile = argv[i];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-o")) {
                outputFile = argv[i].substring(2);
                continue;
            }
            if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("--")) {
                ++i;
                break;
            }
            Object[] args = new Object[]{argv[i]};
            Msg.error("maskMain.1", args);
            Main.usage(true);
        }
        if (!noBanner) {
            Main.banner();
        }
        BufferedReader bufferedReader = null;
        if (configFile != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(configFile));
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
                System.exit(1);
            }
        }
        if (i < argv.length) {
            generator = argv[i++];
            try {
                if (generator.equals("cref")) {
                    Globals.target = 3;
                    backEnd = new CrefOutputFormatter(bufferedReader);
                } else if (generator.equals("a51")) {
                    backEnd = new A51OutputFormatter(bufferedReader);
                } else if (generator.equals("cref211")) {
                    Globals.target = 3;
                    backEnd = new Cref211OutputFormatter(bufferedReader);
                } else if (generator.equals("jref")) {
                    Globals.target = 4;
                    backEnd = new JrefOutputFormatter(bufferedReader);
                } else if (generator.equals("size")) {
                    backEnd = new SizeOutputFormatter(bufferedReader);
                } else {
                    Object[] args = new Object[]{generator};
                    Msg.error("maskMain.20", args);
                    Main.usage(true);
                }
                if (debugInfo && !generator.equals("jref")) {
                    Msg.error("maskMain.21", null);
                    Main.usage(true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            Main.usage(true);
        }
        while (i < argv.length) {
            String fName;
            if ((fName = argv[i++]).startsWith("@")) {
                Main.readListFromFile(inputList, fName.substring(1));
                continue;
            }
            inputList.addElement(fName);
        }
        if (inputList.size() == 0) {
            Main.usage(true);
        }
        RomMask mask = new RomMask();
        Parser parser = null;
        BufferedInputStream bis = null;
        Enumeration e = inputList.elements();
        while (e.hasMoreElements()) {
            String inSpec = (String)e.nextElement();
            try {
                bis = new BufferedInputStream(new FileInputStream(inSpec));
            }
            catch (FileNotFoundException ex) {
                System.err.println(ex);
                ++Globals.errors;
                continue;
            }
            if (debugInfo) {
                int lastSlash = inSpec.lastIndexOf(File.separatorChar);
                if (lastSlash < 0) {
                    lastSlash = inSpec.lastIndexOf(47);
                }
                String debugFileName = inSpec.substring(0, lastSlash + 1) + PKG_DEBUG_INFO_FILE_NAME;
                debugFiles.add(new File(debugFileName));
            }
            if (parser == null) {
                parser = new Parser(bis);
            } else {
                Parser.ReInit(bis);
            }
            Parser.inputSpec = inSpec;
            try {
                JCPackage pack = parser.PackageDeclaration();
                if (Globals.debug) {
                    System.out.println(pack);
                }
                mask.addPackage(pack);
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (ParseException ex) {
                System.err.println(ex);
                ++Globals.errors;
            }
        }
        if (Globals.errors == 0) {
            MaskLinker.link(mask);
            if (Globals.errors == 0) {
                backEnd.format(mask);
            }
        }
        if (Globals.errors == 0 & debugInfo) {
            JrefOutputFormatter dbe = (JrefOutputFormatter)backEnd;
            dbe.writeDebugInfo(debugFiles);
        }
        if (Globals.errors == 0) {
            try {
                FilterOutputStream os;
                if (generator.equals("jref")) {
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputFile));
                    os = zos;
                } else {
                    os = new BufferedOutputStream(new FileOutputStream(outputFile));
                }
                backEnd.write(os);
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        Main.printStatus();
    }

    static void printStatus() {
        if (!noBanner) {
            Object[] status = new Object[]{new Integer(Globals.warnings), new Integer(Globals.errors)};
            Msg.info("maskMain.2", status);
        }
        System.exit(Globals.errors);
    }

    private static void usage(boolean isError) {
        Msg.info("maskMain.10", null);
        Msg.info("maskMain.11", null);
        Msg.info("");
        for (int i = 12; i <= 18; ++i) {
            Msg.info("maskMain." + i, null);
        }
        Msg.info("maskMain.22", null);
        if (isError) {
            System.exit(1);
        }
    }

    private static void banner() {
        Msg.info(ToolsVersion.getProductName() + " " + ToolsVersion.getToolName(4) + ", " + ToolsVersion.getVersionString() + " " + ToolsVersion.getVersion(4));
        Msg.info(ToolsVersion.getCopyrightBanner());
    }

    static void readListFromFile(Vector list, String fName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fName));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                list.addElement(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            ++Globals.errors;
        }
        catch (IOException e) {
            e.printStackTrace();
            ++Globals.errors;
        }
    }

    static {
        FLAG_32_BIT = true;
    }
}

