/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.AbstrInterp;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.DebugComponent;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class Verifier {
    static int verbose = 1;
    static String packageName = null;
    static boolean printTrace = false;

    public static void main(String[] stringArray) {
        int n;
        boolean bl = true;
        for (n = 0; n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) == '-'; ++n) {
            String string = stringArray[n];
            if (string.equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (string.equals("-nobanner")) {
                bl = false;
                continue;
            }
            if (string.equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (string.equals("-help")) {
                Verifier.printUsageAndExit();
                continue;
            }
            if (string.equals("-version")) {
                Messages.println("Main.3", new Object[]{ToolsVersion.getProductName(), ToolsVersion.getVersion(2)});
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            if (string.equals("-package") && n + 1 < stringArray.length) {
                packageName = stringArray[++n];
                continue;
            }
            Verifier.printUsageAndExit();
        }
        if (n == stringArray.length) {
            Verifier.printUsageAndExit();
        }
        if (verbose >= 1 && bl) {
            Messages.println("Main.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        boolean bl2 = false;
        while (n < stringArray.length) {
            try {
                String string = stringArray[n];
                File file = new File(string);
                if (string.endsWith(".exp")) {
                    ImportComponent.readExportFile(file);
                } else {
                    if (verbose >= 1) {
                        Messages.println("Main.4", string);
                    }
                    Messages.numWarning = 0;
                    Cap.readComponents(file);
                    Verifier.consistencyChecks();
                    if (verbose >= 1) {
                        Messages.println("Main.5", Messages.numWarning);
                    }
                    bl2 = true;
                }
            }
            catch (VerifierError verifierError) {
                Messages.printTo(System.err);
                Messages.println("Main.2", Messages.numWarning, (Object)verifierError.getMessage(), (Object)Messages.format("Main.6"));
                System.exit(2);
            }
            ++n;
        }
        if (!bl2 && verbose >= 1) {
            Verifier.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("Main.1");
        System.exit(2);
    }

    private static void consistencyChecks() {
        Cap.Header.verify();
        if (Cap.debugComponentDataBuffer != null) {
            if (Cap.Header.minorVersion() == 2) {
                Cap.Debug = new DebugComponent(Cap.debugComponentDataBuffer);
            } else {
                Cap.addCustomComponent(Cap.debugComponentDataBuffer, Cap.debugComponentTag);
            }
        }
        Cap.Directory.verify();
        Cap.Descriptor.verify();
        Cap.Import.verify();
        if (Cap.Export != null) {
            Cap.Export.findExportFile();
        }
        Cap.Import.initialize();
        Classref.initialize();
        AbstrInterp.initialize();
        Cap.ConstantPool.verify();
        Cap.Class.verify();
        Cap.Method.verify();
        Cap.StaticField.verify();
        Cap.ReferenceLocation.verify();
        if (Cap.Applet != null) {
            Cap.Applet.verify();
        }
        if (Cap.Export != null) {
            Cap.Export.verify();
        }
        Cap.Import.checkUnreferencedPackages();
        Cap.Header.checkIntFlag();
        if (Cap.Debug != null && Cap.capMinorVersion == 2) {
            Cap.Debug.verify();
        }
    }

    public static void verifyCap(FileInputStream fileInputStream, String string, Vector vector) throws Exception {
        packageName = string;
        for (int i = 0; i < vector.size(); ++i) {
            ImportComponent.readExportFile((File)vector.elementAt(i));
        }
        Cap.readComponents(fileInputStream);
        Verifier.consistencyChecks();
    }
}

