/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CPInfo;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassFieldsTable;
import com.sun.javacard.components.caputils.ClassMemberInfo;
import com.sun.javacard.components.caputils.ClassMethodTable;
import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassFile {
    public static final short CL_FLAG_ACC_PUBLIC = 1;
    public static final short CL_FLAG_ACC_FINAL = 16;
    public static final short CL_FLAG_ACC_SUPER = 32;
    public static final short CL_FLAG_ACC_INTERFACE = 512;
    public static final short CL_FLAG_ACC_ABSTRACT = 1024;
    public static final byte[] MAGIC = new byte[]{-54, -2, -70, -66};
    public static final short minorVersion = 0;
    public static final short majorVersion = 50;
    public static final short attributeCount = 0;
    private ClassConstantPool constantPool;
    public short accessFlags;
    private short thisClass;
    private short superClass;
    short interfaceCount;
    short[] interfaces;
    ClassFieldsTable classFields;
    ClassMethodTable classMethods;
    private int cpEntryCount = 0;
    private int interfaceEntryCount = 0;
    private int fieldEntryCount = 0;
    private int methodEntryCount = 0;
    private int attributeEntryCount = 0;
    String className;

    public void setClassName(String clName) {
        this.className = clName;
    }

    public void setThisClass(short index) {
        this.thisClass = index;
    }

    public void setSuperClass(short index) {
        this.superClass = index;
    }

    public void setAccessFlags(int flags) {
        short classAccessFlags = 0;
        if ((flags & 1) == 1) {
            classAccessFlags = (short)(classAccessFlags | 1);
        }
        if ((flags & 0x10) == 16) {
            classAccessFlags = (short)(classAccessFlags | 0x10);
        }
        if ((flags & 0x40) == 64) {
            classAccessFlags = (short)(classAccessFlags | 0x200);
        }
        if ((flags & 0x80) == 128) {
            classAccessFlags = (short)(classAccessFlags | 0x400);
        }
        if ((flags & 0x40) != 64) {
            classAccessFlags = (short)(classAccessFlags | 0x20);
        }
        this.accessFlags = classAccessFlags;
    }

    public void setConstantPool(ClassConstantPool cp) {
        this.constantPool = cp;
    }

    public void setInterfaceCount(short count) {
        this.interfaceCount = count;
        this.interfaces = new short[this.interfaceCount];
    }

    public void setInterfaceEntry(short cpIndex) {
        this.interfaces[this.interfaceEntryCount++] = cpIndex;
    }

    public void setMethodTable(ClassMethodTable cmt) {
        this.classMethods = cmt;
    }

    public void setFieldTable(ClassFieldsTable cft) {
        this.classFields = cft;
    }

    public void write(OutputStream os) {
        int i;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(MAGIC, 0, MAGIC.length);
        bos.write(Util.getShortBytes((short)0), 0, 2);
        bos.write(Util.getShortBytes((short)50), 0, 2);
        short constantPoolEntryCount = this.constantPool.getConstantPoolEntryCount();
        constantPoolEntryCount = (short)(constantPoolEntryCount + 1);
        byte[] cpCountBytes = Util.getShortBytes(constantPoolEntryCount);
        bos.write(cpCountBytes, 0, 2);
        for (i = 1; i <= constantPoolEntryCount - 1; ++i) {
            CPInfo cpinfo = this.constantPool.getConstantPoolEntryAt(i);
            cpinfo.write(bos);
        }
        bos.write(Util.getShortBytes(this.accessFlags), 0, 2);
        bos.write(Util.getShortBytes(this.thisClass), 0, 2);
        bos.write(Util.getShortBytes(this.superClass), 0, 2);
        bos.write(Util.getShortBytes(this.interfaceCount), 0, 2);
        for (i = 0; i < this.interfaceCount; ++i) {
            bos.write(Util.getShortBytes(this.interfaces[i]), 0, 2);
        }
        short fieldCount = this.classFields.getFieldCount();
        bos.write(Util.getShortBytes(fieldCount), 0, 2);
        Enumeration enumeration = this.classFields.getClassFields();
        while (enumeration.hasMoreElements()) {
            ClassMemberInfo field = (ClassMemberInfo)enumeration.nextElement();
            field.write(bos);
        }
        short methodCount = this.classMethods.getMethodCount();
        bos.write(Util.getShortBytes(methodCount), 0, 2);
        enumeration = this.classMethods.getClassMethods();
        while (enumeration.hasMoreElements()) {
            ClassMemberInfo method = (ClassMemberInfo)enumeration.nextElement();
            method.write(bos);
        }
        bos.write(Util.getShortBytes((short)0), 0, 2);
        ClassReader cr = new ClassReader(bos.toByteArray());
        ClassWriter cw = new ClassWriter(2);
        cr.accept((ClassVisitor)cw, 0);
        byte[] out = cw.toByteArray();
        try {
            os.write(out);
            bos.close();
            os.flush();
            os.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void print() {
        int i;
        Util.printArray("Magic: ", MAGIC, MAGIC.length);
        Util.printArray("Minor Version: ", Util.getShortBytes((short)0), 2);
        Util.printArray("Major Version: ", Util.getShortBytes((short)50), 2);
        int constantPoolEntryCount = this.constantPool.getConstantPoolEntryCount();
        byte[] cpCountBytes = Util.getShortBytes((short)constantPoolEntryCount);
        Util.printArray("Constant Pool Count (" + constantPoolEntryCount + "): ", cpCountBytes, 2);
        System.out.println("************* CONSTANT POOL ENTRIES *************");
        for (i = 1; i <= constantPoolEntryCount; ++i) {
            System.out.println("Constant Pool Entry Number: " + Integer.toHexString(i));
            CPInfo cpinfo = this.constantPool.getConstantPoolEntryAt(i);
            cpinfo.print();
        }
        System.out.println("********* END OF CONSTANT POOL ENTRIES *********");
        Util.printArray("Access flags: ", Util.getShortBytes(this.accessFlags), 2);
        Util.printArray("this_class: ", Util.getShortBytes(this.thisClass), 2);
        Util.printArray("super_class: ", Util.getShortBytes(this.superClass), 2);
        Util.printArray("Interface Count (" + this.interfaceCount + "): ", Util.getShortBytes(this.interfaceCount), 2);
        for (i = 0; i < this.interfaceCount; ++i) {
            Util.printArray("Interface Number " + i + ": ", Util.getShortBytes(this.interfaces[i]), 2);
        }
        System.out.println("********* FIELD INFOs *********");
        short fieldCount = this.classFields.getFieldCount();
        Util.printArray("Field Count (" + fieldCount + "): ", Util.getShortBytes(fieldCount), 2);
        Enumeration enumeration = this.classFields.getClassFields();
        int i2 = 0;
        while (enumeration.hasMoreElements()) {
            ClassMemberInfo field = (ClassMemberInfo)enumeration.nextElement();
            field.print(i2++, "Field");
        }
        System.out.println("********* END FIELD INFOs *********");
        short methodCount = this.classMethods.getMethodCount();
        System.out.println("********* METHOD INFOs *********");
        Util.printArray("Method Count (" + methodCount + "): ", Util.getShortBytes(methodCount), 2);
        enumeration = this.classMethods.getClassMethods();
        i2 = 0;
        while (enumeration.hasMoreElements()) {
            ClassMemberInfo method = (ClassMemberInfo)enumeration.nextElement();
            method.print(i2++, "Method");
        }
        System.out.println("********* END METHOD INFOs *********");
        System.out.println("********* Attribute INFO *********");
        Util.printArray("Attribute Count (0): ", Util.getShortBytes((short)0), 2);
        System.out.println("********* END Attribute INFO *********");
    }
}

