/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcapiandbcprofiler;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.jcapiandbcprofiler.ClassicCAPProcesssor;
import com.sun.javacard.jcapiandbcprofiler.OptionNames;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.cli.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TrimmerHelperCommand
extends SubCommand {
    protected File inFile;
    Vector<File> exportFiles;
    File apiPkgsListFile;
    ClassicCAPProcesssor capProcessor;
    String apiOutputFile = ".";
    String bcOutputFile = ".";
    String cryptOutputFileName = ".";
    Vector<String> apiPkgsList = new Vector();

    public TrimmerHelperCommand(String commandName) {
        super(commandName);
    }

    public void setup() {
        this.addOption((Option)new CommandOption("i", "in"));
        this.addOption((Option)new CommandOption("p", "exportpath"));
        this.addOption((Option)new CommandOption("f", "exportfile"));
        this.addOption((Option)new CommandOption("a", "apiout"));
        this.addOption((Option)new CommandOption("b", "bcout"));
        this.addOption((Option)new CommandOption("c", "cryptoout"));
        this.addOption((Option)new CommandOption("g", "apipkglist"));
    }

    public void processCommandLine() throws Exception {
        String inFileName = null;
        Vector<String> exportPathNames = new Vector<String>();
        Vector<String> exportFileNames = new Vector<String>();
        block9: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case IN: {
                    inFileName = option.getValue();
                    continue block9;
                }
                case EXPORTPATH: {
                    exportPathNames.addElement(option.getValue());
                    continue block9;
                }
                case EXPORTFILE: {
                    exportFileNames.addElement(option.getValue());
                    continue block9;
                }
                case APIOUT: {
                    this.apiOutputFile = option.getValue();
                    continue block9;
                }
                case BCOUT: {
                    this.bcOutputFile = option.getValue();
                    continue block9;
                }
                case CRYPTOOUT: {
                    this.cryptOutputFileName = option.getValue();
                    continue block9;
                }
                case APIPKGLIST: {
                    this.apiPkgsListFile = new File(option.getValue());
                }
            }
        }
        if (inFileName == null) {
            throw new Exception("CAP file not provided");
        }
        this.inFile = new File(inFileName);
        if (!this.inFile.exists()) {
            throw new Exception("Provided CAP file does not exist");
        }
        if (this.apiPkgsListFile == null) {
            throw new Exception("API packages list file not provided");
        }
        if (!this.apiPkgsListFile.exists()) {
            throw new Exception("Proivided API packages list file does not exist");
        }
        if (!this.apiPkgsListFile.exists()) {
            throw new Exception("Invalid API packages list file provided");
        }
        this.processAPIPkgsListFile();
        this.exportFiles = new Vector();
        for (String s : exportPathNames) {
            File folder = new File(s);
            if (!folder.exists()) {
                throw new Exception("Provided export path does not exist");
            }
            if (!folder.isDirectory()) {
                throw new Exception("Provided export path is not a directory");
            }
            this.populateExportFiles(this.exportFiles, folder);
        }
        for (String s : exportFileNames) {
            File f = new File(s);
            if (!f.exists()) {
                throw new Exception("Provided export file " + s + " does not exist");
            }
            this.exportFiles.addElement(f);
        }
        this.capProcessor = new ClassicCAPProcesssor(this.inFile, this.exportFiles, this.apiPkgsList);
    }

    private void populateExportFiles(Vector<File> exportFiles, File f) {
        File[] files;
        if (f.isFile()) {
            if (f.getName().endsWith(".exp")) {
                exportFiles.addElement(f);
            }
            return;
        }
        for (File x : files = f.listFiles(new FileFilter(){

            public boolean accept(File p) {
                return p.isDirectory() || p.getName().endsWith(".exp");
            }
        })) {
            this.populateExportFiles(exportFiles, x);
        }
    }

    private void processAPIPkgsListFile() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.apiPkgsListFile));
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith(" ")) continue;
                this.apiPkgsList.addElement(line.trim() + ".");
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

