/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.sun.javacard.debugproxy.types.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BreakPointsPool {
    private static final int NULL_LOCATION_ID = 0;
    private static final int EXTERNAL_BREAKPOINT_MASK = 0x1000000;
    private static volatile int offCardId = 0x1000000;
    private HashMap<Integer, LocationContainer> pool = new HashMap();

    public synchronized Set<EventFilter> getAllRequests(Filter<EventFilter> filter) {
        HashSet<EventFilter> retVal = new HashSet<EventFilter>();
        for (LocationContainer container : this.pool.values()) {
            for (EventFilter current : container.requests) {
                if (!filter.accept(current)) continue;
                retVal.add(current);
            }
        }
        return retVal;
    }

    public synchronized void clearLocations(Filter<Location> criteria) {
        Iterator<Map.Entry<Integer, LocationContainer>> i = this.pool.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, LocationContainer> e = i.next();
            Location location = e.getValue().location;
            if (location == null || !criteria.accept(location)) continue;
            i.remove();
        }
    }

    public synchronized List<EventFilter> unregisterAll(Collection<Location> outForUnregisteredLocations, Filter<EventFilter> filter) {
        ArrayList<EventFilter> retVal = new ArrayList<EventFilter>();
        for (Map.Entry<Integer, LocationContainer> e : new ArrayList<Map.Entry<Integer, LocationContainer>>(this.pool.entrySet())) {
            if (!this.unregister(e.getKey(), retVal, filter)) continue;
            outForUnregisteredLocations.add(e.getValue().location);
        }
        return retVal;
    }

    public synchronized void clearAll() {
        this.pool.clear();
    }

    public synchronized boolean unregister(int id, Collection<EventFilter> outForUnregistered, Filter<EventFilter> filter) {
        LocationContainer container = this.pool.get(id);
        if (container == null) {
            return false;
        }
        Iterator<EventFilter> i = container.requests.iterator();
        while (i.hasNext()) {
            EventFilter removed = i.next();
            if (!filter.accept(removed)) continue;
            i.remove();
            outForUnregistered.add(removed);
        }
        if (container.requests.isEmpty() && container.location != null) {
            this.pool.remove(id);
            return true;
        }
        return false;
    }

    public synchronized Set<EventFilter> getRequests(int id) {
        LocationContainer container = this.pool.get(id);
        Set<EventFilter> set = container == null ? Collections.emptySet() : container.requests;
        return set;
    }

    public static int locationToId(Location location) {
        if (location.meth == null) {
            return offCardId++;
        }
        int offset = (int)((long)location.meth.getCodeOffset() + location.offset);
        return (location.cl.getPackageID() << 16 | offset & 0xFFFF) & 0xFFFFFF;
    }

    public synchronized boolean register(Location location, EventFilter request) {
        int breakpointID = BreakPointsPool.locationToId(location);
        return this.register(breakpointID, location, request);
    }

    public synchronized void resetEventCountModifier() {
        for (EventFilter filter : this.getAllRequests(new CountBPFilter())) {
            ((EventFilter.CountModifier)filter.getModifier(1)).resetCount();
        }
    }

    public synchronized void register(EventFilter request) {
        this.register(0, null, request);
    }

    private synchronized boolean register(int breakpointID, Location location, EventFilter request) {
        if ((breakpointID & 0x1000000) != 0) {
            return false;
        }
        if (this.pool.containsKey(breakpointID)) {
            this.pool.get((Object)Integer.valueOf((int)breakpointID)).requests.add(request);
            return false;
        }
        this.pool.put(breakpointID, new LocationContainer(request, location));
        return true;
    }

    private static class LocationContainer {
        Location location;
        HashSet<EventFilter> requests = new HashSet();

        public LocationContainer(EventFilter request, Location location) {
            this.location = location;
            this.requests.add(request);
        }
    }

    public static class IDFilter
    implements Filter<EventFilter> {
        private int requestID;

        public IDFilter(int requestID) {
            this.requestID = requestID;
        }

        @Override
        public boolean accept(EventFilter value) {
            return this.requestID == value.getID();
        }
    }

    private static class CountBPFilter
    implements Filter<EventFilter> {
        private CountBPFilter() {
        }

        @Override
        public boolean accept(EventFilter value) {
            return value.hasCountModifier();
        }
    }

    public static class KindFilter
    implements Filter<EventFilter> {
        private Kind kind;

        public KindFilter(Kind kind) {
            this.kind = kind;
        }

        @Override
        public boolean accept(EventFilter value) {
            return value.getKind() == this.kind;
        }
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

