#!/bin/sh
set -e
ROOTDIR=$(git rev-parse --show-toplevel)
git describe --abbrev=8 --dirty | sed 's/v\([^-]*\)-\([^-]*\)-\(.*\)/\1.dev\2.\3/' > $ROOTDIR/.version
cat $ROOTDIR/.version
echo "# osmo-gsm-tester version.
# Automatically generated by update_version.sh.
# Gets imported by __init__.py.

_version = '$(cat $ROOTDIR/.version)'" \
  > $ROOTDIR/src/osmo_gsm_tester/_version.py
