# TP (objectives) implemented
- TP_5GNAS_AMF_AUT_REQ_01 (FF)
    - Verify that the IUT sends an AUTHENTICATION REQUEST message correctly upon receipt of a NAS Registration without an active security context.

- TP_5GNAS_AMF_AUT_REQ_02 (FF)
    - Verify that the IUT sends an AUTHENTICATION REJECT message correctly upon receipt of an AUTHENTICATION RESPONSE message indicating a wrong ARP IEI.

- TP_5GNAS_AMF_AUT_REQ_03 (FF)
    - 5.4.1.3.7.b)
    - Verify that the IUT stops re-sending an AUTHENTICATION REQUEST message if no AUTHENTICATION RESPONSE message is received on the fifth expiry of timer T3560.

- TP_5GNAS_AMF_AUT_REQ_04 (FF)
    - Verify that the IUT sends an IDENTITY REQUEST message correctly upon receipt of an AUTHENTICATION FAILURE message indicating a 5GMM cause value #20 - MAC failure.

- TP_5GNAS_AMF_AUT_REQ_05 (FF)
    - Verify that the IUT sends a new AUTHENTICATION REQUEST message with new ngKSI value to re-initiate the 5G AKA based primary authentication upon receipt of an AUTHENTICATION FAILURE message indicating a 5GMM cause value #71 - ngKSI already in use.

- TP_NGNAS_AMF_AUT_SEQ_01 (FF)
    - Verify that the IUT sends a SECURITY MODE CONTROL message correctly to indicate NAS security mode procedure upon receipt of a NAS AUTHENTICATION RESPONSE.

- TP_5GNAS_AMF_REG_REJ_01 (SINTESIO)
    - Verify that the IUT rejects initial registration request due to general NAS level mobility management congestion control with 5GMM cause value #22 - congestion and assign a value for back-off timer T3346.

- TP_5GNAS_AMF_REG_REJ_02 (SINTESIO)
    - Verify that the IUT rejects initial registration request because all the S-NSSAI(s) included in the requested NSSAI are either rejected for current PLMN, rejected for the current registration area or rejected due to failed or revoked NSSAIs.

## Section 5.5.1.2.4: Initial registration accepted by the network (SINTESIO)
- TP_5GNAS_AMF_REG_ACC_01
    - Verify that the IUT sends a REGISTRATION ACCEPT message containing the 5GS registration result, TAI list, 5G-GUTI and T3512 when initial registration is accepted by the network.

- TP_5GNAS_AMF_REG_ACC_02
    - Verify that the IUT sends a REGISTRATION ACCEPT message indicating SMS over NAS allowed when initial registration with SMS over NAS is requested and network allows SMS service.

- TP_5GNAS_AMF_REG_ACC_03
    - Verify that the IUT sends a REGISTRATION ACCEPT message indicating SMS over NAS not allowed when initial registration with SMS over NAS is requested and network does not support SMS service.

## Section 5.4.1.3.7 (FF)
- TP_5GNAS_AMF_AUT_ABN_01
    - Verify that the IUT sends a new IDENTITY REQUEST message to obtain the SUCI from the UE upon receipt of an AUTHENTICATION FAILURE message indicating a 5GMM cause value #26 - non-5G authentication unacceptable. (FF)
        - This case is also valid in cases where the UE send Auth Response, but the response parameters do not match.
        - Please check Note 2: "... the network may also terminate the 5G AKA based primary authentication ..." Depends on ID used in Initial NAS message

## Section 5.4.2: Security mode control procedure (FF)
- TP_5GNAS_AMF_SEC_ACC_01
    - Verify that the IUT, upon receiving the NAS Security Mode Complete Message after completing the NAS Authentication and Security procedure, successfully completes the registration process by accepting the registration.

- TP_5GNAS_AMF_SEC_REJ_01
    - Verify that the IUT, upon receiving the NAS Security Mode Reject Message after a failed NAS Authentication and security procedure, successfully aborts the registration process by rejecting the registration.
    
## Section 5.4.5: NAS transport procedure (FF) ( 8.2.10, 8.2.11)
- TP_5GNAS_AMF_DLN_ACC_01
    - Verify that the IUT correctly handles a UL NAS transport message containing a PDU SESSION ESTABLISHMENT REQUEST from the UE and responds with a DL NAS transport message containing a PDU SESSION ESTABLISHMENT ACCEPT.

## Section 5.5.1.2.4: Initial registration accepted by the network (SINTESIO)
- TP_5GNAS_AMF_REG_ACC_04
    - Verify that the IUT includes the allowed NSSAI in the REGISTRATION ACCEPT message when the UE includes a requested NSSAI in the REGISTRATION REQUEST message and the network allows one or more S-NSSAIs from the requested NSSAI.

- TP_5GNAS_AMF_REG_ACC_05
    - Verify that the IUT optionally includes rejected NSSAI in the REGISTRATION ACCEPT message when the network rejects one or more S-NSSAIs from the requested NSSAI.


## Section 5.5.2.2.3 UE-initiated de-registration procedure completion (SINTESIO)
- TP_5GNAS_AMF_DRG_ACC_01
    - Verify that the IUT, upon receiving a DEREGISTRATION REQUEST message containing the De-registration type IE with "Normal de-registration" from the UE, sends a DEREGISTRATION ACCEPT message.

- TP_5GNAS_AMF_DRG_ACC_02
    - Verify that the IUT, upon receiving a DEREGISTRATION REQUEST message containing the De-registration type IE with "Switch off" from the UE, does not send a DEREGISTRATION ACCEPT message and IUT completes de-registration procedure.

## Section 5.5.2.3.1 Network-initiated de-registration procedure initiation (SINTESIO)
- TP_5GNAS_AMF_DRG_REQ_01
    - Verify that the IUT initiates network de-registration by sending a DEREGISTRATION REQUEST message containing De-registration type IE with re-registration not required and the access type based on the UE’s registration status (3GPP access only). **NOTE:** explicit network deregistration triggered by O&M - deactivation of UE

- TP_5GNAS_AMF_DRG_REQ_02
    - Verify that the IUT initiates network de-registration by sending a DEREGISTRATION REQUEST message and if UE does not send DEREGISTRATION ACCEPT then IUT retransmits DEREGISTRATION REQUEST message after timer T3522 expiration. **NOTE:** explicit network deregistration triggered by O&M - UE deregistration

- TP_5GNAS_AMF_DRG_REQ_03
    - Verify that the IUT initiates network de-registration by sending DEREGISTRATION REQUEST message containing De-registration type IE with re-registration required and the access type based on the UE’s registration status (3GPP access only). **NOTE 1:** UE sends DEREGISTRATION ACCEPT and starts with re-registration procedure.(also used ref 5.5.2.3.2 1st paragraph) **NOTE 2:** explicit network deregistration triggered by O&M - UE deregistration



# TP objective ideas reviewed

## Section 5.4.1.3.7 (FF)

- TP_5GNAS_AMF_AUT_ABN_02
    - Verify that the IUT sends a new AUTHENTICATION REQUEST message to re-initiate the 5G AKA based primary authentication upon receipt of an IDENTIFICATION RESPONSE message indicating an incorrect 5G-GUTI to SUPI mapping. (FF)

- TP_5GNAS_AMF_AUT_ABN_03
    - Verify that the IUT sends a AUTHENTICATION REJECT message to terminate the 5G AKA based primary authentication and key agreement authentication procedure upon receipt of an IDENTIFICATION RESPONSE message indicating an correct 5G-GUTI to SUPI mapping. (FF)

- TP_5GNAS_AMF_AUT_ABN_04
    - Verify that the IUT sends a new AUTHENTICATION REQUEST message after a successful re-synchronisation procedure upon receipt of an AUTHENTICATION FAILURE message indicating a 5GMM cause value #21 (Synch failure) and including the AUTS parameter. (FF)


## Section 5.4.2: Security mode control procedure (FF)
- TP_5GNAS_AMF_SEC_ABN_01
    - Verify that the IUT sends a new AUTHENTICATION REQUEST message to re-initiate the 5G AKA based primary authentication upon receipt of an AUTHENTICATION FAILURE message indicating a 5GMM cause value #71 (ngKSI already in use). (FF)    See above in Section 5.4.1.3.7


## ## Section 5.4.3: Identification procedure (FF)
- TP_5GNAS_AMF_IDN_ACC_02
    - Verify that the IUT sends an IDENTITY REQUEST message correctly upon receipt of an AUTHENTICATION FAILURE message indicating a 5GMM cause value #20. (already implemented as: TP_5GNAS_AMF_AUT_REQ_04)

- TP_5GNAS_AMF_IDN_RES_01
    - Verify that the IUT, upon receiving an IDENTITY RESPONSE message from the UE with an incorrect IMSI, correctly sends an AUTHENTICATION REQUEST message. The IDENTITY REQUEST message is triggered during an authentication procedure with a failed authentication (AUTHENTICATION FAILURE).

- TP_5GNAS_AMF_IDN_REJ_01
    - Verify that the IUT, upon receiving an IDENTITY RESPONSE message from the UE with a correct IMSI, correctly sends an AUTHENTICATION REJECT message. The IDENTITY REQUEST message is triggered during an authentication procedure with a failed authentication (AUTHENTICATION FAILURE).

- TP_5GNAS_AMF_IDN_RES_02
    - Verify that the IUT stops re-sending an Identity REQUEST message if no Identity RESPONSE message is received on the fifth expiry of timer T3519.


## Section 5.5.2.3.1 Network-initiated de-registration procedure initiation (SINTESIO)
- TP_5GNAS_AMF_DRG_REQ_04
    - Verify that if de-registration is triggered due to IUT slice-specific authentication and authorization failure or revocation, the network sets the 5GMM cause value to #62 "No network slices available" and includes the rejected NSSAI IE in the DEREGISTRATION REQUEST message.


## 5.5.1.2.8 Abnormal cases on the network side - Initial Registration (SINTESIO)
 - TP_5GNAS_AMF_REG_ABN_01
    - Verify that the IUT retransmits the REGISTRATION ACCEPT message and restarts timer T3550 upon the first four expirations.
    
 - TP_5GNAS_AMF_REG_ABN_02	
	- Verify that the IUT aborts the registration procedure for initial registration and enters the 5GMM-REGISTERED state on the fifth expiry. NOTE: 5GMM-REGISTERED state can be checked over O&M

 - TP_5GNAS_AMF_REG_ABN_03
    - Verify that the IUT aborts the registration procedure for initial registration and enters the 5GMM-REGISTERED state when a lower layer failure occurs before receiving the REGISTRATION COMPLETE message while timer T3550 is running. NOTE: 5GMM-REGISTERED state can be checked over O&M
    
 - TP_5GNAS_AMF_REG_ABN_04  [BPIN: It shall be investigate what kind of message can be constructed to get proposed cause. Should be possible since 5G-NAS is not ASN1 and therefore type system fully controled by ttcn-3]
	- Verify that the IUT responds to a REGISTRATION REQUEST message with a protocol error by sending a REGISTRATION REJECT message with appropriate 5GMM cause values:
        #96: Invalid mandatory information
        #99: Information element non-existent or not implemented
        #100: Conditional IE error
        #111: Protocol error, unspecified.

 - TP_5GNAS_AMF_REG_ABN_05	
	- Verify that the IUT aborts the previous registration procedure and initiates a new registration procedure if the information elements in a second REGISTRATION REQUEST message differ from those in the first  and if the REGISTRATION COMPLETE message has not been received for first registration.
        
 - TP_5GNAS_AMF_REG_ABN_06	
	- Verify that the IUT resends the REGISTRATION ACCEPT message and restarts T3550 if the information elements in the first and second REGISTRATION REQUEST message do not differ and if the REGISTRATION COMPLETE message has not been received for first registration. The retransmission counter related to T3550 is not incremented.

 - TP_5GNAS_AMF_REG_ABN_07		
    - Verify that the IUT aborts the registration procedure for initial registration and progresses the de-registration procedure as specified when a DEREGISTRATION REQUEST is received before the REGISTRATION COMPLETE message.

 - TP_5GNAS_AMF_REG_ABN_08
    - Validate that the AMF rejects a REGISTRATION REQUEST message with invalid or unacceptable UE security capabilities by sending a REGISTRATION REJECT message.

## 5.5.2.3.5 Abnormal cases in the network side (SINTESIO)
- TP_5GNAS_AMF_DRG_ABN_01
    - Verify that the IUT retransmits DEREGISTRATION REQUEST message after timer T3522 expiration four times (i.e. on the fifth expiry of timer T3522, the de-registration procedure shall be aborted).
	
- TP_5GNAS_AMF_DRG_ABN_02	
    - Verify that if IUT receives a DEREGISTRATION REQUEST message with "switch off" indication, before the network-initiated de-registration procedure has been completed, both procedures shall be considered completed.

- TP_5GNAS_AMF_DRG_ABN_03
    - Verify that if IUT receives a DEREGISTRATION REQUEST message without "switch off" indication, before the network-initiated de-registration procedure has been completed, the IUT shall send a DEREGISTRATION ACCEPT message to the UE.

- TP_5GNAS_AMF_DRG_ABN_04
    - Verify that if IUT receives a REGISTRATION REQUEST message indicating "initial registration" in the 5GS registration type IE before the network-initiated de-registration procedure has been completed, the IUT shall aborted the de-registration procedure and the registration procedure shall be progressed.

- TP_5GNAS_AMF_DRG_ABN_05
    - Verify that if IUT sends a DEREGISTRATION REQUEST message without 5GMM cause value #11, #12, #13 or #15 and the IUT receives a REGISTRATION REQUEST message indicating either "mobility registration updating" or "periodic registration updating" in the 5GS registration type IE before the network-initiated de-registration procedure has been completed, the de-registration procedure shall be progressed, i.e. the REGISTRATION REQUEST message shall be ignored.

- TP_5GNAS_AMF_DRG_ABN_06
    - Verify that if IUT sends a DEREGISTRATION REQUEST message with 5GMM cause value #11, #12, #13 or #15 and the IUT receives a REGISTRATION REQUEST message indicating either "mobility registration updating" or "periodic registration updating" in the 5GS registration type IE before the network-initiated de-registration procedure has been completed, the de-registration procedure shall be aborted and the registration procedure shall be progressed.

- TP_5GNAS_AMF_DRG_ABN_07
    - Verify that if IUT receives a SERVICE REQUEST message or a CONTROL PLANE SERVICE REQUEST message before the network-initiated de-registration procedure has been completed (e.g. the DEREGISTRATION REQUEST message is pending to be sent to the UE), the network shall progress the de-registration procedure.


## 6.3.1.1 (FF)
- TP_5GNAS_AMF_UPA_ACC_01
    - Verify that the IUT, upon receiving the PDU SESSION AUTHENTICATION COMPLETE Message after completing the PDU session authentication and authorization procedure, successfully completes the process by sending PDU SESSION ESTABLISHMENT ACCEPT.

## 6.3.1.2.3 Abnormal cases on the network side (FF)
- TP_5GNAS_AMF_UPA_ABN_01
    - Verify that the IUT retransmits PDU SESSION AUTHENTICATION COMMAND message after timer T3590 expiration first time.

- TP_5GNAS_AMF_UPA_ABN_02
    - Verify that the IUT aborts the procedure after timer T3590 expiration four times.


## 6.4.1.3 UE-requested PDU session establishment procedure accepted by the network (FF)
 - TP_5GNAS_AMF_UPE_ACC_01
    - Verify that the IUT, upon receiving the PDU SESSION ESTABLISHMENT REQUEST from the UE with correct data and with type initial request, sends PDU SESSION ESTABLISHMENT ACCEPT meesage


## 6.4.1.7 Abnormal cases on the network side (FF)
- TP_5GNAS_AMF_UPE_ABN_01
    - Verify that the IUT sends a PDU SESSION ESTABLISHMENT REJECT with cause #31 (request rejected, unspecified), when the UE sends a PDU SESSION ESTABLISHMENT REQUEST with type initial emergency request and there is already a emergency PDU session for the UE.
    Note: possible, that the IUT releases the existing emergency session and don't sends a REJECT. Maybe implementation-dependend?

- TP_5GNAS_AMF_UPE_ABN_02
    - Verify that the IUT sends a PDU SESSION ESTABLISHMENT REJECT with cause #54 (PDU session does not exist), when the UE sends a PDU SESSION ESTABLISHMENT REQUEST with type existing PDU session and there is no PDU session with that ID.

- TP_5GNAS_AMF_UPE_ABN_03
    - Verify that the IUT sends a PDU SESSION ESTABLISHMENT REJECT with cause #29 (user authentication or authorization failed), when the UE sends a PDU SESSION ESTABLISHMENT REQUEST with type initial request and the provided authentication and authorization data don't match local policy and user's subscription data.


## 6.4.2.4.1 UE-requested PDU session modification procedure not accepted by the network (FF)
- TP_5GNAS_AMF_UPN_REJ_01
    - Verify the IUT, upon receiving a PDU SESSION MODIFICATION REQUEST by the UE with a request of LADN modification and UE outside service area, sends a SESSION MODIFICATION REJECT with reason #46 (out of LADN service area).

- TP_5GNAS_AMF_UPN_REJ_02
    - Verify the IUT, upon receiving a PDU SESSION MODIFICATION REQUEST by the UE with a request for a not supported service by the PLMN, sends a SESSION MODIFICATION REJECT with reason #32 (Service option not supported). 

- TP_5GNAS_AMF_UPN_REJ_03
    - Verify the IUT, upon receiving a PDU SESSION MODIFICATION REQUEST by the UE with a request including a PTI that is already in use, sends a SESSION MODIFICATION REJECT with reason #35 (PTI already in use).

- TP_5GNAS_AMF_UPN_REJ_04
    - Verify the IUT, upon receiving a PDU SESSION MODIFICATION REQUEST by the UE with a request for a wrong 5QI, sends a SESSION MODIFICATION REJECT with reason #59 (Unsupported 5QI value).

## 6.4.3.2, 6.4.3.4 (FF)
- TP_5GNAS_AMF_UPR_REJ_01
    - Verify that the IUT sends correctly a PDU SESSION RELEASE REJECT after receiving a PDU SESSION RELEASE REQUEST by the UE and not accepts the session release with reason #35 (PTI already in use).

- TP_5GNAS_AMF_UPR_REJ_02
    - Verify that the IUT sends correctly a PDU SESSION RELEASE REJECT after receiving a PDU SESSION RELEASE REQUEST by the UE and not accepts the session release with reason #43 (Invalid PDU session identity).
    Note: there can be other protocol reasons for not accepting the PDU Session release


## 6.4.3.6 Abnormal cases on the network side (FF)
- TP_5GNAS_AMF_UPR_ABN_01
    - Verify that the IUT sends correctly a PDU SESSION RELEASE REJECT after receiving a PDU SESSION RELEASE REQUEST with a wrong PDU Sesiion ID by the UE and not accepts the session release with reason #43 (Invalid PDU session identity).

## 5.6.1.1
- TP_5GNAS_AMF_SRP_ACC_01
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE, that was initated by a paging request to the UE in 5GMM-IDLE mode over 3GPP access.

- TP_5GNAS_AMF_SRP_ACC_02
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE, that was initated by a notification with access type indicating non-3GPP access to the UE while in 5GMM-CONNECTED mode over 3GPP access.

- TP_5GNAS_AMF_SRP_ACC_03
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to having uplink signalling pending while in 5GMM-CONNECTED mode over 3GPP access.

- TP_5GNAS_AMF_SRP_ACC_04
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to having uplink user data pending while in 5GMM-CONNECTED mode over 3GPP access.

- TP_5GNAS_AMF_SRP_ACC_05
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to having user data pending due to no user-plane resources established for PDU session(s) used for user data transport while in 5GMM-CONNECTED mode.

- TP_5GNAS_AMF_SRP_ACC_06
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to having user data pending due to no user-plane resources established for PDU session(s) used for user data transport while in 5GMM-CONNECTED mode with RRC inactive indication.

- TP_5GNAS_AMF_SRP_ACC_07
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to receiving a request from the upper layers to perform emergency service fallback while in 5GMM-IDLE mode.

- TP_5GNAS_AMF_SRP_ACC_08
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to receiving a request from the upper layers to perform emergency service fallback while in  5GMM-CONNECTED mode over 3GPP access.

- TP_5GNAS_AMF_SRP_ACC_09
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to receiving a request from the upper layers to perform emergency service fallback while in 5GMM-CONNECTED mode with RRC inactive indication.

- TP_5GNAS_AMF_SRP_ACC_10
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to using 5GS services with control plane CIoT 5GS optimization and has pending user data to be sent via user-plane resources while in 5GMM-CONNECTED mode and has a NAS signalling connection only.

- TP_5GNAS_AMF_SRP_ACC_11
    - Verify that the IUT sends a SERVICE ACCEPT message after receiving a SERVICE REQUEST message by the UE due to requesting resources for V2X communication over PC5 while in 5GMM-IDLE mode over 3GPP access.

## 6.4.3.2, 6.4.3.4 (FF)
- TP_5GNAS_AMF_UPR_ACC_01
    - Verify that the IUT handles correctly a PDU session release by sending a PDU SESSION RELEASE COMAND with cause #36 (regular deactivation) after receiving a PDU SESSION RELEASE REQUEST by the UE with cause #36 (regular deactivation).## 5.4.6 5GMM status procedure (SINTESIO)
## 5.4.6.2 5GMM status received in the UE
- TP_5GNAS_AMF_EST_STA_01
    - Verify that IUT is able to trigger 5GMM STATUS message with all mandatory IEs. 
## 5.4.6.3 5GMM status received in the network
- TP_5GNAS_AMF_EST_STA_02
    - Verify that IUT is able to receive 5GMM STATUS message from UE and no state transition and no specific action shall be taken.

## 6.5.2 5GSM status received in the UE  (SINTESIO)
- TP_5GNAS_AMF_SST_STA_01
    - Verify that IUT is able to trigger 5GSM STATUS message with all mandatory IEs. 
## 6.5.3 5GSM status received in the SMF  (SINTESIO)
- TP_5GNAS_AMF_SST_STA_02
    - Verify that IUT is able to receive 5GSM STATUS message from UE and no state transition and no specific action shall be taken.
	
	
## 5.4.4.2 Generic UE configuration update procedure initiated by the network (SINTESIO)
- TP_5GNAS_AMF_CNF_COM_01
    - Verify that the IUT initiates the generic UE configuration update procedure by sending the CONFIGURATION UPDATE COMMAND message and not contains Acknowledgment requested bit in the Configuration update indication IE when only the Network Identity and Time Zone (NITZ) parameter is included.

- TP_5GNAS_AMF_CNF_COM_02
    - Verify that the IUT initiates the generic UE configuration update procedure by sending the CONFIGURATION UPDATE COMMAND message containing one or more parameters (e.g., 5G-GUTI, TAI list,...) and containing Configuration update indication IE with Acknowledgement bit set to "acknowledgement requested"

- TP_5GNAS_AMF_CNF_COM_03
    - Verify that the IUT initiates the generic UE configuration update procedure only due to changes to the allowed NSSAI and
these changes require the UE to initiate a registration procedure then IUT sends the CONFIGURATION UPDATE COMMAND message not containing any other parameters except Configuration update indication IE with the Registration requested bit set to "registration requested" and Acknowledgement bit set to "acknowledgement requested" and

## 5.4.4.4 Generic UE configuration update completion by the network (SINTESIO)

- TP_5GNAS_AMF_CNF_REL_01
    - Verify that the IUT initiates the generic UE configuration update procedure by sending the CONFIGURATION UPDATE COMMAND message containing an allowed NSSAI, a configured NSSAI or both and Configuration update indication IE with the Registration requested bit set to "registration requested" and Acknowledgement bit set to "acknowledgement requested".
and then the IUT initiates the release of the N1 NAS signalling connection.

## 5.4.4.6 Abnormal cases on the network side (SINTESIO)
- TP_5GNAS_AMF_CNF_ABN_01
    - Verify that the IUT retransmits the CONFIGURATION UPDATE COMMAND message and restarts timer T3555 upon the first four expirations. (i.e. on
the fifth expiry of timer T3555, the procedure shall be aborted.)

- TP_5GNAS_AMF_CNF_ABN_02
    - Verify that IUT aborts the generic UE configuration update procedure
and progress the de-registration procedure in case if the network receives a DEREGISTRATION REQUEST message before the ongoing generic UE configuration
update procedure has been completed
	
- TP_5GNAS_AMF_CNF_ABN_03
    - Verify that IUT aborts the generic UE configuration update procedure
and progress the registration procedure for mobility and periodic registration update procedure in case if the network receives a REGISTRATION REQUEST message before the ongoing generic UE configuration
update procedure has been completed

- TP_5GNAS_AMF_CNF_ABN_04
    - Verify that IUT proceeds with both procedures in case if the network receives a SERVICE REQUEST message before the ongoing generic UE configuration update
procedure has been completed



# TP objectives ideas

[BPIN] TODOs for future TTFs

## Section 5.4.5: NAS transport procedure (FF) ( 8.2.10, 8.2.11)
[KSCH] PDU Session control is just one procedure using UL and DL TRANSFERs. Chapter 5.4.5.1 lists 9 different payload container types (a) to (i) most of them are not covered by the proposed TPs till now. [BPIN] Comment is related to "Section 5.4.5: NAS transport procedure" and need to be considered in future to prepare additional TOs

## 6.3.3.2 Network-requested PDU session release procedure initiation (FF)
Note: possible to test? In this case the IUT can't be triggered with a (interface) message.
[KSCH] Potential Tigger is also the UE originateed PDU SESSION RELEASE REQUEST, besides others e.g. O&M Disable SMF 
[KSCH] There are several procedures, which can't be triggered with an interfce message. We should not restrict the environment in that way, as the overall test coverage would be reduced drastically. As mentioned above an O&M Interface has to be supported for other reasons as well. 

##
[KSCH] General Remark on Test Coverage
Potential Procedures to be tested - for the sake of total test coverage
- 5.6.1 Service request procedure (a) to l) 12 different types - some are covered) [BPIN 5.6.1.1 Done]
- 5.6.2 Paging procedure
- 5.6.3 Notification procedure
- 6.3.2 Network-requested PDU session modification


